/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.mservice.ApPayAutoSettleService;
import kd.fi.ap.validator.FinApBillUnSubmitValidator;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;

public class FinApBillUnSubmitOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinApBillUnSubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinApBillUnSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("FinApBillUnSubmitOp.beginOperationTransaction start");
        DynamicObject[] entities = e.getDataEntities();
        List<DynamicObject> needExecuteUnSettleBills = Arrays.stream(entities).filter(entity -> !APSettleStatusEnum.UNSETTLE.getValue().equals(entity.getString("settlestatus"))).collect(Collectors.toList());
        if (needExecuteUnSettleBills.size() > 0) {
            Set idSet = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(idSet, (String)this.billEntityType.getName(), (boolean)false);
            ApPayAutoSettleService iService = new ApPayAutoSettleService();
            iService.unAutoSettle(needExecuteUnSettleBills.toArray(new DynamicObject[0]));
        }
        logger.info("FinApBillUnSubmitOp.beginOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("settlestatus");
        fieldKeys.add("isvoucher");
        fieldKeys.add("quantity");
        fieldKeys.add("amount");
        fieldKeys.add("pricetaxtotal");
        fieldKeys.add("tax");
        fieldKeys.add("e_taxdiffamt");
        fieldKeys.add("e_amountdiffamt");
        fieldKeys.add("e_pricetaxdiffamt");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_amount");
        fieldKeys.add("e_pricetaxtotal");
        fieldKeys.add("e_adjustamount");
        fieldKeys.add("e_unverifyamount");
        fieldKeys.add("e_uninvoicedamt");
        fieldKeys.add("unsettleamt");
        fieldKeys.add("unverifyamount");
        fieldKeys.add("unsettleamount");
        fieldKeys.add("uninvoicedamt");
        fieldKeys.add("unlockamt");
        fieldKeys.add("i_tax");
        fieldKeys.add("i_amount");
        fieldKeys.add("i_pricetaxtotal");
        fieldKeys.add("splitscheme");
        fieldKeys.add("planpricetax");
        fieldKeys.add("unplansettleamt");
        fieldKeys.add("unplanlockamt");
        fieldKeys.add("e_taxlocalamt");
        fieldKeys.add("e_amountbase");
        fieldKeys.add("e_pricetaxtotalbase");
        fieldKeys.add("taxlocamt");
        fieldKeys.add("amountbase");
        fieldKeys.add("pricetaxtotalbase");
        fieldKeys.add("planpricetaxloc");
        fieldKeys.add("unplansettlelocamt");
        fieldKeys.add("e_sourcebillid");
        fieldKeys.add("e_pricetaxtotal");
        fieldKeys.add("basecurrency");
        fieldKeys.add("unsettleamtbase");
        fieldKeys.add("unsettleamountbase");
        fieldKeys.add("lockedamt");
        fieldKeys.add("quotation");
        fieldKeys.add("exchangerate");
        fieldKeys.add("settlementtype");
        fieldKeys.add("planentity.seq");
        fieldKeys.add("planentity.plansettletype");
        fieldKeys.add("planentity.e_freezestate");
    }
}

