/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.fin.PlanEntryDisposer;
import kd.fi.ap.validator.FinApListDeleteValidator;
import kd.fi.ap.validator.FinPaymentSecurityAuditValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.ApTransferWBFinBillServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.validator.BillVerifyAndSettleRecordValidator;

public class FinApListDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApListDeleteOp.class);
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinApListDeleteValidator());
        e.addValidator((AbstractValidator)new BillVerifyAndSettleRecordValidator(false));
        e.addValidator((AbstractValidator)new FinPaymentSecurityAuditValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        logger.info("FinApListDeleteOp.endOperationTransaction start");
        logger.info("FinApListDeleteOp.endOperationTransaction writeBackSrcBillLockAmt start");
        List<DynamicObject> transferBills = Arrays.stream(bills).filter(bill -> bill.getBoolean("istanspay")).collect(Collectors.toList());
        this.writeBackSrcBillLockAmt(transferBills);
        logger.info("FinApListDeleteOp.endOperationTransaction writeBackSrcBillLockAmt end");
        logger.info("FinApListDeleteOp.endOperationTransaction updatePurInvoiceEntry start");
        this.updatePurInvoiceEntry(bills);
        logger.info("FinApListDeleteOp.endOperationTransaction updatePurInvoiceEntry end");
        logger.info("FinApListDeleteOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.removeCache(e.getDataEntities());
    }

    private void writeBackSrcBillLockAmt(List<DynamicObject> transferBills) {
        if (ObjectUtils.isEmpty(transferBills)) {
            return;
        }
        HashSet<Long> srcFinApBillIds = new HashSet<Long>(64);
        for (DynamicObject transferBill : transferBills) {
            DynamicObjectCollection detailEntry = transferBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject dynamicObject : detailEntry) {
                srcFinApBillIds.add(dynamicObject.getLong("e_sourcebillid"));
            }
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(srcFinApBillIds, (String)"ap_finapbill", (boolean)false);
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime((String)"BIZ_V5.0.023_DataUpgrade");
        upgradeTime = upgradeTime == null ? DateUtils.parseDate((String)"2023-07-10", (String)"yyyy-MM-dd") : upgradeTime;
        ArrayList<DynamicObject> oldWriteBackBills = new ArrayList<DynamicObject>(64);
        ArrayList<DynamicObject> newWriteBackBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject dynamicObject : transferBills) {
            if (dynamicObject.getDate("createtime").compareTo(upgradeTime) >= 0) {
                newWriteBackBills.add(dynamicObject);
                continue;
            }
            oldWriteBackBills.add(dynamicObject);
        }
        if (!oldWriteBackBills.isEmpty()) {
            this.writeBackSrcBillLockAmtOld(oldWriteBackBills);
        }
        if (ObjectUtils.isEmpty(newWriteBackBills)) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(64);
        for (DynamicObject needDisposeBill : newWriteBackBills) {
            DynamicObjectCollection detailEntry = needDisposeBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailRow : detailEntry) {
                srcBillIds.add(detailRow.getLong("e_sourcebillid"));
            }
        }
        String string = String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector());
        Object[] srcBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)string, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        if (ObjectUtils.isEmpty((Object[])srcBills)) {
            return;
        }
        Map srcBillsGroupByOrg = Arrays.stream(srcBills).collect(Collectors.groupingBy(bill -> bill.getLong("org.id"), HashMap::new, Collectors.toList()));
        for (Map.Entry srcBillEntrySet : srcBillsGroupByOrg.entrySet()) {
            List sourceBills = (List)srcBillEntrySet.getValue();
            ApTransferWBFinBillServiceHelper.inverseWriteBack((DynamicObject[])sourceBills.toArray(new DynamicObject[0]), newWriteBackBills);
        }
    }

    private void writeBackSrcBillLockAmtOld(List<DynamicObject> oldReleaseUpBills) {
        PlanEntryDisposer planEntryDisposer = new PlanEntryDisposer();
        for (DynamicObject bill : oldReleaseUpBills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                BigDecimal amount = entry.getBigDecimal("e_pricetaxtotal");
                FinApBillHandleHelper.disposeLockedAmt((long)entry.getLong("e_sourcebillentryid"), (BigDecimal)amount, (Boolean)Boolean.FALSE);
                Long srcId = entry.getLong("e_sourcebillid");
                Collection disposeSelectors = planEntryDisposer.getSelectors();
                DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"ap_finapbill", (String)String.join((CharSequence)",", disposeSelectors));
                planEntryDisposer.deleteDispose(finBill, amount);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finBill});
            }
        }
    }

    private void updatePurInvoiceEntry(DynamicObject[] bills) {
        boolean isCQConfig = false;
        HashMap<String, HashMap<Long, List<Long>>> param = new HashMap<String, HashMap<Long, List<Long>>>(2);
        HashMap<Long, List<Long>> imPurreceiveMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, List<Long>> imPurinMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, List<Long>> pmPuracceptMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, List<Long>> omcmPlinMap = new HashMap<Long, List<Long>>(8);
        try {
            isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        }
        catch (Exception exc) {
            logger.info(exc.getMessage());
        }
        for (DynamicObject bill : bills) {
            if (!isCQConfig) continue;
            String sourceBillType = bill.getString("sourcebilltype");
            if ("im_purreceivebill".equals(sourceBillType)) {
                this.fillBillMap(imPurreceiveMap, bill);
                continue;
            }
            if ("im_purinbill".equals(sourceBillType)) {
                this.fillBillMap(imPurinMap, bill);
                continue;
            }
            if ("pm_puracceptbill".equals(sourceBillType)) {
                this.fillBillMap(pmPuracceptMap, bill);
                continue;
            }
            if (!"im_mdc_omcmplinbill".equals(sourceBillType)) continue;
            this.fillBillMap(omcmPlinMap, bill);
        }
        if (imPurreceiveMap.size() > 0) {
            param.put("im_purreceivebill", imPurreceiveMap);
        }
        if (imPurinMap.size() > 0) {
            param.put("im_purinbill", imPurinMap);
        }
        if (pmPuracceptMap.size() > 0) {
            param.put("pm_puracceptbill", pmPuracceptMap);
        }
        if (omcmPlinMap.size() > 0) {
            param.put("im_mdc_omcmplinbill", omcmPlinMap);
        }
        if (param.size() > 0) {
            try {
                DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurInvoiceEntry", (Object[])new Object[]{param});
            }
            catch (Exception exc) {
                logger.info(exc.getMessage());
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(10);
        props.add("org");
        props.add("isadjust");
        props.add("istanspay");
        props.add("sourcebillid");
        props.add("sourcebilltype");
        props.add("pricetaxtotal");
        props.add("inventry.invid");
        props.add("detailentry");
        props.add("e_pricetaxtotal");
        props.add("e_sourcebillid");
        props.add("e_sourcebillentryid");
        props.add("imageno");
        props.add("billno");
        props.add("iswrittenoff");
        props.add("biztype");
        props.add("payproperty.isbasedonamt");
        props.add("inventry.i_srctype");
        props.add("p_sourcebillid");
        props.add("p_sourcebillentryid");
        props.add("createtime");
        props.addAll(FinApBillHandleHelper.getLockWBSelector());
        props.add("detailentry.corebillid");
        props.add("detailentry.corebillentryid");
        props.add("detailentry.corebilltype");
        props.add("detailentry.e_baseunitqty");
        props.add("asstact");
        props.add("currency");
        props.add("ispremium");
        props.add("iswrittenoff");
        props.add("detailentry.seq");
        fieldKeys.addAll(props);
    }

    private void fillBillMap(Map<Long, List<Long>> billMap, DynamicObject bill) {
        for (DynamicObject row : bill.getDynamicObjectCollection("detailentry")) {
            List<Object> entryIds;
            long sourceBillId = row.getLong("e_sourcebillid");
            long sourceBillEntryId = row.getLong("e_sourcebillentryid");
            if (billMap.get(sourceBillId) != null) {
                entryIds = billMap.get(sourceBillId);
                entryIds.add(sourceBillEntryId);
                billMap.put(sourceBillId, entryIds);
                continue;
            }
            entryIds = new ArrayList(8);
            entryIds.add(sourceBillEntryId);
            billMap.put(sourceBillId, entryIds);
        }
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("detailentry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }
}

