/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.enums.InvMatchType;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinapBillDeleteOp4Match
extends AbstractOperationServicePlugIn {
    private final Map<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>(64);
    private final Map<Long, List<DynamicObject>> invPkGroup = new HashMap<Long, List<DynamicObject>>(64);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isinvoicematch");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject[] invoiceMatchApBills = (DynamicObject[])Stream.of(dataEntities).filter(entity -> entity.getBoolean("isinvoicematch")).toArray(DynamicObject[]::new);
        if (EmptyUtils.isNotEmpty((Object)invoiceMatchApBills)) {
            DynamicObject[] matchRecords;
            this.queryMatchRecords(invoiceMatchApBills);
            List apBillEntryPks = Stream.of(invoiceMatchApBills).map(apbill -> apbill.getDynamicObjectCollection("detailentry")).flatMap(Collection::stream).map(entry -> entry.getLong("id")).collect(Collectors.toList());
            List<DynamicObject> delRecordEntryList = this.recordMap.values().stream().map(record -> record.getDynamicObjectCollection("matchentry")).flatMap(Collection::stream).filter(entry -> apBillEntryPks.contains(entry.getLong("apbillentryid"))).collect(Collectors.toList());
            this.updateInvoice(delRecordEntryList, invoiceMatchApBills);
            Map<Boolean, List<DynamicObject>> result = this.mergeRelationEntrys(delRecordEntryList);
            List<DynamicObject> updateMatchRecords = result.get(Boolean.FALSE);
            List<DynamicObject> deleteMatchRecords = result.get(Boolean.TRUE);
            if (EmptyUtils.isNotEmpty(updateMatchRecords)) {
                SaveServiceHelper.save((DynamicObject[])updateMatchRecords.toArray(new DynamicObject[0]));
            }
            if (EmptyUtils.isNotEmpty(deleteMatchRecords)) {
                Object[] deletePks = deleteMatchRecords.stream().map(DataEntityBase::getPkValue).toArray();
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"invoice_match_record"), (Object[])deletePks);
            }
            Set idSet = Stream.of(invoiceMatchApBills).map(apbill -> apbill.getLong("id")).collect(Collectors.toSet());
            String selector = "ismatched,entry.invoiceid,entry.invoiceentryid,entry.subentry.apbillid,entry.subentry.apbillentryid";
            for (DynamicObject matchRecord : matchRecords = BusinessDataServiceHelper.load((String)"ap_matchinvoice", (String)selector, (QFilter[])new QFilter[]{new QFilter("entry.subentry.apbillid", "in", idSet)})) {
                matchRecord.set("ismatched", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.update((DynamicObject[])matchRecords);
        }
    }

    private void updateInvoice(List<DynamicObject> delRecordEntryList, DynamicObject[] invoiceMatchApBills) {
        DynamicObject[] invoices;
        Map<Long, List<DynamicObject>> recordInvPkGroup = delRecordEntryList.stream().collect(Collectors.groupingBy(re -> re.getLong("invpk")));
        QFilter[] invoiceFilter = new QFilter("id", "in", this.invPkGroup.keySet()).or(new QFilter("entry.id", "in", this.invPkGroup.keySet())).toArray();
        for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"pricetaxtotal,unmatchamt,entry.e_unmatchamt,entry.e_unmatchqty,entry.e_pricetaxtotal,entry.quantity,entry.actpricetax", (QFilter[])invoiceFilter)) {
            String invMatch;
            List<DynamicObject> billRecords = recordInvPkGroup.get(invoice.getLong("id"));
            DynamicObjectCollection invoiceEntryList = invoice.getDynamicObjectCollection("entry");
            String matchType = null;
            boolean billQtyMatch = false;
            if (EmptyUtils.isNotEmpty(billRecords)) {
                Long pkValue = (Long)((DynamicObject)billRecords.get(0).getParent()).getPkValue();
                matchType = this.recordMap.get(pkValue).getString("matchtype");
                invMatch = InvMatchType.BILL.name();
                if (matchType.equals("AMT")) {
                    BigDecimal returnAmt = billRecords.stream().map(e -> e.getBigDecimal("matchamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    invoice.set("unmatchamt", (Object)invoice.getBigDecimal("unmatchamt").add(returnAmt));
                } else {
                    billQtyMatch = true;
                }
            } else {
                invMatch = InvMatchType.ENTRY.name();
                for (DynamicObject invoiceEntry : invoiceEntryList) {
                    List entryRecords = recordInvPkGroup.getOrDefault(invoiceEntry.getLong("id"), new ArrayList(0));
                    if (!EmptyUtils.isNotEmpty((Object)entryRecords)) continue;
                    Long pkValue = (Long)((DynamicObject)((DynamicObject)entryRecords.get(0)).getParent()).getPkValue();
                    matchType = this.recordMap.get(pkValue).getString("matchtype");
                    String invoiceEntryMatchKey = matchType.equals("AMT") ? "e_unmatchamt" : "e_unmatchqty";
                    String recordMatchKey = matchType.equals("AMT") ? "matchamt" : "matchqty";
                    BigDecimal totalEntryMatchNumber = entryRecords.stream().map(record -> record.getBigDecimal(recordMatchKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    invoiceEntry.set(invoiceEntryMatchKey, (Object)invoiceEntry.getBigDecimal(invoiceEntryMatchKey).add(totalEntryMatchNumber));
                }
            }
            BigDecimal invoiceUnmatchAmt = invoice.getBigDecimal("unmatchamt");
            String finalMatchType = matchType;
            String entryUnmatchKey = "AMT".equals(finalMatchType) ? "e_unmatchamt" : "e_unmatchqty";
            String entryMatchKey = "AMT".equals(finalMatchType) ? "e_pricetaxtotal" : "quantity";
            long count = invoiceEntryList.stream().filter(entry -> entry.getBigDecimal(entryUnmatchKey).compareTo(entry.getBigDecimal(entryMatchKey)) == 0).count();
            if (!("AMT".equals(matchType) && invoiceUnmatchAmt.compareTo(invoice.getBigDecimal("pricetaxtotal")) == 0 || invMatch.equals(InvMatchType.ENTRY.name()) && count == (long)invoiceEntryList.size()) && !billQtyMatch) continue;
            invoice.set("unmatchamt", invoice.get("pricetaxtotal"));
            invoiceEntryList.forEach(entry -> {
                entry.set("e_unmatchamt", entry.get("e_pricetaxtotal"));
                entry.set("e_unmatchqty", entry.get("quantity"));
            });
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
    }

    private void queryMatchRecords(DynamicObject[] dataEntities) {
        DynamicObject[] matchRecords;
        List apBillEntryPks = Stream.of(dataEntities).map(entity -> entity.getDynamicObjectCollection("detailentry")).flatMap(Collection::stream).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("matchentry.apbillentryid", "in", apBillEntryPks);
        for (DynamicObject record : matchRecords = BusinessDataServiceHelper.load((String)"invoice_match_record", (String)"id,invoicebill,invmatch,chooserule,matchtype,matchentry.invpk,matchentry.id,matchentry.matchqty,matchentry.matchamt,matchentry.invpk,matchentry.apbillid,matchentry.apbillentryid,matchentry.billentryid, matchentry.upentrypk", (QFilter[])filter.toArray())) {
            DynamicObjectCollection matchEntry = record.getDynamicObjectCollection("matchentry");
            for (DynamicObject entry : matchEntry) {
                List values = this.invPkGroup.getOrDefault(entry.getLong("invpk"), new ArrayList(0));
                values.add(entry);
                this.invPkGroup.put(entry.getLong("invpk"), values);
            }
            this.recordMap.put(record.getLong("id"), record);
        }
    }

    private Map<Boolean, List<DynamicObject>> mergeRelationEntrys(List<DynamicObject> delRecordEntryList) {
        ArrayList<DynamicObject> relDelRecordEntryList = new ArrayList<DynamicObject>(64);
        for (DynamicObject dynamicObject : delRecordEntryList) {
            Long l = ((DynamicObject)dynamicObject.getParent()).getLong("id");
            DynamicObject matchRecord = this.recordMap.get(l);
            String matchType = matchRecord.getString("matchtype");
            String matchNumberKey = matchType.equals("AMT") ? "matchamt" : "matchqty";
            List<DynamicObject> recordEntries = this.invPkGroup.get(dynamicObject.getLong("invpk"));
            Map<Long, DynamicObject> entryPkMap = recordEntries.stream().collect(Collectors.toMap(record -> record.getLong("billentryid"), record -> record));
            Long upEntryId = dynamicObject.getLong("upentrypk");
            BigDecimal delMatchNumber = dynamicObject.getBigDecimal(matchNumberKey);
            while (entryPkMap.get(upEntryId) != null) {
                DynamicObject upEntry = entryPkMap.get(upEntryId);
                BigDecimal matchNumber = upEntry.getBigDecimal(matchNumberKey);
                if (delMatchNumber.compareTo(matchNumber) == 0) {
                    relDelRecordEntryList.add(upEntry);
                } else {
                    upEntry.set(matchNumberKey, (Object)upEntry.getBigDecimal(matchNumberKey).subtract(delMatchNumber));
                }
                upEntryId = upEntry.getLong("upentrypk");
            }
        }
        Map<Long, List<DynamicObject>> deleteGroup = Stream.concat(delRecordEntryList.stream(), relDelRecordEntryList.stream()).collect(Collectors.groupingBy(record -> ((DynamicObject)record.getParent()).getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : deleteGroup.entrySet()) {
            this.recordMap.get(entry.getKey()).getDynamicObjectCollection("matchentry").removeAll((Collection)entry.getValue());
        }
        Map<Boolean, List<DynamicObject>> map = this.recordMap.values().stream().collect(Collectors.partitioningBy(record -> record.getDynamicObjectCollection("matchentry").size() == 0));
        return map;
    }
}

