/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.init.ApInitHelper;
import kd.fi.ap.business.init.impl.InitAsstactPaidAmtDetail;
import kd.fi.ap.business.init.impl.InitAsstactPayAmtDetail;
import kd.fi.ap.business.init.info.InitAmtPair;
import kd.fi.ap.business.service.factory.InitFactory;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.init.InitReconcileService;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.IOpService;
import kd.fi.arapcommon.validator.DecimalScopeValidator;
import kd.fi.arapcommon.validator.InitBillValidator;
import kd.fi.arapcommon.validator.ReconcileBaseValidator;

public class InitCloseOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(InitCloseOp.class);
    private IOpService iService = InitFactory.getCloseService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(this.iService.getSelector());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.buildEntry(info);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InitBillValidator());
        e.addValidator((AbstractValidator)new ReconcileBaseValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] inits = e.getDataEntities();
        InitReconcileService recService = new InitReconcileService(false);
        recService.rebuild(inits);
        Map<Long, DynamicObject> initMap = Stream.of(inits).collect(Collectors.toMap(i -> i.getLong("id"), i -> i));
        List orgIds = Stream.of(inits).map(i -> i.getLong("org.id")).collect(Collectors.toList());
        Map orgMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.FALSE, orgIds, (String)"ap_008");
        logger.info("ap_008 param : " + JSONObject.toJSONString((Object)orgMap));
        List orgPks = orgMap.entrySet().stream().filter(es -> this.isReconcile(es.getValue())).map(es -> (Long)es.getKey()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(orgPks)) {
            List<DynamicObject> infos = Stream.of(inits).filter(i -> orgPks.contains(i.getLong("org.id"))).collect(Collectors.toList());
            OperationResult afResult = OperationServiceHelper.executeOperate((String)"aftersubmit", (String)this.billEntityType.getName(), (DynamicObject[])infos.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!afResult.isSuccess()) {
                List recOpErrors = afResult.getAllErrorOrValidateInfo();
                for (IOperateInfo errorInfo : recOpErrors) {
                    initMap.remove(errorInfo.getPkValue());
                    this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                }
                this.operationResult.setSuccess(false);
            } else {
                int size = this.operationResult.getBillCount();
                if (size == afResult.getSuccessPkIds().size()) {
                    StringBuilder message = new StringBuilder();
                    if (size == 1) {
                        DynamicObject org = inits[0].getDynamicObject("org");
                        message.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff1a", (String)"InitCloseOp_0", (String)"fi-ap-opplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                    }
                    message.append(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\uff0c\u4e0e\u603b\u8d26\u5bf9\u8d26\u5e73\u8861\u3002", (String)"InitCloseOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    this.operationResult.setMessage(message.toString());
                }
            }
        }
        e.setDataEntities(initMap.values().toArray(new DynamicObject[0]));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        AdjExchService adjExchService = new AdjExchService("ap");
        List orgIds = adjExchService.getOrgIds(e.getDataEntities());
        Map orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        for (DynamicObject info : e.getDataEntities()) {
            this.iService.process(info);
            Long orgId = (Long)info.getDynamicObject("org").getPkValue();
            if (orgAndParamMap.get(orgId) == null || !((Boolean)orgAndParamMap.get(orgId)).booleanValue()) continue;
            adjExchService.insertAdjExchRecord(info, Boolean.TRUE);
        }
    }

    private void buildEntry(DynamicObject info) {
        long orgPk = (Long)info.getDynamicObject("org").getPkValue();
        InitAsstactPayAmtDetail finAmtDetail = new InitAsstactPayAmtDetail("ap_finapbill", orgPk);
        InitAsstactPayAmtDetail bizAmtDetail = new InitAsstactPayAmtDetail("ap_busbill", orgPk);
        InitAsstactPaidAmtDetail paidAmtDetail = new InitAsstactPaidAmtDetail(orgPk);
        List entries = ApInitHelper.merge((List)finAmtDetail.getAsstDetail(), (List)bizAmtDetail.getAsstDetail(), (List)paidAmtDetail.getAsstDetail());
        if (!entries.isEmpty()) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (InitEntryInfo entryInfo : entries) {
                DynamicObject entry = new DynamicObject(entrys.getDynamicObjectType());
                MergeKey mergeKey = entryInfo.getMergeKey();
                entry.set("asstacttype", (Object)mergeKey.getAsstActType());
                entry.set("asstact", (Object)mergeKey.getAsst());
                entry.set("currency", (Object)mergeKey.getCurrency());
                InitAmtPair pair = (InitAmtPair)entryInfo.getAmtPair();
                entry.set("invoiceamount", (Object)pair.getFinAmt());
                entry.set("businessamount", (Object)pair.getBizAmt());
                entry.set("paymentamount", (Object)pair.getPaidAmt());
                BigDecimal finAmt = ObjectUtils.isEmpty((Object)pair.getFinAmt()) ? BigDecimal.ZERO : pair.getFinAmt();
                BigDecimal bizAmt = ObjectUtils.isEmpty((Object)pair.getBizAmt()) ? BigDecimal.ZERO : pair.getBizAmt();
                BigDecimal paidAmt = ObjectUtils.isEmpty((Object)pair.getPaidAmt()) ? BigDecimal.ZERO : pair.getPaidAmt();
                entry.set("totalamount", (Object)finAmt.add(bizAmt).subtract(paidAmt));
                entrys.add((Object)entry);
            }
        }
    }

    private boolean isReconcile(Object param) {
        boolean ap008 = param == null ? false : (Boolean)param;
        return ap008;
    }
}

