/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.validator.InvoiceAntiAssignValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class InvoiceAntiAssignOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(InvoiceAntiAssignOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InvoiceAntiAssignValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        logger.info("InvoiceAntiAssignOp endOperationTransaction begin");
        List invPks = Arrays.stream(e.getDataEntities()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        assignInvoiceParam.setInvoiceIds(invPks).setAppId(appId).setOperateKey(operateKey);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOICEASSIGNFINAP.getValue());
        assignInvoiceService.antiAssign(assignInvoiceParam);
        logger.info("InvoiceAntiAssignOp endOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("unrelatedamt");
        lst.add("pricetaxtotal");
        lst.add("entry.e_relatedamt");
        lst.add("entry.e_unrelatedamt");
        lst.add("entry.e_pricetaxtotal");
        lst.add("synstatus");
        lst.add("changesynstatustime");
        lst.add("serialno");
        lst.add("org");
    }
}

