/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoicematch.InvoiceMatchRecordGenerate;
import kd.fi.ap.enums.InvMatchType;
import kd.fi.ap.validator.InvoiceMatchNumberValidator;
import kd.fi.ap.validator.ToleranceMatchNumberValidator;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class InvoiceMatchOpPlugin
extends AbstractOperationServicePlugIn {
    private Map<String, MatchBillChain.MatchChain> chainMap;
    private final Map<String, List<DynamicObject>> generateFinapBillMap = new HashMap<String, List<DynamicObject>>(64);
    private DynamicObject invoice;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InvoiceMatchNumberValidator());
        e.addValidator((AbstractValidator)new ToleranceMatchNumberValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.chainMap = ((MatchBillChain)JSON.parseObject((String)this.getOption().getVariableValue("pagechaindata"), MatchBillChain.class)).getChainMap();
        DynamicObject dataEntity = e.getDataEntities()[0];
        this.queryInvoiceBills(dataEntity);
        InvoiceMatchRecordGenerate matchRecord = new InvoiceMatchRecordGenerate();
        DynamicObject record = matchRecord.generate(dataEntity);
        List<DynamicObject> apBills = this.generateFinApBill(dataEntity);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])apBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)result);
        this.setRecordApBillInfo(record);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        this.updateInvoiceMatchStatus(dataEntity);
    }

    private void queryInvoiceBills(DynamicObject dataEntity) {
        QFilter[] filterArr = new QFilter("id", "=", (Object)dataEntity.getLong("invoicebill")).toArray();
        this.invoice = BusinessDataServiceHelper.loadSingle((String)"ap_invoice", (String)"id,unmatchamt,isincludetax,modifier,modifytime,entry.id,entry.e_unmatchqty,entry.quantity,entry.actpricetax,entry.e_unmatchamt,entry.taxrate,entry.taxrateid,entry.discountmode,entry.discountrate,entry.price,entry.e_pricetaxtotal", (QFilter[])filterArr);
    }

    private void setRecordApBillInfo(DynamicObject record) {
        DynamicObjectCollection matchEntries = record.getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : matchEntries) {
            Map<String, DynamicObject> sourceEntryIdMap;
            DynamicObject apBillEntry;
            List<DynamicObject> apBills = this.generateFinapBillMap.get(matchEntry.getString("bill_type"));
            if (!EmptyUtils.isNotEmpty(apBills) || (apBillEntry = (sourceEntryIdMap = apBills.stream().map(apBill -> apBill.getDynamicObjectCollection("detailentry")).flatMap(Collection::stream).collect(Collectors.toMap(entry -> entry.getString("e_sourcebillentryid"), entry -> entry))).get(matchEntry.getString("billentryid"))) == null) continue;
            matchEntry.set("apbillid", ((DynamicObject)apBillEntry.getParent()).getPkValue());
            matchEntry.set("apbillentryid", apBillEntry.getPkValue());
        }
    }

    private List<DynamicObject> generateFinApBill(DynamicObject dataEntity) {
        List<MatchResultItem> results = this.getResults(dataEntity);
        Map<Long, Map<String, List<MatchResultItem>>> group = results.stream().collect(Collectors.groupingBy(MatchResultItem::getInvPk, Collectors.groupingBy(MatchResultItem::getBillEntity)));
        DynamicObjectCollection invList = dataEntity.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> finBills = new ArrayList<DynamicObject>(64);
        HashMap<String, List> matchItemMap = new HashMap<String, List>(64);
        for (DynamicObject inv : invList) {
            Map<String, List<MatchResultItem>> map = group.get(inv.getLong("invpk"));
            String matchRule = inv.getString("invmatchrule");
            MatchBillChain.MatchChain matchChain = this.chainMap.get(matchRule.toLowerCase());
            List<MatchResultItem> items = map.get(matchChain.getBillEntity());
            List orDefault = matchItemMap.getOrDefault(matchChain.getBillEntity(), new ArrayList(0));
            orDefault.addAll(items);
            matchItemMap.put(matchChain.getBillEntity(), orDefault);
        }
        for (Map.Entry keyVal : matchItemMap.entrySet()) {
            List items = (List)keyVal.getValue();
            MatchBillChain.MatchChain matchChain = this.chainMap.get(keyVal.getKey());
            PushArgs args = this.getPushArgs(dataEntity, matchChain, items);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)args);
            boolean success = pushResult.isSuccess();
            if (!success) {
                throw new KDBizException(new ErrorCode("InvoiceMatchPushBotp", pushResult.getMessage()), new Object[]{pushResult.getBillReports()});
            }
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"ap_finapbill");
            List finApBills = pushResult.loadTargetDataObjects(refDataProvider, mainType);
            this.generateFinapBillMap.put(matchChain.getBillEntity(), finApBills);
            this.reCalculateFinApBills(finApBills, items, dataEntity);
            finBills.addAll(finApBills);
        }
        for (DynamicObject trgBill : finBills) {
            trgBill.set("isinvoicematch", (Object)Boolean.TRUE);
            if (!EmptyUtils.isEmpty((Object)trgBill.getString("billno"))) continue;
            String billno = CodeRuleServiceHelper.getNumber((String)"ap_finapbill", (DynamicObject)trgBill, (String)trgBill.getDynamicObject("org").getPkValue().toString());
            trgBill.set("billno", (Object)billno);
        }
        return finBills;
    }

    private PushArgs getPushArgs(DynamicObject dataEntity, MatchBillChain.MatchChain matchChain, List<MatchResultItem> items) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (MatchResultItem item : items) {
            ListSelectedRow row = new ListSelectedRow();
            row.setEntryPrimaryKeyValue(item.getEntryId());
            row.setEntryEntityKey(matchChain.getEntryEntity());
            row.setPrimaryKeyValue(item.getBillId());
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(matchChain.getBillEntity());
        args.setTargetEntityNumber("ap_finapbill");
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        args.addCustomParam("invoicematchflag", Boolean.TRUE.toString());
        args.addCustomParam("matchitems", JSON.toJSONString(items));
        args.addCustomParam("matchtype", dataEntity.getString("matchtype"));
        args.addCustomParam("invmatch", dataEntity.getString("invmatch"));
        args.addCustomParam("chooserule", dataEntity.getString("chooserule"));
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return args;
    }

    private List<MatchResultItem> getResults(DynamicObject dataEntity) {
        ArrayList<MatchResultItem> results = new ArrayList<MatchResultItem>(64);
        DynamicObjectCollection resultEntryList = dataEntity.getDynamicObjectCollection("resultentry");
        for (DynamicObject resultEntry : resultEntryList) {
            MatchResultItem item = new MatchResultItem();
            item.setInvPk(Long.valueOf(resultEntry.getLong("rs_invpk")));
            item.setBillEntity(resultEntry.getString("rs_entity"));
            item.setBillId((Object)resultEntry.getLong("rs_billid"));
            item.setEntryId((Object)resultEntry.getLong("rs_entryid"));
            item.setMatchAmt(resultEntry.getBigDecimal("rs_amt"));
            item.setMatchQty(resultEntry.getBigDecimal("rs_qty"));
            item.setMatchType(resultEntry.getString("rs_type"));
            results.add(item);
        }
        return results;
    }

    private void updateInvoiceMatchStatus(DynamicObject dataEntity) {
        Date date = new Date();
        String uid = RequestContext.get().getUid();
        DynamicObjectCollection invoiceEntryList = this.invoice.getDynamicObjectCollection("entry");
        for (DynamicObject invoiceEntry : invoiceEntryList) {
            invoiceEntry.set("e_unmatchamt", (Object)BigDecimal.ZERO);
            invoiceEntry.set("e_unmatchqty", (Object)BigDecimal.ZERO);
        }
        this.invoice.set("unmatchamt", (Object)BigDecimal.ZERO);
        this.invoice.set("modifier", (Object)uid);
        this.invoice.set("modifytime", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.invoice});
    }

    private void reCalculateFinApBills(List<DynamicObject> finBills, List<MatchResultItem> recordItems, DynamicObject record) {
        Map<Object, MatchResultItem> recordItemMap = recordItems.stream().collect(Collectors.toMap(MatchResultItem::getEntryId, item -> item));
        Map<Long, DynamicObject> invoiceEntryMap = this.invoice.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry));
        String matchType = record.getString("matchtype");
        String invMatch = record.getString("invmatch");
        BigDecimal payableAmount = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unSettleAmount = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal unVerifyAmount = BigDecimal.ZERO;
        boolean isincludetax = this.invoice.getBoolean("isincludetax");
        for (DynamicObject finBill : finBills) {
            BigDecimal exchangeRate = finBill.getBigDecimal("exchangerate");
            boolean isbasedonamt = matchType.equals("AMT");
            int precision = finBill.getInt("currency.amtprecision");
            DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject finBillEntry : detailEntry) {
                BigDecimal e_baseunitqty;
                MatchResultItem item2 = recordItemMap.get(finBillEntry.getLong("e_sourcebillentryid"));
                DynamicObject invoiceEntry = invoiceEntryMap.get(item2.getInvPk());
                BigDecimal matchQty = item2.getMatchQty();
                BigDecimal matchAmt = item2.getMatchAmt();
                BigDecimal taxRate = invMatch.equals(InvMatchType.ENTRY.name()) ? invoiceEntry.getBigDecimal("taxrate") : BigDecimal.ZERO;
                DynamicObject taxRateDyb = invMatch.equals(InvMatchType.ENTRY.name()) ? invoiceEntry.getDynamicObject("taxrateid") : null;
                String discountMode = matchType.equals("QTY") && invMatch.equals("ENTRY") ? invoiceEntry.getString("discountmode") : null;
                BigDecimal discountRate = matchType.equals("QTY") && invMatch.equals("ENTRY") ? invoiceEntry.getBigDecimal("discountrate") : BigDecimal.ZERO;
                BigDecimal eAdjustamount = BigDecimal.ZERO;
                PriceLocalCalculator localCalculator = null;
                PriceTaxTotalCalculator calculator = null;
                BigDecimal unmatchQty = BigDecimal.ZERO;
                if (isbasedonamt) {
                    calculator = new PriceTaxTotalCalculator(matchQty, matchAmt, taxRate, discountMode, discountRate, precision, eAdjustamount);
                } else if (invMatch.equals("ENTRY")) {
                    if (isincludetax) {
                        BigDecimal e_pricetaxtotal = invoiceEntry.getBigDecimal("e_pricetaxtotal");
                        BigDecimal quantity = invoiceEntry.getBigDecimal("quantity");
                        BigDecimal pricetaxtotal = invoiceEntry.getBigDecimal("actpricetax").multiply(matchQty);
                        if ((unmatchQty = unmatchQty.add(quantity)).compareTo(invoiceEntry.getBigDecimal("e_unmatchqty")) == 0) {
                            BigDecimal flow = e_pricetaxtotal.subtract(quantity.multiply(invoiceEntry.getBigDecimal("actpricetax")));
                            pricetaxtotal = pricetaxtotal.add(flow);
                        }
                        calculator = new PriceTaxTotalCalculator(matchQty, pricetaxtotal, taxRate, discountMode, discountRate, precision, eAdjustamount);
                    } else {
                        BigDecimal price = invoiceEntry.getBigDecimal("price");
                        calculator = new UnitPriceCalculator(matchQty, price, taxRate, discountMode, discountRate, precision, eAdjustamount);
                    }
                } else {
                    calculator = new PriceTaxTotalCalculator(matchQty, matchAmt, taxRate, discountMode, discountRate, precision, eAdjustamount);
                }
                localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, precision);
                localCalculator.calculate();
                BigDecimal e_amountbase = localCalculator.getAmountlocal();
                BigDecimal e_pricetaxtotalbase = localCalculator.getPricetaxtotallocal();
                BigDecimal e_pricetaxtotal = localCalculator.getPricetaxtotal();
                BigDecimal e_amount = localCalculator.getAmount();
                BigDecimal e_tax = localCalculator.getTax();
                amountbase = amountbase.add(e_amountbase);
                pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
                payableAmount = payableAmount.add(e_pricetaxtotal);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                unVerifyAmount = unVerifyAmount.add(e_amount);
                unSettleAmount = unSettleAmount.add(e_pricetaxtotal);
                adjustamt = adjustamt.add(localCalculator.getAdjustamt());
                adjustamtlocal = adjustamtlocal.add(localCalculator.getAdjustamtlocal());
                finBillEntry.set("price", (Object)localCalculator.getUnitprice());
                finBillEntry.set("pricetax", (Object)localCalculator.getTaxunitprice());
                finBillEntry.set("actprice", (Object)localCalculator.getActunitprice());
                finBillEntry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                finBillEntry.set("discountamount", (Object)localCalculator.getDiscountamount());
                finBillEntry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                finBillEntry.set("e_amount", (Object)e_amount);
                finBillEntry.set("e_amountbase", (Object)e_amountbase);
                finBillEntry.set("e_tax", (Object)e_tax);
                finBillEntry.set("e_pricetaxtotal", (Object)e_pricetaxtotal);
                finBillEntry.set("unlockamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("unsettleamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("e_unverifyamount", (Object)e_amount);
                finBillEntry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                finBillEntry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
                finBillEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                finBillEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamt());
                finBillEntry.set("taxrateid", (Object)taxRateDyb);
                BigDecimal quantity = finBillEntry.getBigDecimal("quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                BigDecimal covertRate = finBillEntry.getBigDecimal("e_unitconvertrate");
                DynamicObject material = finBillEntry.getDynamicObject("material");
                DynamicObject measureUnit = finBillEntry.getDynamicObject("measureunit");
                DynamicObject baseUnit = null;
                if (!ObjectUtils.isEmpty((Object)material)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    finBillEntry.set("e_baseunit", (Object)baseUnit);
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    covertRate = (covertRate = InitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"))) == null ? BigDecimal.ONE : covertRate;
                } else {
                    covertRate = BigDecimal.ONE;
                }
                BigDecimal e_unitcoefficient = finBillEntry.getBigDecimal("e_unitconvertrate");
                if (e_unitcoefficient == null || e_unitcoefficient.compareTo(BigDecimal.ZERO) == 0) {
                    finBillEntry.set("e_unitconvertrate", (Object)covertRate);
                }
                if ((e_baseunitqty = finBillEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                    finBillEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
                }
                finBillEntry.set("unverifyquantity", (Object)quantity);
            }
            finBill.set("pricetaxtotal", (Object)payableAmount);
            finBill.set("uninvoicedamt", (Object)payableAmount);
            finBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            finBill.set("amount", (Object)amount);
            finBill.set("amountbase", (Object)amountbase);
            finBill.set("tax", (Object)tax);
            finBill.set("unverifyamount", (Object)unVerifyAmount);
            finBill.set("unsettleamount", (Object)unSettleAmount);
            finBill.set("unsettleamountbase", (Object)pricetaxtotalbase);
            finBill.set("adjustamount", (Object)adjustamt);
            finBill.set("adjustlocalamt", (Object)adjustamtlocal);
        }
    }
}

