/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.validator.InvoiceSaveValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArapAmountPropHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.validator.BillPriceValidator;

public class InvoiceSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(InvoiceSaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"pricetaxtotal", "pricetaxtotalbase", "amount", "amountbase", "tax", "unrelatedamt", "unmatchamt"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new InvoiceSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("InvoiceSaveOp beginOperationTransaction begin .");
        DynamicObject[] invoices = e.getDataEntities();
        logger.info("InvoiceSaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(invoices);
        logger.info("InvoiceSaveOp.beginOperationTransaction appendHeadAmt end");
        logger.info("InvoiceSaveOp.beginOperationTransaction repairApInvoiceDatas start");
        ArApDataRepairHelper.repairApInvoiceDatas((DynamicObject[])invoices);
        logger.info("InvoiceSaveOp.beginOperationTransaction repairApInvoiceDatas end");
        logger.info("InvoiceSaveOp.beginOperationTransaction batchSetPrecision start");
        ArapAmountPropHelper.batchSetPrecision((DynamicObject[])invoices);
        logger.info("InvoiceSaveOp.beginOperationTransaction batchSetPrecision end");
        logger.info("InvoiceSaveOp beginOperationTransaction end .");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("InvoiceSaveOp endOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        this.updateInvoiceCloud(dataEntities);
        logger.info("InvoiceSaveOp endOperationTransaction end .");
    }

    private void updateInvoiceCloud(DynamicObject[] dataEntities) {
        ArrayList<Object> invoiceIds = new ArrayList<Object>(64);
        ArrayList<String> invNoAndCodes = new ArrayList<String>(64);
        for (DynamicObject invoice : dataEntities) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoiceIds.add(invoice.getPkValue());
            invNoAndCodes.add(invoice.getString("invoiceno") + "_" + invoice.getString("invoicecode"));
        }
        logger.info("InvoiceSaveOp updateInvoiceCloud invoiceIds : " + invoiceIds);
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return;
        }
        CommonParam param = new CommonParam();
        param.put((Object)"invoiceIds", invoiceIds);
        param.put((Object)"invNoAndCodes", invNoAndCodes);
        param.put((Object)"operate", (Object)"updatecloud");
        ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_employinvcloud", null, (String)"fi", (String)"ap", (String)"ApInvoiceUpdateCloudECService", (Param)param, (String)"", invoiceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("billno");
        keys.add("imageno");
        keys.add("creator");
        keys.add("modifier");
        keys.add("createtime");
        keys.add("modifytime");
        keys.add("ispresent");
        keys.add("price");
        keys.add("serialno");
        keys.add("buyertin");
        keys.add("isincludetax");
        keys.add("entry.corebilltype");
        keys.add("entry.corebillno");
        keys.add("entry.corebillentryseq");
        keys.add("e_relatedamt");
        keys.add("entry.e_inventryseq");
        keys.add("currency");
        keys.add("pricetaxtotal");
        keys.add("unrelatedamt");
        keys.add("e_pricetaxtotal");
        keys.add("exchangerate");
        keys.add("e_unrelatedamt");
        keys.add("pricetaxtotalbase");
        keys.add("amountbase");
        keys.add("amount");
        keys.add("e_amountbase");
        keys.add("e_amount");
        keys.add("discountlocalamt");
        keys.add("discountamt");
        keys.add("e_pricetaxtotalbase");
        keys.add("invoicestatus");
        keys.add("tax");
        keys.add("e_tax");
        keys.add("businesssource");
        keys.add("asstact");
    }
}

