/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.fin.PlanEntryDisposer;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class LiquidationDisposePayPlanHelper {
    public static void disposeLockedAmount(DynamicObject[] liquidations, boolean isDelete) {
        BigDecimal disposeAmount;
        HashMap<Long, BigDecimal> disposeMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject liquidation : liquidations) {
            DynamicObjectCollection entry = liquidation.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                long sourceBillId = row.getLong("sourcebillid");
                BigDecimal unsettleamt = row.getBigDecimal("unsettleamt");
                disposeAmount = (BigDecimal)disposeMap.get(sourceBillId);
                disposeAmount = disposeAmount == null ? unsettleamt : disposeAmount.add(unsettleamt);
                disposeMap.put(sourceBillId, disposeAmount);
            }
        }
        if (disposeMap.size() > 0) {
            Set keySet = disposeMap.keySet();
            PlanEntryDisposer planEntryDisposer = new PlanEntryDisposer();
            Collection disposeSelectors = planEntryDisposer.getSelectors();
            DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType((String)"ap_finapbill", (String)String.join((CharSequence)",", disposeSelectors));
            DynamicObject[] sourBills = BusinessDataServiceHelper.load((Object[])keySet.toArray(), (DynamicObjectType)subEntityType);
            Set entrySet = disposeMap.entrySet();
            for (Map.Entry entry : entrySet) {
                long sourBillId = (Long)entry.getKey();
                disposeAmount = (BigDecimal)entry.getValue();
                for (DynamicObject sourBill : sourBills) {
                    if (sourBill.getLong("id") != sourBillId) continue;
                    if (isDelete) {
                        planEntryDisposer.deleteDispose(sourBill, disposeAmount);
                        continue;
                    }
                    planEntryDisposer.saveDispose(sourBill, disposeAmount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])sourBills);
        }
    }
}

