/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.opplugin.PayApply4InvCollOp;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class Replace4InvCollOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApply4InvCollOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("Replace4InvCollOp endOperationTransaction begin .");
        Object[] dataEntities = this.getNeedProcessReplaceBills(e.getDataEntities());
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        logger.info("Replace4InvCollOp endOperationTransaction begin collect.");
        String appId = (String)this.getOption().getVariables().get("appnumber");
        InvoiceCollectParam collectParam = new InvoiceCollectParam();
        collectParam.setAppId(appId);
        collectParam.setOperateKey(String.valueOf(this.operateMeta.get("key")));
        ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.REPLACEINVCOLLECT.getValue());
        collectService.collectInvoice(collectParam, (DynamicObject[])dataEntities);
        logger.info("Replace4InvCollOp endOperationTransaction begin end.");
    }

    private DynamicObject[] getNeedProcessReplaceBills(DynamicObject[] dataEntities) {
        ArrayList<Long> billIds = new ArrayList<Long>(8);
        block0: for (DynamicObject applyBill : dataEntities) {
            DynamicObjectCollection newInvEntry = applyBill.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                billIds.add(applyBill.getLong("id"));
                continue block0;
            }
        }
        if (ObjectUtils.isEmpty(billIds)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((String)"ap_replaceinvapply", (String)String.join((CharSequence)",", this.getSelectors()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List lst = e.getFieldKeys();
        lst.addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(256);
        selectors.add("org");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("billno");
        selectors.add("o_isprepayinv");
        selectors.add("o_invbillno");
        selectors.add("o_serialno");
        selectors.add("o_apbillno");
        selectors.add("o_usedamt");
        selectors.add("o_apbillid");
        selectors.add("o_applybillno");
        selectors.add("o_applybillid");
        selectors.add("o_applybillid");
        selectors.add("o_invbillno");
        selectors.add("o_invid");
        selectors.add("n_isprepayinv");
        selectors.add("n_invid");
        selectors.add("n_invbillno");
        selectors.add("n_serialno");
        selectors.add("n_blueinvid");
        selectors.add("n_blueinvno");
        selectors.add("n_apbillno");
        selectors.add("n_usedamt");
        selectors.add("n_apbillid");
        selectors.add("n_applybillno");
        selectors.add("n_applybillid");
        selectors.add("n_srctype");
        selectors.add("oldinventry.pid");
        selectors.add("newinventry.pid");
        return selectors;
    }
}

