/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class Replace4InvDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(Replace4InvDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("Replace4InvDeleteOp beginOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        this.releaseInvoice(dataEntities);
        logger.info("Replace4InvDeleteOp beginOperationTransaction end.");
    }

    private void releaseInvoice(DynamicObject[] dataEntities) {
        HashMap<Long, Set> replace4InvoiceMap = new HashMap<Long, Set>(8);
        for (DynamicObject replaceBill : dataEntities) {
            Long replaceBillId = replaceBill.getLong("id");
            DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                Set deleteInvoiceIds = replace4InvoiceMap.getOrDefault(replaceBillId, new HashSet(8));
                deleteInvoiceIds.add(newInvRow.getLong("n_invid"));
                replace4InvoiceMap.put(replaceBillId, deleteInvoiceIds);
            }
        }
        if (replace4InvoiceMap.isEmpty()) {
            return;
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        deleteParam.setBill4InvoiceMap(replace4InvoiceMap).setSave(false).setOperateKey(operateKey).setAppId(appId);
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.REPLACEDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List selectors = e.getFieldKeys();
        selectors.add("n_invid");
        selectors.add("n_srctype");
    }
}

