/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.business.pojo.InvoiceArticulateBillParam;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.ReplaceInvoiceSubmitAndAuditValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class ReplaceInvoiceAuditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ReplaceInvoiceAuditOp.class);
    private static final Set<String> redInvStatusList = new HashSet<String>(Arrays.asList("", " ", "3", "7", "8", "0"));

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReplaceInvoiceSubmitAndAuditValidator());
    }

    /*
     * Could not resolve type clashes
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap(dataEntities);
        Map<Long, Map<Long, BigDecimal>> invoice4FinApUsedAmtMap = this.getInvoice4FinApUsedAmtMap(dataEntities);
        Map<Long, Map<Long, BigDecimal>> oldFin4InvUsedAmtMap = this.getOldFin4InvUsedAmtMap(dataEntities);
        Map<Long, DynamicObject> finApBillMap = this.getFinApBillMap(dataEntities);
        HashMap<Long, Set> finAp4DeleteInvoiceMap = new HashMap<Long, Set>(8);
        HashMap<Long, Set> apply4DeleteInvoiceMap = new HashMap<Long, Set>(8);
        ArrayList<InvoiceArticulateBillParam> finApBillParams = new ArrayList<InvoiceArticulateBillParam>(32);
        ArrayList<InvoiceArticulateBillParam> invoiceAssignFinApParams = new ArrayList<InvoiceArticulateBillParam>(32);
        ArrayList<InvoiceArticulateBillParam> applyBillParams = new ArrayList<InvoiceArticulateBillParam>(32);
        ArrayList<InvoiceArticulateBillParam> invoiceAssignApplyParams = new ArrayList<InvoiceArticulateBillParam>(32);
        HashMap<Long, Map> finApAssignInvSrcTypeMap = new HashMap<Long, Map>(8);
        HashMap<Long, Map> applyAssignInvSrcTypeMap = new HashMap<Long, Map>(8);
        long[] uniqueKeyArray = DB.genGlobalLongIds((int)100);
        PrimitiveIterator.OfLong iterator = Arrays.stream(uniqueKeyArray).iterator();
        HashSet<Long> allInvoiceIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            HashMap<Long, Set> apply4OldInvMap = new HashMap<Long, Set>(8);
            HashMap<Long, Set> finAp4OldInvMap = new HashMap<Long, Set>(8);
            DynamicObjectCollection oldInvEntry = dataEntity.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long pid = oldInvRow.getLong("pid");
                long invId = oldInvRow.getLong("o_invid");
                long apBillId = oldInvRow.getLong("o_apbillid");
                long applyId = oldInvRow.getLong("o_applybillid");
                if (apBillId != 0L) {
                    Set invoiceIds = finAp4DeleteInvoiceMap.getOrDefault(apBillId, new HashSet(8));
                    invoiceIds.add(invId);
                    finAp4DeleteInvoiceMap.put(apBillId, invoiceIds);
                    Set oldInvIds = finAp4OldInvMap.getOrDefault(apBillId, new HashSet(8));
                    oldInvIds.add(invId);
                    finAp4OldInvMap.put(apBillId, oldInvIds);
                }
                if (applyId != 0L && pid == 0L) {
                    Set oldInvIds = apply4OldInvMap.getOrDefault(applyId, new HashSet(8));
                    oldInvIds.add(invId);
                    apply4OldInvMap.put(applyId, oldInvIds);
                }
                allInvoiceIds.add(invId);
            }
            HashMap<Long, Long> newInv4BlueInvMap = new HashMap<Long, Long>(8);
            HashSet<Long> hasBlueInv4ApplyIds = new HashSet<Long>(8);
            HashSet notBlueInv4ApplyIds = new HashSet(8);
            DynamicObjectCollection newInvEntry = dataEntity.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                long invoiceId = newInvRow.getLong("n_invid");
                long blueInvId = newInvRow.getLong("n_blueinvid");
                long applyId = newInvRow.getLong("n_applybillid");
                if (newInvRow.getLong("pid") == 0L && blueInvId != 0L) {
                    newInv4BlueInvMap.put(invoiceId, blueInvId);
                }
                allInvoiceIds.add(invoiceId);
                if (applyId != 0L && blueInvId != 0L) {
                    hasBlueInv4ApplyIds.add(applyId);
                }
                if (applyId == 0L) continue;
                notBlueInv4ApplyIds.add(applyId);
            }
            HashMap<Long, Map> finAp4InvAssignAmtMap = new HashMap<Long, Map>(16);
            for (DynamicObject newInvRow : newInvEntry) {
                long pid = newInvRow.getLong("pid");
                long invoiceId = newInvRow.getLong("n_invid");
                BigDecimal usedAmt = newInvRow.getBigDecimal("n_usedamt");
                long apBillId = newInvRow.getLong("n_apbillid");
                long applyId = newInvRow.getLong("n_applybillid");
                String srcType = newInvRow.getString("n_srctype");
                long blueInvId = newInv4BlueInvMap.getOrDefault(invoiceId, 0L);
                if (apBillId != 0L && BigDecimal.ZERO.compareTo(usedAmt) != 0) {
                    Map invoiceAmtMap = finAp4InvAssignAmtMap.getOrDefault(apBillId, new HashMap(8));
                    invoiceAmtMap.put(invoiceId, usedAmt);
                    if (blueInvId != 0L && !invoiceAmtMap.containsKey(blueInvId)) {
                        Map blueInvoice4FinUsedAmtMap = invoice4FinApUsedAmtMap.getOrDefault(blueInvId, new HashMap(8));
                        BigDecimal blueInvRelateAmt = blueInvoice4FinUsedAmtMap.getOrDefault(apBillId, BigDecimal.ZERO);
                        invoiceAmtMap.put(blueInvId, blueInvRelateAmt);
                    }
                    finAp4InvAssignAmtMap.put(apBillId, invoiceAmtMap);
                    Map invoiceSrcTypeMap = finApAssignInvSrcTypeMap.getOrDefault(apBillId, new HashMap(8));
                    if (!invoiceSrcTypeMap.containsKey(invoiceId)) {
                        if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                            invoiceSrcTypeMap.put(invoiceId, InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
                        } else {
                            invoiceSrcTypeMap.put(invoiceId, InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue());
                        }
                        finApAssignInvSrcTypeMap.put(apBillId, invoiceSrcTypeMap);
                    }
                }
                if (pid != 0L || applyId == 0L) continue;
                long uniqueKey = this.getAccurateArticulateId(iterator);
                InvoiceArticulateBillParam invoiceParam = new InvoiceArticulateBillParam();
                invoiceParam.setBillId(invoiceId).setAccurateArticulateId(uniqueKey);
                invoiceAssignApplyParams.add(invoiceParam);
                InvoiceArticulateBillParam applyParam = new InvoiceArticulateBillParam();
                applyParam.setBillId(applyId).setAccurateArticulateId(uniqueKey);
                applyBillParams.add(applyParam);
                Map invoiceSrcTypeMap = applyAssignInvSrcTypeMap.getOrDefault(applyId, new HashMap(8));
                if (invoiceSrcTypeMap.containsKey(invoiceId)) continue;
                if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                    invoiceSrcTypeMap.put(invoiceId, ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue());
                } else {
                    invoiceSrcTypeMap.put(invoiceId, ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue());
                }
                applyAssignInvSrcTypeMap.put(applyId, invoiceSrcTypeMap);
            }
            if (!notBlueInv4ApplyIds.isEmpty()) {
                notBlueInv4ApplyIds.removeAll(hasBlueInv4ApplyIds);
                Iterator<Object> iterator2 = notBlueInv4ApplyIds.iterator();
                while (iterator2.hasNext()) {
                    Long applyId = (Long)iterator2.next();
                    Set apply4InvIds = apply4OldInvMap.getOrDefault(applyId, new HashSet(2));
                    HashSet<Long> needDeleteApplyInvIds = new HashSet<Long>(8);
                    for (Long apply4InvId : apply4InvIds) {
                        DynamicObject oldInvoice = invoiceMap.get(apply4InvId);
                        if (oldInvoice == null || !redInvStatusList.contains(oldInvoice.getString("invoicestatus"))) continue;
                        needDeleteApplyInvIds.add(apply4InvId);
                    }
                    if (needDeleteApplyInvIds.isEmpty()) continue;
                    Set apply4DeleteInvIds = apply4DeleteInvoiceMap.getOrDefault(applyId, new HashSet(2));
                    apply4DeleteInvIds.addAll(needDeleteApplyInvIds);
                    apply4DeleteInvoiceMap.put(applyId, apply4DeleteInvIds);
                }
            }
            if (finAp4InvAssignAmtMap.isEmpty()) continue;
            for (Map.Entry entrySet : finAp4InvAssignAmtMap.entrySet()) {
                long uniqueKey = this.getAccurateArticulateId(iterator);
                Long finApBillId = (Long)entrySet.getKey();
                Set finAp4OldInvIds = finAp4OldInvMap.getOrDefault(finApBillId, new HashSet(2));
                Map newInvoiceAmtMap = (Map)entrySet.getValue();
                for (Map.Entry entrySet1 : newInvoiceAmtMap.entrySet()) {
                    Long invoiceId = (Long)entrySet1.getKey();
                    BigDecimal usedAmt = (BigDecimal)entrySet1.getValue();
                    InvoiceArticulateBillParam invoiceParam = new InvoiceArticulateBillParam();
                    invoiceParam.setBillId(invoiceId.longValue()).setAccurateArticulateId(uniqueKey).setCanArticulateAmt(usedAmt);
                    if (finAp4OldInvIds.contains(invoiceId)) {
                        invoiceParam.setArticulateOrder(1);
                    } else {
                        invoiceParam.setArticulateOrder(2);
                    }
                    invoiceAssignFinApParams.add(invoiceParam);
                }
                InvoiceArticulateBillParam finApParam = new InvoiceArticulateBillParam();
                finApParam.setBillId(finApBillId.longValue()).setAccurateArticulateId(uniqueKey);
                DynamicObject finApBill = finApBillMap.get(finApBillId);
                if (finApBill != null) {
                    finApParam.setCanArticulateAmt(finApBill.getBigDecimal("pricetaxtotal").subtract(finApBill.getBigDecimal("uninvoicedamt")));
                }
                finApBillParams.add(finApParam);
            }
        }
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction finAp4DeleteInvoiceMap is : " + finAp4DeleteInvoiceMap);
        if (!finAp4DeleteInvoiceMap.isEmpty()) {
            HashMap<Long, Set> tempFinAp4DeleteInvoiceMap = new HashMap<Long, Set>(8);
            HashMap<Long, InvoiceArticulateBillParam> finApBillParamsMap = new HashMap<Long, InvoiceArticulateBillParam>(8);
            for (InvoiceArticulateBillParam finApBillParam : finApBillParams) {
                finApBillParamsMap.put(finApBillParam.getBillId(), finApBillParam);
            }
            for (Map.Entry entrySet : finAp4DeleteInvoiceMap.entrySet()) {
                long uniqueKey;
                boolean isContainsFinAp;
                Long finApBillId = (Long)entrySet.getKey();
                Set willChangeInvIds = (Set)entrySet.getValue();
                Map<Long, BigDecimal> oldAllInvUsedAmtMap = oldFin4InvUsedAmtMap.get(finApBillId);
                if (willChangeInvIds.size() == oldAllInvUsedAmtMap.size()) {
                    tempFinAp4DeleteInvoiceMap.put(finApBillId, willChangeInvIds);
                    continue;
                }
                HashSet oldUseInvIds = new HashSet(8);
                for (Map.Entry entrySet1 : oldAllInvUsedAmtMap.entrySet()) {
                    if (BigDecimal.ZERO.compareTo((BigDecimal)entrySet1.getValue()) == 0) continue;
                    oldUseInvIds.add(entrySet1.getKey());
                }
                if (oldUseInvIds.isEmpty()) continue;
                tempFinAp4DeleteInvoiceMap.put(finApBillId, oldUseInvIds);
                InvoiceArticulateBillParam finApBillParam = (InvoiceArticulateBillParam)finApBillParamsMap.get(finApBillId);
                boolean bl = isContainsFinAp = finApBillParam != null;
                if (isContainsFinAp) {
                    uniqueKey = finApBillParam.getAccurateArticulateId();
                } else {
                    uniqueKey = this.getAccurateArticulateId(iterator);
                    finApBillParam = new InvoiceArticulateBillParam();
                    finApBillParam.setBillId(finApBillId.longValue()).setAccurateArticulateId(uniqueKey);
                    DynamicObject finApBill = finApBillMap.get(finApBillId);
                    if (finApBill != null) {
                        finApBillParam.setCanArticulateAmt(finApBill.getBigDecimal("pricetaxtotal").subtract(finApBill.getBigDecimal("uninvoicedamt")));
                    }
                    finApBillParams.add(finApBillParam);
                }
                for (Long oldUseInvId : oldUseInvIds) {
                    if (willChangeInvIds.contains(oldUseInvId)) continue;
                    InvoiceArticulateBillParam invoiceParam = new InvoiceArticulateBillParam();
                    invoiceParam.setBillId(oldUseInvId.longValue()).setCanArticulateAmt(oldAllInvUsedAmtMap.get(oldUseInvId)).setAccurateArticulateId(uniqueKey).setArticulateOrder(1);
                    invoiceAssignFinApParams.add(invoiceParam);
                }
            }
            logger.info("ReplaceInvoiceAuditOp endOperationTransaction tempFinAp4DeleteInvoiceMap is : " + tempFinAp4DeleteInvoiceMap);
            InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
            deleteParam.setBill4InvoiceMap(tempFinAp4DeleteInvoiceMap).setOperateKey(operateKey).setDeleteInvRow(false).setOnlyReleaseAmt(true).setNotDeleteBOTP(true);
            IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
            deleteService.deleteInvoiceRow(deleteParam);
            logger.info("ReplaceInvoiceAuditOp endOperationTransaction finapdeleteinvrow end.");
        }
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction finApBillParams is : " + finApBillParams);
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction invoiceAssignFinApParams is : " + invoiceAssignFinApParams);
        if (!finApBillParams.isEmpty() && !invoiceAssignFinApParams.isEmpty()) {
            AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
            assignInvoiceParam.setInvoiceBillParams(invoiceAssignFinApParams).setAsstBillParams(finApBillParams).setOperateKey(operateKey).setAutoAssign(false).setCreateBOTP(false).setBillAssignInvSrcTypeMap(finApAssignInvSrcTypeMap);
            IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
            assignInvoiceService.assign(assignInvoiceParam);
            logger.info("ReplaceInvoiceAuditOp endOperationTransaction finapassigninvoice end");
        }
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction apply4DeleteInvoiceMap is : " + apply4DeleteInvoiceMap);
        if (!apply4DeleteInvoiceMap.isEmpty()) {
            InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
            deleteParam.setBill4InvoiceMap(apply4DeleteInvoiceMap).setOnlyReleaseAmt(true).setOperateKey(operateKey);
            IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue());
            deleteService.deleteInvoiceRow(deleteParam);
            logger.info("ReplaceInvoiceAuditOp endOperationTransaction applydeleteinvrow end.");
        }
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction applyBillParams is : " + applyBillParams);
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction invoiceAssignApplyParams is : " + invoiceAssignApplyParams);
        if (!applyBillParams.isEmpty() && !invoiceAssignApplyParams.isEmpty()) {
            AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
            assignInvoiceParam.setInvoiceBillParams(invoiceAssignApplyParams).setAsstBillParams(applyBillParams).setAutoAssign(false).setBillAssignInvSrcTypeMap(applyAssignInvSrcTypeMap).setOperateKey(operateKey);
            IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYASSIGNINVOICE.getValue());
            assignInvoiceService.assign(assignInvoiceParam);
            logger.info("ReplaceInvoiceAuditOp endOperationTransaction applyassigninvoice end");
        }
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction invoiceUpdateBillInfo is : ");
        this.invoiceUpdateBillInfo(allInvoiceIds);
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction invoiceUpdateBillInfo end");
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction needDeleteInvRow is : " + applyBillParams);
        this.needDeleteInvRow(oldFin4InvUsedAmtMap);
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction needDeleteInvRow end");
        logger.info("ReplaceInvoiceAuditOp endOperationTransaction end.");
    }

    private Map<Long, DynamicObject> getFinApBillMap(DynamicObject[] dataEntities) {
        HashSet<Long> finApBillIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection newInvEntry = dataEntity.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                long finApBillId = newInvRow.getLong("n_apbillid");
                if (finApBillId == 0L) continue;
                finApBillIds.add(finApBillId);
            }
        }
        if (finApBillIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(8);
        }
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"pricetaxtotal,uninvoicedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        return Arrays.stream(finApBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
    }

    private Map<Long, Map<Long, BigDecimal>> getInvoice4FinApUsedAmtMap(DynamicObject[] dataEntities) {
        HashMap<Long, Map<Long, BigDecimal>> invoice4FinApUsedAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(8);
        HashSet<Long> blueInvIds = new HashSet<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
            DynamicObjectCollection newInvEntry = dataEntity.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                long blueInvId = newInvRow.getLong("n_blueinvid");
                if (blueInvId == 0L) continue;
                blueInvIds.add(blueInvId);
            }
        }
        if (blueInvIds.isEmpty()) {
            return invoice4FinApUsedAmtMap;
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("inventry.invid", "in", blueInvIds);
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_inv_usedamt", (String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{filter}, (String)"");
        for (Row row : finApDataSet) {
            Long finApBillId = row.getLong("id");
            Long invoiceId = row.getLong("inventry.invid");
            BigDecimal usedAmt = row.getBigDecimal("inventry.i_usedamt");
            Map finAp4UsedAmtMap = invoice4FinApUsedAmtMap.getOrDefault(invoiceId, new HashMap(8));
            finAp4UsedAmtMap.put(finApBillId, usedAmt);
            invoice4FinApUsedAmtMap.put(invoiceId, finAp4UsedAmtMap);
        }
        return invoice4FinApUsedAmtMap;
    }

    private void invoiceUpdateBillInfo(Set<Long> allInvoiceIds) {
        DynamicObject[] finApBills;
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,synstatus,serialno,isreffin,businesssource,org,changesynstatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", allInvoiceIds)});
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject invoice : invoices) {
            orgIds.add(invoice.getLong("org.id"));
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoice.set("synstatus", (Object)"waitsynchro");
            invoice.set("changesynstatustime", (Object)new Date());
        }
        HashSet<Long> relateApplyInvIds = new HashSet<Long>(8);
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("settleorg", "in", orgIds), new QFilter("inventry.invid", "in", allInvoiceIds)}, (String)"");
        for (Row row : applyDataSet) {
            relateApplyInvIds.add(row.getLong("inventry.invid"));
        }
        HashSet<Long> relateFinApInvIds = new HashSet<Long>(8);
        HashSet<Long> apCollectInvIds = new HashSet<Long>(8);
        for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,inventry.invid,inventry.isprepayinv,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("inventry.invid", "in", allInvoiceIds)})) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                if (!allInvoiceIds.contains(invId)) continue;
                relateFinApInvIds.add(invId);
                invRow.set("isprepayinv", (Object)relateApplyInvIds.contains(invId));
                if (!InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype"))) continue;
                apCollectInvIds.add(invId);
            }
        }
        for (DynamicObject invoice : invoices) {
            long invoiceId = invoice.getLong("id");
            if (invoice.getBoolean("isreffin") && ObjectUtils.isEmpty((Object)invoice.getString("businesssource"))) {
                if (relateApplyInvIds.contains(invoiceId)) {
                    invoice.set("businesssource", (Object)"ap_payapply");
                    continue;
                }
                invoice.set("businesssource", (Object)"ap_finapbill");
                continue;
            }
            if (relateApplyInvIds.contains(invoiceId)) {
                invoice.set("businesssource", (Object)"ap_payapply");
                continue;
            }
            if (relateFinApInvIds.contains(invoiceId) && apCollectInvIds.contains(invoiceId)) {
                invoice.set("isreffin", (Object)Boolean.TRUE);
                invoice.set("businesssource", (Object)"ap_finapbill");
                continue;
            }
            invoice.set("isreffin", (Object)Boolean.FALSE);
            invoice.set("businesssource", (Object)" ");
        }
        SaveServiceHelper.save((DynamicObject[])invoices);
        SaveServiceHelper.save((DynamicObject[])finApBills);
    }

    private void needDeleteInvRow(Map<Long, Map<Long, BigDecimal>> oldFin4InvUsedAmtMap) {
        ArrayList deleteBotpParamList = new ArrayList(8);
        for (Map.Entry<Long, Map<Long, BigDecimal>> entrySet : oldFin4InvUsedAmtMap.entrySet()) {
            long finApBillId = entrySet.getKey();
            Set<Long> set = entrySet.getValue().keySet();
            for (Long invoiceId : set) {
                HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
                paramMap.put("srcBillId", invoiceId);
                paramMap.put("tarBillId", finApBillId);
                deleteBotpParamList.add(paramMap);
            }
        }
        QFilter filter = new QFilter("id", "in", oldFin4InvUsedAmtMap.keySet());
        DataSet finApBillDataSet = QueryServiceHelper.queryDataSet((String)"query_latest_finap", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, List> needSaveBotpMap = new HashMap<Long, List>(8);
        for (Row row : finApBillDataSet) {
            Long finApBillId = row.getLong("id");
            Long invId = row.getLong("inventry.invid");
            if (invId == 0L) continue;
            List tempInvoiceIds = needSaveBotpMap.getOrDefault(finApBillId, new ArrayList(8));
            tempInvoiceIds.add(invId);
            needSaveBotpMap.put(finApBillId, tempInvoiceIds);
        }
        for (Map map : deleteBotpParamList) {
            long srcBillId = (Long)map.get("srcBillId");
            long tarBillId = (Long)map.get("tarBillId");
            InvoiceHelper.deleteRelation((String)"ap_finapbill", (Long)tarBillId, (Long)srcBillId);
        }
        if (!needSaveBotpMap.isEmpty()) {
            BillRelationBuilder billRelationBuilder = new BillRelationBuilder("ap_invoice", "ap_finapbill");
            for (Map.Entry entrySet : needSaveBotpMap.entrySet()) {
                billRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
            }
        }
    }

    private Map<Long, Map<Long, BigDecimal>> getOldFin4InvUsedAmtMap(DynamicObject[] dataEntities) {
        HashSet<Long> finApBillIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection oldInvEntry = dataEntity.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long apBillId = oldInvRow.getLong("o_apbillid");
                if (apBillId == 0L) continue;
                finApBillIds.add(apBillId);
            }
        }
        if (finApBillIds.isEmpty()) {
            return new HashMap<Long, Map<Long, BigDecimal>>(8);
        }
        HashMap<Long, Map<Long, BigDecimal>> oldFin4InvUsedAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(8);
        DataSet finApBillDataSet = QueryServiceHelper.queryDataSet((String)"query_old_fin_inv", (String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)}, (String)"");
        for (Row row : finApBillDataSet) {
            Long id = row.getLong("id");
            Long invId = row.getLong("inventry.invid");
            if (invId == 0L) continue;
            Map invUsedAmtMap = oldFin4InvUsedAmtMap.getOrDefault(id, new HashMap(8));
            invUsedAmtMap.put(invId, row.getBigDecimal("inventry.i_usedamt"));
            oldFin4InvUsedAmtMap.put(id, invUsedAmtMap);
        }
        return oldFin4InvUsedAmtMap;
    }

    private long getAccurateArticulateId(PrimitiveIterator.OfLong iterator) {
        if (!iterator.hasNext()) {
            long[] uniqueKeyArray = DB.genGlobalLongIds((int)100);
            iterator = Arrays.stream(uniqueKeyArray).iterator();
        }
        return iterator.next();
    }

    private Map<Long, DynamicObject> getInvoiceMap(DynamicObject[] dataEntities) {
        HashSet<Long> invoiceIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection oldInvEntry = dataEntity.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                invoiceIds.add(oldInvRow.getLong("o_invid"));
            }
            DynamicObjectCollection newInvEntry = dataEntity.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                invoiceIds.add(newInvRow.getLong("n_invid"));
            }
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selectors = e.getFieldKeys();
        selectors.add("org");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("billno");
        selectors.add("o_isprepayinv");
        selectors.add("o_invbillno");
        selectors.add("o_serialno");
        selectors.add("o_apbillno");
        selectors.add("o_usedamt");
        selectors.add("o_apbillid");
        selectors.add("o_applybillno");
        selectors.add("o_applybillid");
        selectors.add("o_applybillid");
        selectors.add("o_invbillno");
        selectors.add("o_invid");
        selectors.add("n_isprepayinv");
        selectors.add("n_invid");
        selectors.add("n_invbillno");
        selectors.add("n_serialno");
        selectors.add("n_blueinvid");
        selectors.add("n_blueinvno");
        selectors.add("n_apbillno");
        selectors.add("n_usedamt");
        selectors.add("n_apbillid");
        selectors.add("n_applybillno");
        selectors.add("n_applybillid");
        selectors.add("n_srctype");
        selectors.add("oldinventry.pid");
        selectors.add("newinventry.pid");
        selectors.add("newinventry.seq");
        selectors.add("oldinventry.seq");
    }
}

