/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class UpdateInvoiceCloudOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(UpdateInvoiceCloudOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("serialno");
        fieldKeys.add("istaxdeduction");
        fieldKeys.add("synstatus");
        fieldKeys.add("billno");
        fieldKeys.add("changesynstatustime");
        fieldKeys.add("buyertin");
        fieldKeys.add("org");
        fieldKeys.add("sellertin");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String isSynchInvoiceCloud = StdConfig.get((String)"isSynchInvoiceCloud");
        if ("false".equalsIgnoreCase(isSynchInvoiceCloud)) {
            return;
        }
        List<Long> invoiceIds = this.hasConfigCloudOrgIds(dataEntities);
        if (ObjectUtils.isEmpty(invoiceIds)) {
            logger.info("There is no qualified ap_invoice bill .");
            return;
        }
        CallCloudHelper.updateCloudInvoicePool(invoiceIds);
        this.getOperationResult().setMessage("updateCloud_is_success");
    }

    private List<Long> hasConfigCloudOrgIds(DynamicObject[] dataEntities) {
        if (EmptyUtils.isEmpty((Object)(dataEntities = (DynamicObject[])Arrays.stream(dataEntities).filter(bill -> "waitsynchro".equals(bill.getString("synstatus"))).filter(bill -> EmptyUtils.isNotEmpty((Object)bill.getString("serialno"))).toArray(DynamicObject[]::new)))) {
            return new ArrayList<Long>(2);
        }
        HashSet<Long> orgIds = new HashSet<Long>(64);
        HashSet<Object> sellertins = new HashSet<Object>(64);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
            sellertins.add(dataEntity.get("buyertin"));
        }
        HashMap<Long, Boolean> hasEnableOrgMap = new HashMap<Long, Boolean>(64);
        Map cloudConfigs = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfg", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        for (Map.Entry entrySet : cloudConfigs.entrySet()) {
            hasEnableOrgMap.put(((DynamicObject)entrySet.getValue()).getLong("org.id"), true);
        }
        HashMap<String, Boolean> hasEnableTaxNumMap = new HashMap<String, Boolean>(64);
        Map cloudGroupConfigs = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (String)"taxregnum", (QFilter[])new QFilter[]{new QFilter("taxregnum", "in", sellertins), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        for (Map.Entry entrySet : cloudGroupConfigs.entrySet()) {
            hasEnableTaxNumMap.put(((DynamicObject)entrySet.getValue()).getString("taxregnum"), Boolean.TRUE);
        }
        return Arrays.stream(dataEntities).filter(entity -> hasEnableOrgMap.getOrDefault(entity.getLong("org.id"), Boolean.FALSE) != false || hasEnableTaxNumMap.getOrDefault(entity.getString("buyertin"), Boolean.FALSE) != false).map(inv -> inv.getLong("id")).collect(Collectors.toList());
    }
}

