/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.UpdateInvStatusValidator;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class UpdateInvoiceStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(UpdateInvoiceStatusOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("serialno");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("synstatus");
        fieldKeys.add("billno");
        fieldKeys.add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String isSynchInvoiceCloud = StdConfig.get((String)"isSynchInvoiceCloud");
        if ("false".equalsIgnoreCase(isSynchInvoiceCloud)) {
            return;
        }
        UpdateInvStatusValidator invStuValidator = new UpdateInvStatusValidator();
        e.addValidator((AbstractValidator)invStuValidator);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("UpdateInvoiceStatusOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = e.getDataEntities();
        Map orgForSerialMap = InvoiceHelper.getOrgForSerialMap((DynamicObject[])dataEntities);
        List invoiceVOS = CallCloudHelper.queryCloudInvoice((Map)orgForSerialMap);
        if (ObjectUtils.isEmpty((Object)invoiceVOS)) {
            return;
        }
        Map<String, String> invoiceVoMap = invoiceVOS.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, InvoiceVO::getInvoiceStatus));
        HashSet<Long> invoiceIds = new HashSet<Long>(32);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> needSaveInvoices = new ArrayList<DynamicObject>(32);
        for (DynamicObject invoice : dataEntities) {
            String serialNo = invoice.getString("serialno");
            if (!StringUtils.isNotEmpty((String)invoiceVoMap.get(serialNo))) continue;
            String invStatus = invoiceVoMap.get(serialNo);
            invoice.set("invoicestatus", (Object)invStatus);
            needSaveInvoices.add(invoice);
            if ("0".equals(invStatus) || !StringUtils.isNotEmpty((String)invStatus)) continue;
            invoiceIds.add(invoice.getLong("id"));
            orgIds.add(invoice.getLong("org.id"));
        }
        if (needSaveInvoices.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])needSaveInvoices.toArray(new DynamicObject[0]));
        this.updateApInvStatus(invoiceIds, orgIds);
        logger.info("UpdateInvoiceStatusOp endOperationTransaction end.");
    }

    private void updateApInvStatus(Set<Long> invoiceIds, Set<Long> orgIds) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String isTaskSys = (String)variables.get("sendwarnmsg");
        logger.info("\u67e5\u8be2\u5e94\u4ed8\u53d1\u7968\u5f00\u59cb\uff0cisTaskSys\uff1a" + isTaskSys);
        if (!"false".equals(isTaskSys)) {
            QFilter filter = new QFilter("org", "in", orgIds);
            filter.and(new QFilter("inventry.invid", "in", invoiceIds));
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap_id", (String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
            if (finApDataSet.hasNext()) {
                ArrayList<Long> finApBillIds = new ArrayList<Long>(8);
                for (Row finApRow : finApDataSet) {
                    finApBillIds.add(finApRow.getLong("id"));
                }
                logger.info("\u8d22\u52a1\u5e94\u4ed8\u5355\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5f00\u59cb" + finApBillIds);
                OperationServiceHelper.executeOperate((String)"sendinvmsgwarn", (String)"ap_finapbill", (Object[])finApBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                logger.info("\u8d22\u52a1\u5e94\u4ed8\u5355\u53d1\u9001\u9884\u8b66\u6d88\u606f\u7ed3\u675f");
            }
            QFilter filter1 = new QFilter("settleorg", "in", orgIds);
            filter1.and(new QFilter("inventry.invid", "in", invoiceIds));
            DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply_id", (String)"ap_payapply", (String)"id", (QFilter[])new QFilter[]{filter1}, (String)"");
            if (applyDataSet.hasNext()) {
                ArrayList<Long> applyIds = new ArrayList<Long>(8);
                for (Row applyRow : applyDataSet) {
                    applyIds.add(applyRow.getLong("id"));
                }
                logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5f00\u59cb" + applyIds);
                OperationServiceHelper.executeOperate((String)"sendinvmsgwarn", (String)"ap_payapply", (Object[])applyIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                logger.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u53d1\u9001\u9884\u8b66\u6d88\u606f\u7ed3\u675f");
            }
        }
    }
}

