/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.VerifyServiceFactory;
import kd.fi.ap.validator.VerifyRecordUnVerifyValidator;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.opplugin.VerifyRecordBaseUnVerifyOp;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.util.EmptyUtils;

public class VerifyRecordUnverifyOp
extends VerifyRecordBaseUnVerifyOp {
    private static final Log logger = LogFactory.getLog(VerifyRecordUnverifyOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        VerifyRecordUnVerifyValidator validator = new VerifyRecordUnVerifyValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = this.getAllData(e.getDataEntities());
        Map map = VerifyServiceHelper.classfyByRelation((DynamicObject[])entities);
        this.purSelfUnverifyCheck(map);
        for (Map.Entry entry : map.entrySet()) {
            AbstractVerifyTemplate service = VerifyServiceFactory.getService((String)((String)entry.getKey()));
            service.unVerify(((List)entry.getValue()).toArray(new DynamicObject[0]));
        }
    }

    private void purSelfUnverifyCheck(Map<String, List<DynamicObject>> map) {
        List<DynamicObject> omSelfList;
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (!isCQConfig.booleanValue()) {
            return;
        }
        List<DynamicObject> purSelfList = map.get(VerifyRelationEnum.PURSELF.getValue());
        if (EmptyUtils.isNotEmpty(purSelfList)) {
            this.purSelfUnverifyCheckByVerifyRelation("im_purinbill", "billentry", purSelfList);
        }
        if (EmptyUtils.isNotEmpty(omSelfList = map.get(VerifyRelationEnum.OMINSELF.getValue()))) {
            this.purSelfUnverifyCheckByVerifyRelation("im_mdc_omcmplinbill", "billentry", omSelfList);
        }
    }

    private void purSelfUnverifyCheckByVerifyRelation(String entityName, String entryKey, List<DynamicObject> purSelfList) {
        logger.info("purSelfUnverifyCheckByVerifyRelation begin");
        HashSet asstactIds = new HashSet(64);
        purSelfList.forEach(entry -> asstactIds.add(entry.getLong("asstact.id")));
        ArrayList ispremiumIds = new ArrayList(64);
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        Arrays.stream(suppliers).filter(supplier -> supplier.getBoolean("issuppcolla")).forEach(supplier -> ispremiumIds.add(supplier.getLong("id")));
        if (ispremiumIds.size() > 0) {
            logger.info("purSelfUnverifyCheckByVerifyRelation build begin");
            HashMap<Long, List<Long>> dataMap = new HashMap<Long, List<Long>>(64);
            HashMap<Long, String> billIdToBillNoMapping = new HashMap<Long, String>(64);
            for (DynamicObject purSelf : purSelfList) {
                long asstactId = purSelf.getLong("asstact.id");
                if (!ispremiumIds.contains(asstactId)) continue;
                this.buildParamAndMapping(dataMap, purSelf, billIdToBillNoMapping);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(64);
            paramMap.put("billIds", dataMap);
            paramMap.put("entityName", entityName);
            paramMap.put("entryKey", entryKey);
            try (TXHandle tx = TX.requiresNew((String)"unVerifyinvokeScm");){
                logger.info("request param is" + paramMap);
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"ICancelVerifyService", (String)"CanCancelVerify", (Object[])new Object[]{paramMap});
                if (resultMap.size() > 0 && !((Boolean)resultMap.get("succed")).booleanValue()) {
                    Map resultDataMap = (Map)resultMap.get("data");
                    HashSet billNos = new HashSet(2);
                    for (Long billid : resultDataMap.keySet()) {
                        billNos.add(billIdToBillNoMapping.get(billid));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u6838\u9500\u5931\u8d25\uff0c\u6240\u9009\u5355\u636e%s\u5df2\u7531\u4f9b\u5e94\u5546\u534f\u540c\u5bf9\u8d26\uff0c\u4e0d\u5141\u8bb8\u53cd\u6838\u9500\u3002", (String)"VerifyRecordUnverifyOp_0", (String)"fi-ap-opplugin", (Object[])new Object[]{String.join((CharSequence)",", billNos)}));
                }
            }
        }
    }

    private void buildParamAndMapping(Map<Long, List<Long>> dataMap, DynamicObject purSelf, Map<Long, String> billIdToBillNoMapping) {
        List<Long> entryIds;
        Long billId = purSelf.getLong("billid");
        Long entryId = purSelf.getLong("billentryid");
        String billNo = purSelf.getString("billno");
        if (dataMap.get(billId) != null) {
            entryIds = dataMap.get(billId);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        } else {
            entryIds = new ArrayList<Long>(8);
            entryIds.add(entryId);
            dataMap.put(billId, entryIds);
            billIdToBillNoMapping.put(billId, billNo);
        }
        DynamicObjectCollection entry = purSelf.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            List<Long> entryIds2;
            billId = row.getLong("e_billid");
            entryId = row.getLong("e_billentryid");
            billNo = row.getString("e_billno");
            if (dataMap.get(billId) != null) {
                entryIds2 = dataMap.get(billId);
                entryIds2.add(entryId);
                dataMap.put(billId, entryIds2);
                billIdToBillNoMapping.put(billId, billNo);
                continue;
            }
            entryIds2 = new ArrayList<Long>(8);
            entryIds2.add(entryId);
            dataMap.put(billId, entryIds2);
            billIdToBillNoMapping.put(billId, billNo);
        }
    }
}

