/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin.unittest.scene.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.ap.opplugin.AntiClosePeriodOp;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PaidBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.ViewInfoTestHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.junit.Test;

public class AP006_001_InitSaveAndClosePeriodUnitTest
extends AbstractJUnitTestPlugIn {
    private DynamicObject unInitOrg2;
    private DynamicObject unInitOrg3;
    private DynamicObject initData;
    private DynamicObjectCollection orgCollection = new DynamicObjectCollection();
    private Long unInitOrg2Id;
    private Long unInitOrg3Id;
    private DynamicObject curPeriod;
    private DynamicObject nextPeriod;
    private static final BigDecimal BIGDECIMAL_50 = new BigDecimal(50);
    private static final BigDecimal BIGDECIMAL_100 = new BigDecimal(100);
    private static final Integer INDEX_ONE = 1;
    private static final Integer INDEX_ZREO = 0;
    SimulatorTestHelper simulatorTestHelper;

    public void initData() {
        block2: {
            super.initData();
            this.simulatorTestHelper = new SimulatorTestHelper((AbstractJUnitTestPlugIn)this);
            this.unInitOrg2 = BaseDataTestProvider.getUnInitOrg2();
            this.unInitOrg3 = BaseDataTestProvider.getUnInitOrg3();
            this.orgCollection.add(0, this.unInitOrg2);
            this.orgCollection.add(1, this.unInitOrg3);
            this.unInitOrg2Id = this.unInitOrg2.getLong("id");
            this.unInitOrg3Id = this.unInitOrg3.getLong("id");
            try {
                this.curPeriod = BaseDataTestProvider.getPeriod();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (!message.contains("period")) break block2;
                throw new KDBizException("period null, please rebuild basedata");
            }
        }
        this.nextPeriod = PeriodHelper.getNextPeriod((long)this.curPeriod.getLong("id"));
        this.deleteRelatedBill(true);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u521d\u59cb\u5316\u4fdd\u5b58")
    @Test
    public void initSaveForAdjExchTest() throws InterruptedException {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("ap_031", 1);
        SystemParameterHelper.setSystemParameter((boolean)false, (long)this.unInitOrg2Id, paramMap);
        paramMap.put("ap_031", 0);
        SystemParameterHelper.setSystemParameter((boolean)false, (long)this.unInitOrg3Id, paramMap);
        Thread.sleep(1000L);
        this.removeOrgFilter();
        String clickInitSettingButtonParam = "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"set_btn\",\"\"],\"postData\":[{},[]]}]";
        IFormView settingView = ViewInfoTestHelper.getChildView((IFormView)this.getView(), (String)clickInitSettingButtonParam, (AbstractJUnitTestPlugIn)this);
        IDataModel settingDataModel = settingView.getModel();
        settingDataModel.setValue("orgs", (Object)this.orgCollection);
        settingDataModel.setValue("periodtype", this.nextPeriod.get("periodtype"));
        settingDataModel.setValue("startperiod", (Object)this.curPeriod);
        settingDataModel.setValue("standardcurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        settingDataModel.setValue("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        settingDataModel.setValue("settlemodel", (Object)"1");
        String clickSaveButtonParam = "[{\"key\":\"btnok\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(settingView, clickSaveButtonParam);
        DynamicObject[] initDatas = this.getInitDatas();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (initDatas.length == 2 ? 1 : 0) != 0);
        this.checkAdjExchRecord(this.unInitOrg3Id, 0L, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u521d\u59cb\u5316\u66f4\u65b0\u540e\u4fdd\u5b58")
    @Test
    public void initUpdateAndSaveForAdjExchTest() {
        this.initData = BusinessDataServiceHelper.loadSingle((String)"ap_init", (String)"id,startperiod,startdate,standardcurrency,exratetable,org,curperiod,isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id)});
        this.selectTargetDataRow();
        DynamicObject periodBusBill = this.existBizBillValidatorTest();
        this.existPeriodBillValidatorTest(periodBusBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u521d\u59cb\u5316\u66f4\u65b0\u540e\u4fdd\u5b582")
    @Test
    public void initUpdateAndSaveForAdjExchTestTwo() {
        HashSet<String> billNos = new HashSet<String>();
        billNos.add("InitSaveUnitTest_BusBill_01");
        this.deleteBill("ap_busbill", billNos);
        this.selectTargetDataRow();
        this.finishInitValidatorTest();
    }

    @TestMethod(value=4)
    @DisplayName(value="\u521d\u59cb\u5316\u66f4\u65b0\u540e\u4fdd\u5b583")
    @Test
    public void initUpdateAndSaveForAdjExchTestThree() {
        this.initData.set("isfinishinit", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.initData});
        this.selectTargetDataRow();
        this.checkSystemParamChange();
    }

    @TestMethod(value=5)
    @DisplayName(value="\u7ed3\u675f\u521d\u59cb\u5316")
    @Test
    public void finishInitForAdjExchTest() {
        this.buildBillData();
        this.selectTargetDataRows();
        this.getView().invokeOperation("submit");
        this.checkIsFinishInitKey("true");
        this.checkInitHyperLinkAndAmt(true);
        this.checkInitBillStatus("C");
        this.checkAdjExchRecord(this.unInitOrg2Id, this.curPeriod.getLong("id"), true);
        this.checkAdjExchRecord(this.unInitOrg3Id, this.curPeriod.getLong("id"), false);
        this.checkJournal();
        this.checkCloseRecordExist(true);
        this.checkBalance(true);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u53cd\u521d\u59cb\u5316")
    @Test
    public void antiFinishInitTest() {
        this.selectTargetDataRows();
        this.insertAdjExchAndJournalBill(this.initData.getDynamicObject("startperiod"));
        this.checkAntiCloseInitValidator();
        this.invokeAntiCloseInitOp();
        this.checkDeleteAdjExch();
        this.checkInitBillStatus("B");
        this.checkIsFinishInitKey("false");
        this.checkInitHyperLinkAndAmt(false);
        this.deleteRelatedBill(false);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u7ed3\u8d26\u6821\u9a8c")
    @Test
    public void closePeriodTest() {
        this.buildBillData();
        this.selectTargetDataRow();
        this.getView().invokeOperation("submit");
        this.checkClosePeriodValidator();
        this.invokeAntiCloseInitOp();
    }

    @TestMethod(value=8)
    @DisplayName(value="\u7ed3\u8d26\u6210\u529f")
    @Test
    public void closePeriodSuccessTest() {
        this.selectTargetDataRows();
        this.getView().invokeOperation("submit");
        this.updateDataForClosePeriod();
        this.invokeClosePeriod();
        this.checkInitDataCurPeriod(this.nextPeriod.getLong("id"));
        this.checkAdjExchRecord(this.unInitOrg2Id, this.nextPeriod.getLong("id"), true);
        this.checkAdjExchRecord(this.unInitOrg3Id, this.nextPeriod.getLong("id"), false);
        this.checkBalance(false);
    }

    @TestMethod(value=9)
    @DisplayName(value="\u53cd\u7ed3\u8d26")
    @Test
    public void antiClosePeriodTest() {
        this.insertAdjExchAndJournalBill(this.nextPeriod);
        this.selectTargetDataRows();
        this.invokeAntiClosePeriod();
        this.checkInitDataCurPeriod(this.curPeriod.getLong("id"));
        this.checkBalanceExist(false);
        this.checkAdjExchRecord(this.unInitOrg2Id, this.nextPeriod.getLong("id"), false);
        this.checkAdjExchBill(this.unInitOrg2Id, this.nextPeriod.getLong("id"), false);
        this.restoreDatas();
        this.deleteRelatedBill(false);
    }

    private String getOrgNameFilter1() {
        return ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\u4e13\u75281", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
    }

    private String getOrgNameFilter2() {
        return ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\u4e13\u7528", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
    }

    private void removeOrgFilter() {
        String cancelOrgFilterParam = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"ap_init\"],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(cancelOrgFilterParam);
    }

    private void checkAdjExchRecord(Long orgId, Long periodID, boolean param) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodID);
        QFilter bizFilter = new QFilter("bizsystem", "=", (Object)"AP");
        boolean adjExchRecordExistKey = QueryServiceHelper.exists((String)"ap_adjustexch", (QFilter[])new QFilter[]{orgFilter, periodFilter, bizFilter});
        if (param) {
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)adjExchRecordExistKey);
        } else {
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)false, (boolean)adjExchRecordExistKey);
        }
    }

    private void selectTargetDataRow() {
        this.removeOrgFilter();
        String orgCommonSerachParam = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"org.id\"],\"Value\":[\"" + this.unInitOrg2Id + "\"],\"Compare\":[\"\"]}],\"ap_init\"],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(orgCommonSerachParam);
        String selectAllParam = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"0\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[[\"" + this.initData.getString("id") + "\",\"UNITTESTORG-0004\",null,\"\"]]}},[]]}]";
        this.simulatorTestHelper.invokeAction(selectAllParam);
    }

    private DynamicObject existBizBillValidatorTest() {
        String result;
        DynamicObject periodBusBill = BusApBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_BusBill_01", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_100);
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)result, (boolean)true, ((result = this.clickInitSettingButton()) != null && result.contains(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5b58\u5728\u4e1a\u52a1\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_2", (String)"fi-ap-opplugin", (Object[])new Object[0])) ? 1 : 0) != 0);
        return periodBusBill;
    }

    private String clickInitSettingButton() {
        String clickInitSettingButtonParam = "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"set_btn\",\"\"],\"postData\":[{},[]]}]";
        return this.simulatorTestHelper.invokeAction(clickInitSettingButtonParam);
    }

    private void existPeriodBillValidatorTest(DynamicObject periodBusBill) {
        this.updatePeriodBusBill(periodBusBill);
        String result = this.clickInitSettingButton();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)result, (boolean)true, (result != null && result.contains(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5b58\u5728\u4e1a\u52a1\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_3", (String)"fi-ap-opplugin", (Object[])new Object[0])) ? 1 : 0) != 0);
    }

    private void updatePeriodBusBill(DynamicObject periodBusBill) {
        Date date = DateUtils.getLastDay((Date)BaseDataTestProvider.getPeriod().getDate("begindate"), (int)10);
        periodBusBill.set("bizdate", (Object)date);
        periodBusBill.set("bookdate", (Object)date);
        periodBusBill.set("isperiod", (Object)1);
        periodBusBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodBusBill});
    }

    private void updatePeriodBusBillWithSupplier(DynamicObject periodBusBill, DynamicObject supplier) {
        Date date = DateUtils.getLastDay((Date)BaseDataTestProvider.getPeriod().getDate("begindate"), (int)10);
        periodBusBill.set("bizdate", (Object)date);
        periodBusBill.set("bookdate", (Object)date);
        periodBusBill.set("isperiod", (Object)1);
        periodBusBill.set("billstatus", (Object)"B");
        periodBusBill.set("asstact", supplier.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodBusBill});
    }

    private void updatePeriodBusBillWithCurrency(DynamicObject periodBusBill, DynamicObject currencyUSD) {
        Date date = DateUtils.getLastDay((Date)BaseDataTestProvider.getPeriod().getDate("begindate"), (int)10);
        periodBusBill.set("bizdate", (Object)date);
        periodBusBill.set("bookdate", (Object)date);
        periodBusBill.set("isperiod", (Object)1);
        periodBusBill.set("billstatus", (Object)"B");
        periodBusBill.set("currency", currencyUSD.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodBusBill});
    }

    private void finishInitValidatorTest() {
        this.initData.set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.initData});
        String result = this.clickInitSettingButton();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)result, (boolean)true, (result != null && result.contains(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_4", (String)"fi-ap-opplugin", (Object[])new Object[0])) ? 1 : 0) != 0);
    }

    private void checkSystemParamChange() {
        String clickInitSettingButtonParam = "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"set_btn\",\"\"],\"postData\":[{},[]]}]";
        this.getModel().updateCache();
        IFormView settingView = ViewInfoTestHelper.getChildView((IFormView)this.getView(), (String)clickInitSettingButtonParam, (AbstractJUnitTestPlugIn)this);
        IDataModel settingDataModel = settingView.getModel();
        settingDataModel.setValue("settlemodel", (Object)"1");
        String clickSaveButtonParam = "[{\"key\":\"btnok\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]";
        String result = this.simulatorTestHelper.invokeAction(settingView, clickSaveButtonParam);
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)result, (String)"1", (String)SystemParameterHelper.getAPAppParameter((Long)this.unInitOrg2Id, (String)"ap_003").toString());
    }

    private void deleteBill(String entityName, Set<String> billNos) {
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
    }

    private void updatePeriodFinBill(DynamicObject periodFinBill) {
        Date date = DateUtils.getLastDay((Date)BaseDataTestProvider.getPeriod().getDate("begindate"), (int)10);
        periodFinBill.set("bizdate", (Object)date);
        periodFinBill.set("bookdate", (Object)date);
        periodFinBill.set("isperiod", (Object)1);
        periodFinBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodFinBill});
    }

    private void buildBillData() {
        DynamicObject periodBusBill = BusApBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_BusBill_02", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_100);
        this.updatePeriodBusBill(periodBusBill);
        DynamicObject periodFinBill = FinApBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_FinBill_01", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_100);
        this.updatePeriodFinBill(periodFinBill);
        DynamicObject periodPaidBill = PaidBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_PaidBill_01", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_100);
        this.updatePeriodPaidBill(periodPaidBill);
        QFilter idFilter = new QFilter("id", "!=", BaseDataTestProvider.getSupplier().getPkValue());
        QFilter numFilter = new QFilter("number", "!=", (Object)"arap-unittest-runtime-supplier");
        QFilter otherFilter = new QFilter("internal_company", "=", (Object)0L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{idFilter, numFilter, otherFilter, enableFilter});
        if (selectOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599-\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_supplier");
        DynamicObject periodBusBill2 = BusApBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_BusBill_03", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_50);
        this.updatePeriodBusBillWithSupplier(periodBusBill2, supplier);
        DynamicObject periodBusBill3 = BusApBillTestDataProvider.buildByHeadPriceTaxTotal((String)"InitSaveUnitTest_BusBill_04", (DynamicObject)this.unInitOrg2, (BigDecimal)BIGDECIMAL_50);
        this.updatePeriodBusBillWithCurrency(periodBusBill3, BaseDataTestProvider.getCurrencyUSD());
    }

    private void checkIsFinishInitKey(String param) {
        DynamicObject[] initDatas = this.getInitDatas();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)param, (String)initDatas[INDEX_ZREO].getString("isfinishinit"));
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)param, (String)initDatas[INDEX_ONE].getString("isfinishinit"));
    }

    private void updatePeriodPaidBill(DynamicObject periodPaidBill) {
        Date date = DateUtils.getLastDay((Date)BaseDataTestProvider.getPeriod().getDate("begindate"), (int)10);
        periodPaidBill.set("bizdate", (Object)date);
        periodPaidBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodPaidBill});
    }

    private DynamicObject[] getInitDatas() {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        orgIds.add(this.unInitOrg2Id);
        orgIds.add(this.unInitOrg3Id);
        return BusinessDataServiceHelper.load((String)"ap_init", (String)"id,org,isfinishinit,currentdate,curperiod,startdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)}, (String)"org");
    }

    private void selectTargetDataRows() {
        DynamicObject[] initDatas = this.getInitDatas();
        String org2Id = initDatas[INDEX_ZREO].getString("id");
        String org3Id = initDatas[INDEX_ONE].getString("id");
        this.removeOrgFilter();
        String orgCommonSerachParam = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"org.name\"],\"Value\":[\"" + this.getOrgNameFilter2() + "\"]}],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"ap_init\"],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(orgCommonSerachParam);
        String selectAllParam = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"0\",\"row\":0,\"selRows\":[0,1],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[[\"" + org2Id + "\",\"UNITTESTORG-0004\",\"C\",\"\"],[\"" + org3Id + "\",\"UNITTESTORG-0005\",\"C\",\"\"]]}},[]]}]";
        this.simulatorTestHelper.invokeAction(selectAllParam);
    }

    private void checkInitHyperLinkAndAmt(boolean isForCoverage) {
        String orgCommonSerachParam = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"org.name\"],\"Value\":[\"" + this.getOrgNameFilter1() + "\"]}],[{\"FieldName\":[\"org.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"ap_init\"],\"postData\":[{},[]]}]";
        this.simulatorTestHelper.invokeAction(orgCommonSerachParam);
        String clickHyperLinkParam = "[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"startperiod_name\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[[\"" + this.initData.getString("id") + "\",\"UNITTESTORG-0004\",null,\"\"]]}},[]]},{\"key\":\"billlistap\",\"methodName\":\"hyperLinkClick\",\"args\":[\"startperiod_name\",0],\"postData\":[{},[]]}]";
        IFormView initEditView = ViewInfoTestHelper.getChildView((IFormView)this.getView(), (String)clickHyperLinkParam, (AbstractJUnitTestPlugIn)this);
        IDataModel initEditDataModel = initEditView.getModel();
        DynamicObjectCollection entryData = initEditDataModel.getEntryEntity("entryentity");
        for (DynamicObject rowData : entryData) {
            DynamicObject asstact = rowData.getDynamicObject("asstact");
            DynamicObject currency = rowData.getDynamicObject("currency");
            if (asstact.getString("id").equals(BaseDataTestProvider.getSupplier().getString("id")) && currency.getString("id").equals(BaseDataTestProvider.getCurrencyCNY().getString("id"))) {
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(rowData.getBigDecimal("businessamount")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(rowData.getBigDecimal("invoiceamount")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(rowData.getBigDecimal("paymentamount")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(rowData.getBigDecimal("totalamount")));
                continue;
            }
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(rowData.getBigDecimal("businessamount")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(rowData.getBigDecimal("invoiceamount")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(rowData.getBigDecimal("paymentamount")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(rowData.getBigDecimal("totalamount")));
        }
        if (isForCoverage) {
            String param = "[{\"key\":\"entryentity\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"entryentity\":{\"fieldKey\":\"businessamount\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]},{\"key\":\"entryentity\",\"methodName\":\"hyperLinkClick\",\"args\":[\"businessamount\",0],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
            param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_ap_busbill\",\"\"],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
            param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_ap_finapbill\",\"\"],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
            param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_ap_paidbill\",\"\"],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
            param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_ap_adjexchbill\",\"\"],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
            param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"antiinit_btn\",\"\"],\"postData\":[{},[]]}]";
            this.simulatorTestHelper.invokeAction(initEditView, param);
        }
        initEditView.close();
    }

    private DynamicObject[] getBills(String entityName, Set<String> billNos) {
        return BusinessDataServiceHelper.load((String)entityName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
    }

    private void checkInitBillStatus(String param) {
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("InitSaveUnitTest_BusBill_02");
        billNos.add("InitSaveUnitTest_BusBill_03");
        billNos.add("InitSaveUnitTest_BusBill_04");
        DynamicObject[] busDatas = this.getBills("ap_busbill", billNos);
        this.checkBillStatus(busDatas, param);
        billNos.clear();
        billNos.add("InitSaveUnitTest_FinBill_01");
        DynamicObject[] finDatas = this.getBills("ap_finapbill", billNos);
        this.checkBillStatus(finDatas, param);
        billNos.clear();
        billNos.add("InitSaveUnitTest_PaidBill_01");
        DynamicObject[] paidDatas = this.getBills("ap_paidbill", billNos);
        this.checkBillStatus(paidDatas, param);
    }

    private void checkBillStatus(DynamicObject[] datas, String param) {
        for (DynamicObject data : datas) {
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)param, (String)data.getString("billstatus"));
        }
    }

    private void checkJournal() {
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("InitSaveUnitTest_BusBill_02");
        billNos.add("InitSaveUnitTest_BusBill_03");
        billNos.add("InitSaveUnitTest_BusBill_04");
        billNos.add("InitSaveUnitTest_FinBill_01");
        billNos.add("InitSaveUnitTest_PaidBill_01");
        this.checkJournalExistAndAmt(billNos);
    }

    private void checkJournalExistAndAmt(Set<String> billNos) {
        DynamicObject[] journalDatas = BusinessDataServiceHelper.load((String)"ap_journal", (String)"id,billno,estimatedamt,payableamt,prepaidamt", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos), new QFilter("org", "=", (Object)this.unInitOrg2Id)});
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)5, (int)journalDatas.length);
        block14: for (DynamicObject journalData : journalDatas) {
            String billNo;
            switch (billNo = journalData.getString("billno")) {
                case "InitSaveUnitTest_BusBill_02": {
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(journalData.getBigDecimal("estimatedamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("payableamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("prepaidamt")));
                    continue block14;
                }
                case "InitSaveUnitTest_BusBill_03": {
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(journalData.getBigDecimal("estimatedamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("payableamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("prepaidamt")));
                    continue block14;
                }
                case "InitSaveUnitTest_BusBill_04": {
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(journalData.getBigDecimal("estimatedamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("payableamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("prepaidamt")));
                    continue block14;
                }
                case "InitSaveUnitTest_FinBill_01": {
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("estimatedamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(journalData.getBigDecimal("payableamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("prepaidamt")));
                    continue block14;
                }
                case "InitSaveUnitTest_PaidBill_01": {
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("estimatedamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(journalData.getBigDecimal("payableamt")));
                    AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(journalData.getBigDecimal("prepaidamt")));
                }
            }
        }
    }

    private void checkCloseRecordExist(boolean param) {
        Date stopDate = DateUtils.getLastDay((Date)this.initData.getDate("startdate"), (int)1);
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)param, (boolean)QueryServiceHelper.exists((String)"ap_closerecord", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("closedate", "=", (Object)stopDate)}));
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)param, (boolean)QueryServiceHelper.exists((String)"ap_closerecord", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg3Id), new QFilter("closedate", "=", (Object)stopDate)}));
    }

    private void checkBalance(boolean isPeriod) {
        DynamicObject[] balanceDatas;
        for (DynamicObject balanceData : balanceDatas = BusinessDataServiceHelper.load((String)"ap_newbalance", (String)"asstacttype,asstact,currency,periodfinamt,localperiodfinamt,periodprepaidamt,localperiodprepaidamt,periodbusamt,localperiodbusamt,finamt,localfinamt,prepaidamt,localprepaidamt,busamt,localbusamt,finbalance,localfinbalance,prepaidbalance,localprepaidbalance,busbalance,localbusbalance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("startdate", isPeriod ? "=" : "!=", null)})) {
            BigDecimal curAmount;
            BigDecimal periodAmount;
            DynamicObject asstact = balanceData.getDynamicObject("asstact");
            DynamicObject currency = balanceData.getDynamicObject("currency");
            if (!asstact.getString("id").equals(BaseDataTestProvider.getSupplier().getString("id"))) {
                periodAmount = isPeriod ? BigDecimal.ZERO : BIGDECIMAL_50;
                curAmount = isPeriod ? BIGDECIMAL_50 : BigDecimal.ZERO;
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("periodfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localperiodfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("periodprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localperiodprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("periodbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("localperiodbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("finamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("prepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("busamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("localbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("finbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localfinbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("prepaidbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localprepaidbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(balanceData.getBigDecimal("busbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(balanceData.getBigDecimal("localbusbalance")));
            }
            if (currency.getString("id").equals(BaseDataTestProvider.getCurrencyUSD().getString("id"))) {
                periodAmount = isPeriod ? BigDecimal.ZERO : BIGDECIMAL_50;
                curAmount = isPeriod ? BIGDECIMAL_50 : BigDecimal.ZERO;
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("periodfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localperiodfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("periodprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localperiodprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("periodbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("localperiodbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("finamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localfinamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("prepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localprepaidamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("busamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("localbusamt")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("finbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localfinbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("prepaidbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BigDecimal.ZERO.compareTo(balanceData.getBigDecimal("localprepaidbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(balanceData.getBigDecimal("busbalance")));
                AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_50.compareTo(balanceData.getBigDecimal("localbusbalance")));
            }
            if (!asstact.getString("id").equals(BaseDataTestProvider.getSupplier().getString("id")) || !currency.getString("id").equals(BaseDataTestProvider.getCurrencyCNY().getString("id"))) continue;
            periodAmount = isPeriod ? BigDecimal.ZERO : BIGDECIMAL_100;
            curAmount = isPeriod ? BIGDECIMAL_100 : BigDecimal.ZERO;
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("periodfinamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("localperiodfinamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("periodprepaidamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("localperiodprepaidamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("periodbusamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)periodAmount.compareTo(balanceData.getBigDecimal("localperiodbusamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("finamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("localfinamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("prepaidamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("localprepaidamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("busamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)curAmount.compareTo(balanceData.getBigDecimal("localbusamt")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("finbalance")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("localfinbalance")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("prepaidbalance")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("localprepaidbalance")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("busbalance")));
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((int)0, (int)BIGDECIMAL_100.compareTo(balanceData.getBigDecimal("localbusbalance")));
        }
    }

    private void checkAntiCloseInitValidator() {
        DynamicObject[] initDatas = this.getInitDatas();
        initDatas[INDEX_ZREO].set("isfinishinit", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initDatas[INDEX_ZREO]});
        String result = this.invokeAntiCloseInitOp();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((String)result, (boolean)true, (result != null && result.contains(ResManager.loadKDString((String)"\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_6", (String)"fi-ap-opplugin", (Object[])new Object[0])) ? 1 : 0) != 0);
        this.getView().invokeOperation("submit");
        initDatas[INDEX_ZREO].set("curperiod", (Object)this.nextPeriod);
        initDatas[INDEX_ZREO].set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])initDatas);
        String result2 = this.invokeAntiCloseInitOp();
        initDatas[INDEX_ZREO].set("curperiod", (Object)this.curPeriod);
        initDatas[INDEX_ZREO].set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])initDatas);
    }

    private String clickAntiCloseInit() {
        String clickAntiCloseInitParam = "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"bar_anticlose\",\"\"],\"postData\":[{},[]]}]";
        this.getFormService().batchInvokeAction(this.getPageId(), clickAntiCloseInitParam);
        String clickConfirmButton = "[{\"key\":\"\",\"methodName\":\"afterConfirm\",\"args\":[\"adjExchCallBack\",6,\"\"],\"postData\":[{},[]]}]";
        return this.getFormService().batchInvokeAction(this.getPageId(), clickConfirmButton);
    }

    private String invokeAntiCloseInitOp() {
        OperationResult operationResult = this.getView().invokeOperation("anticloseinit");
        if (EmptyUtils.isEmpty((Object)operationResult) || operationResult.isSuccess()) {
            return null;
        }
        return ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
    }

    private void checkDeleteAdjExch() {
        this.checkAdjExchRecord(this.unInitOrg2Id, this.curPeriod.getLong("id"), false);
        this.checkAdjExchBill(this.unInitOrg2Id, this.curPeriod.getLong("id"), false);
    }

    private void insertAdjExchAndJournalBill(DynamicObject period) {
        DynamicObject adjExchBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_adjexchbill");
        adjExchBill.set("billno", (Object)"InitSaveUnitTest_BusBill_04");
        adjExchBill.set("billstatus", (Object)"C");
        adjExchBill.set("org", (Object)this.initData.getDynamicObject("org"));
        adjExchBill.set("sourcebilltype", (Object)"ap_busbill");
        adjExchBill.set("period", (Object)period);
        adjExchBill.set("isincludeentry", (Object)0);
        adjExchBill.set("currency", (Object)BaseDataTestProvider.getCurrencyUSD());
        adjExchBill.set("basecurrency", (Object)this.initData.getDynamicObject("standardcurrency"));
        adjExchBill.set("exratetable", (Object)this.initData.getDynamicObject("exratetable"));
        adjExchBill.set("balance", (Object)BIGDECIMAL_50);
        adjExchBill.set("curgainloss", (Object)BIGDECIMAL_50);
        adjExchBill.set("gainloss", (Object)BIGDECIMAL_50);
        adjExchBill.set("bizsystem", (Object)"AP");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjExchBill});
        DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)"ap_journal");
        journal.set("org", adjExchBill.get("org"));
        journal.set("currency", adjExchBill.get("currency"));
        journal.set("basecurrency", adjExchBill.get("basecurrency"));
        journal.set("biztype", (Object)"adjustExchange");
        journal.set("sourcebilltype", (Object)"ap_adjexchbill");
        journal.set("sourcebillid", (Object)adjExchBill.getLong("id"));
        journal.set("billno", adjExchBill.get("billno"));
        journal.set("localestimatedamt", (Object)adjExchBill.getBigDecimal("gainloss"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{journal});
    }

    private void deleteRelatedBill(boolean firstTime) {
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("InitSaveUnitTest_BusBill_02");
        billNos.add("InitSaveUnitTest_BusBill_03");
        billNos.add("InitSaveUnitTest_BusBill_04");
        this.deleteBill("ap_busbill", billNos);
        billNos.clear();
        billNos.add("InitSaveUnitTest_FinBill_01");
        this.deleteBill("ap_finapbill", billNos);
        billNos.clear();
        billNos.add("InitSaveUnitTest_PaidBill_01");
        this.deleteBill("ap_paidbill", billNos);
        DeleteServiceHelper.delete((String)"ap_adjexchbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("bizsystem", "=", (Object)"AP")});
        DeleteServiceHelper.delete((String)"ap_adjustexch", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("bizsystem", "=", (Object)"AP")});
        DeleteServiceHelper.delete((String)"ap_newbalance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id)});
        DeleteServiceHelper.delete((String)"ap_journal", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id)});
        if (firstTime) {
            DeleteServiceHelper.delete((String)"ap_init", (QFilter[])new QFilter[]{new QFilter("org", "in", Arrays.asList(this.unInitOrg2Id, this.unInitOrg3Id))});
        }
    }

    private void checkAdjExchBill(Long orgId, Long periodID, boolean param) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodID);
        QFilter bizFilter = new QFilter("bizsystem", "=", (Object)"AP");
        boolean adjExchExistKey = QueryServiceHelper.exists((String)"ap_adjexchbill", (QFilter[])new QFilter[]{orgFilter, periodFilter, bizFilter});
        if (param) {
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)adjExchExistKey);
        } else {
            AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)false, (boolean)adjExchExistKey);
        }
    }

    private void checkJournalExist(boolean isAdjExch) {
        HashSet<String> billNos = new HashSet<String>(8);
        billNos.add("InitSaveUnitTest_BusBill_02");
        billNos.add("InitSaveUnitTest_BusBill_03");
        billNos.add("InitSaveUnitTest_BusBill_04");
        billNos.add("InitSaveUnitTest_FinBill_01");
        billNos.add("InitSaveUnitTest_PaidBill_01");
        QFilter filter = new QFilter("billno", "in", billNos);
        if (isAdjExch) {
            filter.and(new QFilter("biztype", "=", (Object)"adjustExchange"));
        }
        boolean journalExistKey = QueryServiceHelper.exists((String)"ap_journal", (QFilter[])new QFilter[]{filter});
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)false, (boolean)journalExistKey);
    }

    private void checkBalanceExist(boolean isPeriod) {
        boolean balanceExistKey = QueryServiceHelper.exists((String)"ap_newbalance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("startdate", isPeriod ? "=" : "!=", null)});
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)false, (boolean)balanceExistKey);
    }

    private void updateDataForClosePeriod() {
        DynamicObject[] initDatas = this.getInitDatas();
        Date currentDate = initDatas[INDEX_ZREO].getDate("currentdate");
        Date dateAfterCloseAccount = DateUtils.getNextDay((Date)currentDate, (int)40);
        initDatas[INDEX_ZREO].set("currentdate", (Object)dateAfterCloseAccount);
        initDatas[INDEX_ONE].set("currentdate", (Object)dateAfterCloseAccount);
        SaveServiceHelper.save((DynamicObject[])initDatas);
        DynamicObject adjExchRecord = BusinessDataServiceHelper.loadSingle((String)"ap_adjustexch", (String)"isadjexch", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("period", "=", (Object)this.initData.getDynamicObject("startperiod").getLong("id")), new QFilter("bizsystem", "=", (Object)"AP")});
        adjExchRecord.set("isadjexch", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjExchRecord});
    }

    private void checkInitDataCurPeriod(Long periodId) {
        DynamicObject[] initDatas = this.getInitDatas();
        Long curPeriod1 = initDatas[INDEX_ZREO].getDynamicObject("curperiod").getLong("id");
        Long curPeriod2 = initDatas[INDEX_ONE].getDynamicObject("curperiod").getLong("id");
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)curPeriod1.equals(periodId));
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)curPeriod2.equals(periodId));
    }

    private void checkClosePeriodValidator() {
        DynamicObject adjExchRecord = BusinessDataServiceHelper.loadSingle((String)"ap_adjustexch", (String)"isadjexch", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id), new QFilter("period", "=", (Object)this.initData.getDynamicObject("startperiod").getLong("id")), new QFilter("bizsystem", "=", (Object)"AP")});
        adjExchRecord.set("isadjexch", (Object)1);
        DynamicObject initData = BusinessDataServiceHelper.loadSingle((String)"ap_init", (String)"startperiod,currentdate,curperiod,isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.unInitOrg2Id)});
        Date date = initData.getDate("currentdate");
        initData.set("currentdate", (Object)DateUtils.getNextDay((Date)date, (int)31));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjExchRecord});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
        initData.set("isfinishinit", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
        OperationResult operationResult = this.invokeClosePeriod();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)((OperateErrorInfo)operationResult.getAllErrorInfo().get(0)).getMessage().contains(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_8", (String)"fi-ap-opplugin", (Object[])new Object[0])));
        initData.set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
        initData.set("currentdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
        operationResult = this.invokeClosePeriod();
        AP006_001_InitSaveAndClosePeriodUnitTest.assertEquals((boolean)true, (boolean)((OperateErrorInfo)operationResult.getAllErrorInfo().get(0)).getMessage().contains(ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u5173\u8d26", (String)"AP006_001_InitSaveAndClosePeriodUnitTest_10", (String)"fi-ap-opplugin", (Object[])new Object[0])));
    }

    private OperationResult invokeClosePeriod() {
        OperateOption param = OperateOption.create();
        param.setVariableValue("reachperiod", this.nextPeriod.getString("id"));
        return this.getView().invokeOperation("closeperiod", param);
    }

    private void invokeAntiClosePeriod() {
        AntiClosePeriodOp op = new AntiClosePeriodOp();
        op.setOperationResult(new OperationResult());
        DynamicObject[] initDatas = this.getInitDatas();
        long periodId = this.curPeriod.getLong("id");
        initDatas[INDEX_ZREO].set("curperiod", (Object)periodId);
        initDatas[INDEX_ONE].set("curperiod", (Object)periodId);
        op.beginOperationTransaction(new BeginOperationTransactionArgs("anticloseperiod", initDatas));
    }

    private void restoreDatas() {
        DynamicObject[] initDatas = this.getInitDatas();
        Date date = initDatas[INDEX_ZREO].getDate("startdate");
        initDatas[INDEX_ZREO].set("currentdate", (Object)date);
        initDatas[INDEX_ONE].set("currentdate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])initDatas);
        this.invokeAntiCloseInitOp();
    }
}

