/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.enums.InvoiceAdjustFilterEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.InvoiceAdjustDiffVO;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class AdjustDiffValidator
extends AbstractValidator {
    private boolean isIgnoreSysParam = false;

    public void validate() {
        String operateKey = this.getOperateKey();
        Object[] dataEntities = this.getNeedProcessApData();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        DynamicObject[] entities = (DynamicObject[])Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        Map invoiceMap = InvoiceHelper.getInvoiceMap((ExtendedDataEntity[])dataEntities);
        InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
        List<InvoiceAdjustDiffVO> adjustDiffVOS = this.preAdjustDiff(adjustDiffService, entities);
        Map notAdjustApBillMap = adjustDiffService.preValidateFinApBills(entities, null);
        Set dataNotInRangeBillNos = (Set)notAdjustApBillMap.get(InvoiceAdjustFilterEnum.DATANOTINRANGE);
        Map<String, String> invoiceOccupyErrorMessageMap = this.getInvoiceOccupyErrorMessage(notAdjustApBillMap, entities);
        List orgIds = Arrays.stream(entities).map(finApBill -> finApBill.getLong("org.id")).distinct().collect(Collectors.toList());
        Map appParameters = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, orgIds, (String[])new String[]{"ap_021", "ap_016"});
        Map adjustDiffVOMap = adjustDiffVOS.stream().collect(Collectors.toMap(InvoiceAdjustDiffVO::getBillId, Function.identity()));
        for (Object dataEntity : dataEntities) {
            DynamicObject detailRow;
            DynamicObject finApBill2 = dataEntity.getDataEntity();
            String billNo = finApBill2.getString("billno");
            long orgId = finApBill2.getLong("org.id");
            Map appParameterMap = (Map)appParameters.get(orgId);
            if (ObjectUtils.isEmpty((Object)appParameterMap)) continue;
            InvoiceAdjustDiffVO adjustDiffVO = (InvoiceAdjustDiffVO)adjustDiffVOMap.get(finApBill2.getLong("id"));
            BigDecimal newHeadPriceTax = finApBill2.getBigDecimal("pricetaxtotal");
            BigDecimal newHeadAmount = finApBill2.getBigDecimal("amount");
            BigDecimal newHeadTax = finApBill2.getBigDecimal("tax");
            if (adjustDiffVO != null) {
                newHeadPriceTax = finApBill2.getBigDecimal("pricetaxtotal").add(adjustDiffVO.getNewPriceTax().subtract(adjustDiffVO.getOldPriceTax()));
                newHeadAmount = finApBill2.getBigDecimal("amount").add(adjustDiffVO.getNewAmount().subtract(adjustDiffVO.getOldAmount()));
                newHeadTax = finApBill2.getBigDecimal("tax").add(adjustDiffVO.getNewTax().subtract(adjustDiffVO.getOldTax()));
            }
            String operateName = this.getOperateName();
            if (!ObjectUtils.isEmpty((Object)dataNotInRangeBillNos) && operateName != null && dataNotInRangeBillNos.contains(billNo)) {
                this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u3002\u5e94\u4ed8\u4e0e\u53d1\u7968\u7684\u91d1\u989d\u3001\u7a0e\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u5dee\u989d\u5df2\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u5e94\u4ed8\u65e0\u6cd5\u6309\u53d1\u7968\u81ea\u52a8\u8c03\u6574\u3002", (String)"AdjustDiffValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), operateName));
                continue;
            }
            if (invoiceOccupyErrorMessageMap.get(billNo) != null) {
                this.addMessage((ExtendedDataEntity)dataEntity, invoiceOccupyErrorMessageMap.get(billNo));
                continue;
            }
            Object ap021 = appParameterMap.get("ap_021");
            if (ap021 != null && ((Boolean)ap021).booleanValue() && "submit".equals(operateKey)) {
                DynamicObjectCollection invEntry = finApBill2.getDynamicObjectCollection("inventry");
                ArrayList<DynamicObject> invEntryList = new ArrayList<DynamicObject>(8);
                for (DynamicObject invRow : invEntry) {
                    DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                    if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                    invEntryList.add(invRow);
                }
                if (!invEntryList.isEmpty()) {
                    BigDecimal invPriceTaxTotal = BigDecimal.ZERO;
                    BigDecimal invTaxToTal = BigDecimal.ZERO;
                    BigDecimal invAmountTotal = BigDecimal.ZERO;
                    for (DynamicObject invRow : invEntryList) {
                        DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                        if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                        invPriceTaxTotal = invPriceTaxTotal.add(invRow.getBigDecimal("i_pricetaxtotal"));
                        invTaxToTal = invTaxToTal.add(invRow.getBigDecimal("i_tax"));
                        invAmountTotal = invAmountTotal.add(invRow.getBigDecimal("i_amount"));
                    }
                    if (newHeadPriceTax.compareTo(invPriceTaxTotal) != 0 || newHeadTax.compareTo(invTaxToTal) != 0 || newHeadAmount.compareTo(invAmountTotal) != 0) {
                        this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u672c\u5355\u4e0e\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\u5b58\u5728\u4e0d\u76f8\u7b49\u9879\u6216\u53d1\u7968\u5df2\u88ab\u5176\u4ed6\u7684\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AdjustDiffValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            }
            if (adjustDiffVO == null) continue;
            if (finApBill2.getBigDecimal("settleamount").signum() != 0) {
                if ("deleteinventry".equals(operateKey)) {
                    this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5df2\u6839\u636e\u53d1\u7968\u8c03\u5dee\u4e14\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u53d1\u7968\u3002\u82e5\u53d1\u7968\u9519\u8bef\uff0c\u8bf7\u5148\u53cd\u7ed3\u7b97\u518d\u64cd\u4f5c\uff0c\u6216\u8bf7\u64a4\u9500\u5355\u636e\u3002", (String)"AdjustDiffValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if ("antiassign".equals(operateKey)) {
                    this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5df2\u6839\u636e\u53d1\u7968\u8c03\u5dee\u4e14\u5df2\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6307\u5b9a\u53d1\u7968\u3002\u82e5\u53d1\u7968\u9519\u8bef\uff0c\u8bf7\u5148\u53cd\u7ed3\u7b97\u518d\u64cd\u4f5c\uff0c\u6216\u8bf7\u64a4\u9500\u5355\u636e\u3002", (String)"AdjustDiffValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if ((detailRow = adjustDiffVO.getDetailRow()) != null) {
                BigDecimal newEAmount = adjustDiffVO.getNewAmount();
                BigDecimal newETax = adjustDiffVO.getNewTax();
                BigDecimal newEPriceTax = adjustDiffVO.getNewPriceTax();
                if (newEAmount.add(newETax).compareTo(newEPriceTax) != 0) {
                    this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968\u8c03\u6574\u5e94\u4ed8\u5931\u8d25\uff0c\u8c03\u6574\u540e\u7b2c%s\u884c\u91d1\u989d+\u7a0e\u989d\u5c06\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002\u8bf7\u68c0\u67e5\u5e94\u4ed8\u5355\u4e0e\u5bf9\u5e94\u6536\u7968\u5355\u7684\u6570\u636e\u662f\u5426\u6ee1\u8db3\u4ee5\u4e0a\u6052\u7b49\u5f0f\u3002\u8bf7\u6309\u6052\u7b49\u5f0f\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjustDiffValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), detailRow.get("seq")));
                    continue;
                }
                BigDecimal quantity = detailRow.getBigDecimal("quantity");
                if (newETax.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || newEAmount.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || newEPriceTax.multiply(quantity).compareTo(BigDecimal.ZERO) < 0) {
                    this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968\u8c03\u6574\u5e94\u4ed8\u5931\u8d25\uff0c\u8c03\u6574\u540e\u7b2c%s\u884c\u6570\u91cf\u3001\u7a0e\u989d\u3001\u91d1\u989d\u3001\u5e94\u4ed8\u91d1\u989d\u7684\u65b9\u5411\u5c06\u4e0d\u4e00\u81f4\u3002\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustDiffValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), detailRow.get("seq")));
                    continue;
                }
            }
            Object submitSettle = appParameterMap.get("ap_016");
            DynamicObjectCollection preEntrys = finApBill2.getDynamicObjectCollection("preentry");
            List noZeroPreEntry = preEntrys.stream().filter(p -> p.getBigDecimal("y_settleamt").signum() != 0).collect(Collectors.toList());
            if (noZeroPreEntry.isEmpty() || (submitSettle == null || !((Boolean)submitSettle).booleanValue() || !"submit".equals(operateKey)) && !"invdiffadjust".equals(operateKey)) continue;
            BigDecimal settleAmtSum = BigDecimal.ZERO;
            for (DynamicObject preEntry : noZeroPreEntry) {
                settleAmtSum = settleAmtSum.add(preEntry.getBigDecimal("y_settleamt"));
            }
            BigDecimal premiumRate = finApBill2.getBigDecimal("premiumrate");
            if (premiumRate.signum() != 0) {
                BigDecimal newPremiumAmt = newHeadPriceTax.multiply(premiumRate.divide(new BigDecimal(100)));
                if (settleAmtSum.abs().compareTo(newHeadPriceTax.subtract(newPremiumAmt).abs()) > 0) {
                    this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5c06\u6839\u636e\u53d1\u7968\u8c03\u5dee\uff0c\u8c03\u5dee\u540e\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff08\u5e94\u4ed8\u91d1\u989d\u51cf\u53bb\u8d28\u4fdd\u91d1\u91d1\u989d\uff09\u5c06\u5c0f\u4e8e\u9884\u4ed8\u884c\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"AdjustDiffValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (newHeadPriceTax.abs().compareTo(settleAmtSum.abs()) >= 0) continue;
            this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5c06\u6839\u636e\u53d1\u7968\u8c03\u5dee\uff0c\u8c03\u5dee\u540e\u7684\u53ef\u7ed3\u7b97\u91d1\u989d\uff08\u5e94\u4ed8\u91d1\u989d\uff09\u5c06\u5c0f\u4e8e\u9884\u4ed8\u884c\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"AdjustDiffValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private List<InvoiceAdjustDiffVO> preAdjustDiff(InvoiceAdjustDiffService adjustDiffService, DynamicObject[] entities) {
        Map variableMap = this.getOption().getVariables();
        String invPks = (String)variableMap.get("invPks");
        String operateKey = this.getOperateKey();
        Set srcTypeEnums = Arrays.stream(InvoiceSrcTypeEnum.values()).map(InvoiceSrcTypeEnum::getValue).collect(Collectors.toSet());
        InvoiceAdjustParam invoiceAdjustParam = null;
        if ("submit".equals(operateKey) || "assignsave".equals(operateKey) || "invdiffadjust".equals(operateKey)) {
            invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ADJUST);
        } else if ("assign".equals(operateKey)) {
            if (entities.length > 1) {
                return new ArrayList<InvoiceAdjustDiffVO>(2);
            }
            invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ADJUST);
            if (!ObjectUtils.isEmpty((Object)invPks)) {
                List invPkList = (List)JSONObject.parseObject((String)invPks, List.class);
                DynamicObject finApBill = entities[0];
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (!srcTypeEnums.contains(invRow.getString("i_srctype"))) continue;
                    invPkList.add(invRow.getLong("invid"));
                }
                QFilter filter = new QFilter("id", "in", (Object)invPkList);
                filter.and("invoicestatus", "!=", (Object)"2");
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"pricetaxtotal,amount,tax", (QFilter[])new QFilter[]{filter});
                invoiceAdjustParam.setInvoices(invoices);
            }
        } else {
            if ("antiassign".equals(operateKey)) {
                invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ROLLBACKTHENADJUST);
                invoiceAdjustParam.setOperateKey(operateKey);
                ArrayList<InvoiceAdjustDiffVO> result = new ArrayList<InvoiceAdjustDiffVO>(8);
                ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
                for (DynamicObject finApBill : entities) {
                    DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                    for (DynamicObject invRow : invEntry) {
                        if (!srcTypeEnums.contains(invRow.getString("i_srctype")) || InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                        invoiceIds.add(invRow.getLong("invid"));
                    }
                }
                Map<Object, Object> invoiceMap = new HashMap(8);
                if (!invoiceIds.isEmpty()) {
                    QFilter filter = new QFilter("id", "in", invoiceIds);
                    filter.and("invoicestatus", "!=", (Object)"2");
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"pricetaxtotal,amount,tax", (QFilter[])new QFilter[]{filter});
                    invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
                }
                for (DynamicObject finApBill : entities) {
                    ArrayList<DynamicObject> needAdjustInvoices = new ArrayList<DynamicObject>(8);
                    DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                    for (DynamicObject invRow : invEntry) {
                        DynamicObject invoice;
                        if (!srcTypeEnums.contains(invRow.getString("i_srctype")) || InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invRow.getString("i_srctype")) || (invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"))) == null) continue;
                        needAdjustInvoices.add(invoice);
                    }
                    invoiceAdjustParam.setInvoices(needAdjustInvoices.toArray(new DynamicObject[0]));
                    result.addAll(adjustDiffService.preAdjustDiff(new DynamicObject[]{finApBill}, invoiceAdjustParam));
                }
                return result;
            }
            if ("deleteinventry".equals(operateKey)) {
                long invPk = Long.parseLong((String)variableMap.get("invPk"));
                DynamicObjectCollection invEntry = entities[0].getDynamicObjectCollection("inventry");
                HashSet<Long> otherInvIds = new HashSet<Long>(64);
                for (DynamicObject invRow : invEntry) {
                    if (!srcTypeEnums.contains(invRow.getString("i_srctype"))) continue;
                    otherInvIds.add(invRow.getLong("invid"));
                }
                otherInvIds.remove(invPk);
                if (otherInvIds.isEmpty()) {
                    invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ROLLBACK);
                } else {
                    invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ROLLBACKTHENADJUST);
                    QFilter filter = new QFilter("id", "in", otherInvIds);
                    filter.and("invoicestatus", "!=", (Object)"2");
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"pricetaxtotal,amount,tax", (QFilter[])new QFilter[]{filter});
                    invoiceAdjustParam.setInvoices(invoices);
                }
                if ("A".equals(entities[0].getString("billstatus"))) {
                    entities = new DynamicObject[]{};
                }
            }
        }
        if (adjustDiffService == null || invoiceAdjustParam == null) {
            return new ArrayList<InvoiceAdjustDiffVO>(2);
        }
        invoiceAdjustParam.setIgnoreSysParam(this.isIgnoreSysParam);
        invoiceAdjustParam.setOperateKey(operateKey);
        return adjustDiffService.preAdjustDiff(entities, invoiceAdjustParam);
    }

    private ExtendedDataEntity[] getNeedProcessApData() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            return new ExtendedDataEntity[0];
        }
        ArrayList<ExtendedDataEntity> needValidateApDatas = new ArrayList<ExtendedDataEntity>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            if (!"assign".equals(operateKey) && invEntry.isEmpty()) continue;
            needValidateApDatas.add(dataEntity);
        }
        return needValidateApDatas.toArray(new ExtendedDataEntity[0]);
    }

    private String getOperateName() {
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey)) {
            return ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"AdjustDiffValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        if ("assign".equals(operateKey)) {
            return ResManager.loadKDString((String)"\u6307\u5b9a\u53d1\u7968", (String)"AdjustDiffValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        if ("assignsave".equals(operateKey)) {
            return ResManager.loadKDString((String)"\u53d1\u7968\u5bfc\u5165\u5355\u636e", (String)"AdjustDiffValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private Map<String, String> getInvoiceOccupyErrorMessage(Map<InvoiceAdjustFilterEnum, Set<String>> notAdjustApBillMap, DynamicObject[] entities) {
        String operateKey = this.getOperateKey();
        Map variableMap = this.getOption().getVariables();
        String invPks = (String)variableMap.get("invPks");
        HashMap<String, String> invoiceOccupyErrorMessageMap = new HashMap<String, String>(8);
        Set<String> otherApOccupyBillNos = notAdjustApBillMap.get(InvoiceAdjustFilterEnum.OTHERBILLOCCUPY);
        String operateName = this.getOperateName();
        if (ObjectUtils.isEmpty(otherApOccupyBillNos) || operateName == null) {
            return invoiceOccupyErrorMessageMap;
        }
        if (ObjectUtils.isEmpty((Object[])(entities = (DynamicObject[])Arrays.stream(entities).filter(bill -> otherApOccupyBillNos.contains(bill.getString("billno"))).toArray(DynamicObject[]::new)))) {
            return new HashMap<String, String>(8);
        }
        HashSet assignInvoiceIds = new HashSet(8);
        if ("assign".equals(operateKey) && !ObjectUtils.isEmpty((Object)invPks)) {
            assignInvoiceIds.addAll((Collection)JSONObject.parseObject((String)invPks, List.class));
        }
        Map moreOccupyFinMap = InvoiceHelper.getInvoiceOtherOccupyMap((DynamicObject[])entities, assignInvoiceIds);
        if ("submit".equals(operateKey) || "assignsave".equals(operateKey)) {
            for (DynamicObject finApBill : entities) {
                String invNosStr;
                Set allInvoiceBillNos = (Set)moreOccupyFinMap.get(finApBill.getString("billno"));
                if (allInvoiceBillNos == null || allInvoiceBillNos.size() < 1) continue;
                if (allInvoiceBillNos.size() <= 3) {
                    invNosStr = String.join((CharSequence)" ,", allInvoiceBillNos);
                } else {
                    List tempInvNos = new ArrayList(allInvoiceBillNos).subList(0, 3);
                    invNosStr = String.join((CharSequence)" ,", tempInvNos) + "......";
                }
                invoiceOccupyErrorMessageMap.put(finApBill.getString("billno"), String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u3002\u6536\u7968\u5355%2$s\u540c\u65f6\u88ab\u591a\u5f20\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u5e94\u4ed8\u65e0\u6cd5\u6309\u53d1\u7968\u81ea\u52a8\u8c03\u6574\u3002", (String)"AdjustDiffValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]), operateName, invNosStr));
            }
        } else if ("assign".equals(operateKey) && !ObjectUtils.isEmpty((Object)invPks)) {
            String invNosStr;
            Set allInvoiceBillNos = (Set)moreOccupyFinMap.get(entities[0].getString("billno"));
            if (allInvoiceBillNos == null || allInvoiceBillNos.size() < 1) {
                return invoiceOccupyErrorMessageMap;
            }
            if (allInvoiceBillNos.size() <= 3) {
                invNosStr = String.join((CharSequence)",", allInvoiceBillNos);
            } else {
                List tempInvNos = new ArrayList(allInvoiceBillNos).subList(0, 3);
                invNosStr = String.join((CharSequence)",", tempInvNos) + "......";
            }
            invoiceOccupyErrorMessageMap.put(entities[0].getString("billno"), String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u3002\u6536\u7968\u5355%2$s\u540c\u65f6\u88ab\u591a\u5f20\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u5e94\u4ed8\u65e0\u6cd5\u6309\u53d1\u7968\u81ea\u52a8\u8c03\u6574\u3002", (String)"AdjustDiffValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]), operateName, invNosStr));
        }
        return invoiceOccupyErrorMessageMap;
    }

    public void setIgnoreSysParam(boolean ignoreSysParam) {
        this.isIgnoreSysParam = ignoreSysParam;
    }
}

