/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.helper.InitHelper;

public class AntiCloseAccountValidator
extends AbstractValidator {
    private Date antiCloseDate;

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            Date startDate;
            DynamicObject closeAccountsInfo = data.getDataEntity();
            DynamicObject org = closeAccountsInfo.getDynamicObject("org");
            boolean isFinishInit = closeAccountsInfo.getBoolean("isfinishinit");
            if (!isFinishInit) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5173\u8d26\u64cd\u4f5c\u3002", (String)"AntiCloseAccountValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
            }
            if (this.antiCloseDate.compareTo(DateUtils.getLastDay((Date)(startDate = closeAccountsInfo.getDate("startdate")), (int)1)) < 0) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\uff1a\u53cd\u5173\u8d26\u5230\u7684\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u7ec4\u7ec7\u542f\u7528\u65e5\u671f\u7684\u524d\u4e00\u5929\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"AntiCloseAccountValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
                continue;
            }
            Date currentDate = closeAccountsInfo.getDate("currentdate");
            if (this.antiCloseDate.compareTo(currentDate) >= 0) {
                String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\uff1a\u53cd\u5173\u8d26\u5230\u7684\u65e5\u671f\u5e94\u8be5\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"AntiCloseAccountValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getString("name"));
                this.addErrorMessage(data, message);
                continue;
            }
            InitHelper helper = new InitHelper(((Long)org.getPkValue()).longValue(), "ap_init");
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)helper.getCurperiodId(), (String)"bd_period");
            if (DateUtils.getNextDay((Date)this.antiCloseDate, (int)1).compareTo(currPeriod.getDate("begindate")) >= 0) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\uff1a\u5df2\u7ed3\u8d26,\u53cd\u5173\u8d26\u5230\u7684\u65e5\u671f\u5e94\u8be5\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"AntiCloseAccountValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getString("name"));
            this.addErrorMessage(data, message);
        }
    }

    public Date getAntiCloseDate() {
        return this.antiCloseDate;
    }

    public void setAntiCloseDate(Date antiCloseDate) {
        this.antiCloseDate = antiCloseDate;
    }
}

