/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApBusAuditValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> revalBusIds = new ArrayList<Long>(2);
        ArrayList<Long> srcBusIds = new ArrayList<Long>(2);
        ArrayList<Long> revalBusEnIds = new ArrayList<Long>(2);
        HashSet<Long> revalOrgIds = new HashSet<Long>(2);
        DynamicObject[] apBusbills = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).toArray(new DynamicObject[this.dataEntities.length]);
        BookDateHelper.setBookDate((DynamicObject[])apBusbills, (boolean)false);
        for (DynamicObject busBill : apBusbills) {
            boolean isReval = busBill.getBoolean("isrevaluation");
            boolean isAdjust = busBill.getBoolean("isadjust");
            if (!isReval || isAdjust) continue;
            revalOrgIds.add(busBill.getLong("org.id"));
            revalBusIds.add(busBill.getLong("id"));
            srcBusIds.add(busBill.getLong("revaluasrcbusbillid"));
            DynamicObjectCollection entry = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                revalBusEnIds.add(row.getLong("id"));
            }
        }
        Map calAccountMap = new HashMap(1);
        if (revalOrgIds.size() > 0) {
            calAccountMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getAcctPeriodStartDate", (Object[])new Object[]{revalOrgIds});
        }
        DynamicObjectCollection srcBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,entry.id,bookdate,entry.e_unwoffqty,entry.seq", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIds), new QFilter("entry.e_unwoffqty", "!=", (Object)BigDecimal.ZERO)});
        List<Long> srcBusEnIds = srcBusBills.stream().map(v -> v.getLong("entry.id")).collect(Collectors.toList());
        Map<Long, Date> srcBusBookDates = srcBusBills.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getDate("bookdate"), (value1, value2) -> value2));
        Map<Long, DynamicObject> srcBusEntryMap = srcBusBills.stream().collect(Collectors.toMap(v -> v.getLong("entry.id"), v -> v));
        Map revalToPurMap = BOTPHelper.loadSourceRowIdsMap((String)"ap_busbill", (String)"entry", (Long[])revalBusIds.toArray(new Long[0]), (Long[])revalBusEnIds.toArray(new Long[0]), (String)"im_purinbill");
        Map srcBusToPurMap = BOTPHelper.loadSourceRowIdsMap((String)"ap_busbill", (String)"entry", (Long[])srcBusIds.toArray(new Long[0]), (Long[])srcBusEnIds.toArray(new Long[0]), (String)"im_purinbill");
        HashMap purToSrcBusMap = new HashMap(srcBusToPurMap.size());
        for (Map.Entry entrySet : srcBusToPurMap.entrySet()) {
            purToSrcBusMap.put(entrySet.getValue(), entrySet.getKey());
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject busBill = dataEntity.getDataEntity();
            if (!revalBusIds.contains(busBill.getLong("id"))) continue;
            String revalBillNo = busBill.getString("billno");
            String srcBillNo = busBill.getString("revaluasrcbusbillno");
            Long revalSrcId = busBill.getLong("revaluasrcbusbillid");
            Date srcBookDate = srcBusBookDates.get(revalSrcId);
            Long orgId = busBill.getLong("org.id");
            Object[] calAccountInfo = (Object[])calAccountMap.get(orgId);
            Date bookDate = busBill.getDate("bookdate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (EmptyUtils.isEmpty((Object)calAccountInfo)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u5b58\u8d27\u6838\u7b97\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u5ba1\u6838\u3002", (String)"ApBusAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo));
                continue;
            }
            Date calDate = (Date)calAccountInfo[0];
            if (EmptyUtils.isEmpty((Object)calDate)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u5b58\u8d27\u6838\u7b97\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u8bf7\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u5ba1\u6838\u3002", (String)"ApBusAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo));
                continue;
            }
            if (bookDate.before(calDate)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u8bb0\u8d26\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u5b58\u8d27\u6838\u7b97\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5ba1\u6838\u3002", (String)"ApBusAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo, sdf.format(calDate)));
                continue;
            }
            if (bookDate.before(srcBookDate)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u8bb0\u8d26\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u6e90\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u8bb0\u8d26\u65e5\u671f%2$s\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5ba1\u6838\u3002", (String)"ApBusAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo, sdf.format(srcBookDate)));
                continue;
            }
            DynamicObjectCollection entry = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long entryId = row.getLong("id");
                Long purENtryId = (Long)revalToPurMap.get(entryId);
                if (purENtryId == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u4e0e\u6682\u4f30\u5355%2$s\u672a\u51b2\u56de\u7684\u660e\u7ec6\u884c\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u91cd\u4f30\u3002", (String)"ApBusAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo, srcBillNo));
                    continue;
                }
                Long srcBusEntryId = (Long)purToSrcBusMap.get(purENtryId);
                if (srcBusEntryId == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u4e0e\u6682\u4f30\u5355%2$s\u672a\u51b2\u56de\u7684\u660e\u7ec6\u884c\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u91cd\u4f30\u3002", (String)"ApBusAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo, srcBillNo));
                    continue;
                }
                DynamicObject srcEntry = srcBusEntryMap.get(srcBusEntryId);
                BigDecimal revalQty = row.getBigDecimal("e_quantity");
                int revalSeq = row.getInt("seq");
                BigDecimal srcQty = srcEntry.getBigDecimal("entry.e_unwoffqty");
                int srcSeq = srcEntry.getInt("entry.seq");
                if (revalQty.compareTo(srcQty) == 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7b2c%2$s\u884c\u6570\u91cf\u4e0d\u7b49\u4e8e\u6682\u4f30\u5e94\u4ed8\u5355%3$s\u7b2c%4$s\u884c\u7684\u672a\u51b2\u56de\u6570\u91cf\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u91cd\u4f30\u3002", (String)"ApBusAuditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), revalBillNo, revalSeq, srcBillNo, srcSeq));
            }
        }
    }
}

