/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class ApRevalBusBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, String> revalBillMap = this.getRevalBillMap();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String upBillNo;
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isAdjust = bill.getBoolean("isadjust");
            Long srcFinBillId = bill.getLong("srcfinbillid");
            boolean isReval = bill.getBoolean("isrevaluation");
            boolean isVerify = bill.getBoolean("isverifybusiness");
            boolean hadReval = bill.getBoolean("hadrevaluation");
            String billNo = bill.getString("billno");
            if (hadReval) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5df2\u91cd\u4f30\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ApRevalBusBillUnAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (isReval && !isAdjust) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u91cd\u4f30\u6682\u4f30\u5e94\u4ed8\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u82e5\u9700\u4fee\u6539\u8bf7\u91cd\u65b0\u91cd\u4f30\u3002", (String)"ApRevalBusBillUnAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (isAdjust && srcFinBillId != 0L && !isVerify) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5355\u5230\u51b2\u56de\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"ApRevalBusBillUnAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (isAdjust && srcFinBillId == 0L && isReval && !isVerify) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u91cd\u4f30\u4e1a\u52a1\u7684\u51b2\u56de\u5355\u4e0d\u5141\u8bb8\u624b\u5de5\u53cd\u5ba1\u6838\u3002", (String)"ApRevalBusBillUnAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
                continue;
            }
            if (!isAdjust || srcFinBillId != 0L || isReval || isVerify || (upBillNo = revalBillMap.get(bill.getLong("id"))) == null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadResFormat((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u4e0a\u6e38\u6682\u4f30\u5355%2$s\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ApRevalBusBillUnAuditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, upBillNo));
        }
    }

    private Map<Long, String> getRevalBillMap() {
        HashMap<Long, String> srcRevalMap = new HashMap<Long, String>(2);
        ArrayList<Long> busBillIds = new ArrayList<Long>(2);
        HashSet<Long> busBillEntryIds = new HashSet<Long>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            boolean isAdjust = dynamicObject.getBoolean("isadjust");
            Long srcFinBillId = dynamicObject.getLong("srcfinbillid");
            boolean isReval = dynamicObject.getBoolean("isrevaluation");
            boolean isVerify = dynamicObject.getBoolean("isverifybusiness");
            if (!isAdjust || srcFinBillId != 0L || isReval || isVerify) continue;
            busBillIds.add(dynamicObject.getLong("id"));
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                busBillEntryIds.add(entry.getLong("id"));
            }
        }
        Map upBusBillIds = BOTPHelper.loadNearUpBillIds((String)"ap_busbill", (String)"entry", (Long[])busBillIds.toArray(new Long[0]), (Long[])busBillEntryIds.toArray(new Long[0]), (String)"ap_busbill");
        if (upBusBillIds.size() == 0) {
            return srcRevalMap;
        }
        HashSet<Long> allUpBillId = new HashSet<Long>(upBusBillIds.size());
        HashMap upBusBillIdMap = new HashMap(2);
        for (Map.Entry entry : upBusBillIds.entrySet()) {
            for (Long billId : (List)entry.getValue()) {
                upBusBillIdMap.put(billId, entry.getKey());
                allUpBillId.add(billId);
            }
        }
        DynamicObjectCollection revalBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", allUpBillId), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)});
        for (DynamicObject bill : revalBusBills) {
            Long billId;
            billId = bill.getLong("id");
            Long woffBillid = (Long)upBusBillIdMap.get(billId);
            if (woffBillid == null) continue;
            srcRevalMap.put(woffBillid, bill.getString("billno"));
        }
        return srcRevalMap;
    }
}

