/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPNewHelper;

public class ApWoffBillUnauditValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("isadjust");
        fields.add("writeoffbusiness");
        fields.add("isverifybusiness");
        fields.add("isselfwoff");
        fields.add("payproperty");
        fields.add("org");
        fields.add("billno");
        fields.add("entry.e_srcentryid");
        return fields;
    }

    public void validate() {
        DynamicObject bill;
        String operateKey = this.getOperateKey();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> srcBusEntryIds = new HashSet<Long>(16);
        HashSet<Long> indirectBusEntryIds = new HashSet<Long>(16);
        HashMap<Long, String> currentBills = new HashMap<Long, String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long srcEntryId;
            DynamicObject bill2 = dataEntity.getDataEntity();
            boolean isAdjust = bill2.getBoolean("isadjust");
            boolean writeoffbusiness = bill2.getBoolean("writeoffbusiness");
            boolean isVerifyBusiness = bill2.getBoolean("isverifybusiness");
            boolean isselfwoff = bill2.getBoolean("isselfwoff");
            boolean isBasedOnAmt = bill2.getBoolean("payproperty.isbasedonamt");
            if (!isAdjust || isVerifyBusiness || !isselfwoff || isBasedOnAmt) continue;
            orgIds.add(bill2.getLong("org.id"));
            DynamicObjectCollection entrys = bill2.getDynamicObjectCollection("entry");
            if ("unaudit".equals(operateKey) && !writeoffbusiness) {
                currentBills.put(bill2.getLong("id"), bill2.getString("billno"));
                for (DynamicObject entry : entrys) {
                    srcEntryId = entry.getLong("e_srcentryid");
                    if (srcEntryId == 0L) continue;
                    srcBusEntryIds.add(srcEntryId);
                }
            }
            if (!"save".equals(operateKey) || !writeoffbusiness) continue;
            currentBills.put(bill2.getLong("id"), bill2.getString("billno"));
            for (DynamicObject entry : entrys) {
                srcEntryId = entry.getLong("e_srcentryid");
                if (srcEntryId == 0L) continue;
                indirectBusEntryIds.add(srcEntryId);
            }
        }
        if (srcBusEntryIds.size() == 0 && indirectBusEntryIds.size() == 0) {
            return;
        }
        if (indirectBusEntryIds.size() > 0) {
            DataSet indirectBusBills = QueryServiceHelper.queryDataSet((String)"woffunaudit", (String)"ap_busbill", (String)"id,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds), new QFilter("entry.id", "in", indirectBusEntryIds)}, null);
            for (Row row : indirectBusBills) {
                Long srcBusEntryId = row.getLong("entry.e_srcentryid");
                if (srcBusEntryId == 0L) continue;
                srcBusEntryIds.add(srcBusEntryId);
            }
        }
        QFilter filter = new QFilter("org.id", "in", orgIds);
        filter.and(new QFilter("entry.id", "in", srcBusEntryIds));
        filter.and(new QFilter("sourcebilltype", "in", this.getPurType()));
        DataSet srcBusBills = QueryServiceHelper.queryDataSet((String)"woffunaudit", (String)"ap_busbill", (String)"id,entry.e_srcbillid,entry.e_srcentryid,sourcebilltype", (QFilter[])new QFilter[]{filter}, null);
        HashMap<String, HashSet<Long>> purType2EntryIds = new HashMap<String, HashSet<Long>>(16);
        HashMap<Long, String> purEntryId2Billtypes = new HashMap<Long, String>(16);
        HashSet<Long> purBillIds = new HashSet<Long>(16);
        for (Row row : srcBusBills) {
            Long purEntryId = row.getLong("entry.e_srcentryid");
            if (purEntryId == 0L) continue;
            Long purBillId = row.getLong("entry.e_srcbillid");
            purBillIds.add(purBillId);
            String sourceBillType = row.getString("sourcebilltype");
            purEntryId2Billtypes.put(purEntryId, sourceBillType);
            HashSet<Long> purEntryIds = (HashSet<Long>)purType2EntryIds.get(sourceBillType);
            if (purEntryIds == null) {
                purEntryIds = new HashSet<Long>(16);
                purEntryIds.add(purEntryId);
                purType2EntryIds.put(sourceBillType, purEntryIds);
                continue;
            }
            purEntryIds.add(purEntryId);
        }
        HashMap<Long, BigDecimal> purEntryQtys = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> purEntryId2sumQtys = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Long> busEntryId2PurEntryIds = new HashMap<Long, Long>(16);
        HashSet<Long> allBusEntryIds = new HashSet<Long>(16);
        for (Map.Entry purEntry : purType2EntryIds.entrySet()) {
            Object row2;
            String purType = (String)purEntry.getKey();
            Set purEntryIds = (Set)purEntry.getValue();
            QFilter purFilter = new QFilter("id", "in", purBillIds);
            purFilter.and(new QFilter("billentry.id", "in", (Object)purEntryIds));
            if (this.getPurFilter() != null) {
                purFilter.and(this.getPurFilter());
            }
            DataSet purBills = QueryServiceHelper.queryDataSet((String)"woffunaudit", (String)purType, (String)this.getSrcSelector(purType), (QFilter[])new QFilter[]{purFilter}, null);
            for (Object row2 : purBills) {
                Long entryId = row2.getLong("billentry.id");
                purEntryQtys.put(entryId, row2.getBigDecimal("qty"));
            }
            Map allDownBillEntryIds = BOTPNewHelper.loadAllTargetRowIds((String)purType, (String)"billentry", (Long[])purBillIds.toArray(new Long[0]), (Long[])purEntryIds.toArray(new Long[0]));
            row2 = allDownBillEntryIds.entrySet().iterator();
            while (row2.hasNext()) {
                Map.Entry entrySet = (Map.Entry)row2.next();
                Long purEntryId = (Long)entrySet.getKey();
                Map targetBillIds = (Map)entrySet.getValue();
                List busEntryIds = (List)targetBillIds.get("ap_busbill");
                if (busEntryIds == null || busEntryIds.size() == 0) continue;
                for (Long entryId : busEntryIds) {
                    allBusEntryIds.add(entryId);
                    busEntryId2PurEntryIds.put(entryId, purEntryId);
                }
            }
        }
        DataSet allBusBills = QueryServiceHelper.queryDataSet((String)"woffunaudit", (String)"ap_busbill", (String)"id,entry.id,entry.e_baseunitqty", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("entry.id", "in", allBusEntryIds), new QFilter("isrevaluation", "=", (Object)Boolean.FALSE)}, null);
        for (Row row : allBusBills) {
            Long entryId;
            Long purEntryId;
            Long billId = row.getLong("id");
            if ("unaudit".equals(operateKey) && currentBills.get(billId) != null || (purEntryId = (Long)busEntryId2PurEntryIds.get(entryId = row.getLong("entry.id"))) == null) continue;
            BigDecimal busQty = row.getBigDecimal("entry.e_baseunitqty");
            BigDecimal sumQty = purEntryId2sumQtys.getOrDefault(purEntryId, BigDecimal.ZERO);
            purEntryId2sumQtys.put(purEntryId, sumQty.add(busQty));
        }
        if ("save".equals(operateKey)) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                bill = dataEntity.getDataEntity();
                if (currentBills.get(bill.getLong("id")) == null) continue;
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    BigDecimal purSumQty;
                    Long purBillEntryId;
                    Long srcEntryId = entry.getLong("e_srcentryid");
                    if (srcEntryId == 0L || (purBillEntryId = (Long)busEntryId2PurEntryIds.get(srcEntryId)) == null || (purSumQty = (BigDecimal)purEntryId2sumQtys.get(purBillEntryId)) == null) continue;
                    purEntryId2sumQtys.put(purBillEntryId, purSumQty.add(entry.getBigDecimal("e_baseunitqty")));
                }
            }
        }
        block12: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            bill = dataEntity.getDataEntity();
            boolean isAdjust = bill.getBoolean("isadjust");
            boolean writeoffbusiness = bill.getBoolean("writeoffbusiness");
            boolean isVerifyBusiness = bill.getBoolean("isverifybusiness");
            boolean isselfwoff = bill.getBoolean("isselfwoff");
            boolean isBasedOnAmt = bill.getBoolean("payproperty.isbasedonamt");
            if (!isAdjust || isVerifyBusiness || !isselfwoff || isBasedOnAmt || "unaudit".equals(operateKey) && writeoffbusiness || "save".equals(operateKey) && !writeoffbusiness) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            String billNo = bill.getString("billno");
            for (DynamicObject entry : entrys) {
                String purBillName;
                Long purBillEntryId;
                Long entryId = entry.getLong("id");
                Long srcEntryId = entry.getLong("e_srcentryid");
                if ("save".equals(operateKey)) {
                    entryId = srcEntryId;
                }
                if ((purBillEntryId = (Long)busEntryId2PurEntryIds.get(entryId)) == null) continue;
                BigDecimal purQty = (BigDecimal)purEntryQtys.get(purBillEntryId);
                BigDecimal purSumQty = (BigDecimal)purEntryId2sumQtys.get(purBillEntryId);
                if (purQty == null || purSumQty == null || purQty.multiply(purSumQty).compareTo(BigDecimal.ZERO) >= 0 && purQty.abs().compareTo(purSumQty.abs()) >= 0) continue;
                String purType = purEntryId2Billtypes.getOrDefault(purBillEntryId, "im_purinbill");
                String qtyField = ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"ApWoffBillUnauditValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                if ("im_purinbill".equals(purType)) {
                    purBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u5355", (String)"ApWoffBillUnauditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("im_purreceivebill".equals(purType)) {
                    purBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355", (String)"ApWoffBillUnauditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("im_ospurinbill".equals(purType)) {
                    purBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355", (String)"ApWoffBillUnauditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("im_mdc_omcmplinbill".equals(purType)) {
                    purBillName = ResManager.loadKDString((String)"\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355", (String)"ApWoffBillUnauditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("pm_purorderbill".equals(purType)) {
                    qtyField = ResManager.loadKDString((String)"\u6536\u8d27\u4e0a\u9650\u6570\u91cf", (String)"ApWoffBillUnauditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                    purBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"ApWoffBillUnauditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("conm_purcontract".equals(purType)) {
                    purBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"ApWoffBillUnauditValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("sctm_scpo".equals(purType)) {
                    qtyField = ResManager.loadKDString((String)"\u6536\u8d27\u4e0a\u9650\u6570\u91cf", (String)"ApWoffBillUnauditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                    purBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"ApWoffBillUnauditValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else {
                    qtyField = ResManager.loadKDString((String)"\u6536\u8d27\u4e0a\u9650\u6570\u91cf", (String)"ApWoffBillUnauditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                    purBillName = ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"ApWoffBillUnauditValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                }
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309%2$s\u67e5\u8be2\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u8d85\u8fc7%2$s%3$s\uff0c\u8bf7\u53cd\u5ba1\u6838\u5176\u4ed6\u975e\u51b2\u56de\u5355\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u540e\u91cd\u8bd5\u3002", (String)"ApWoffBillUnauditValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, purBillName, qtyField));
                continue block12;
            }
        }
    }

    protected QFilter getPurFilter() {
        return null;
    }

    protected String getSrcSelector(String purType) {
        return "billno,billentry.id,billentry.baseqty qty";
    }

    protected Object getPurType() {
        return new String[]{"im_purinbill", "im_purreceivebill", "im_ospurinbill", "im_mdc_omcmplinbill"};
    }
}

