/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.ConmBillInfo;
import kd.fi.arapcommon.vo.CoreBillInfo;

public class ApplyBillCoreBillAndConmAmtAuditValidator
extends AbstractExecControlValidator {
    private Date minDate = null;

    public Set<String> preparePropertys() {
        HashSet<String> lst = new HashSet<String>(16);
        lst.add("settlecurrency");
        lst.add("paycurrency");
        lst.add("entry.e_asstacttype");
        lst.add("entry.e_asstact");
        lst.add("entry.e_corebillid");
        lst.add("entry.e_corebilltype");
        lst.add("billno");
        lst.add("entry.e_paymenttype");
        lst.add("entry.seq");
        lst.add("entry.e_corebillno");
        return lst;
    }

    public void validate() {
        HashMap<Long, ConmBillInfo> conmBillInfoMap = new HashMap<Long, ConmBillInfo>(16);
        HashSet<Long> purOrderIds = new HashSet<Long>(16);
        Map<String, CoreBillInfo> coreBillInfo = this.queryCoreBill(conmBillInfoMap, purOrderIds);
        if (coreBillInfo.size() == 0) {
            return;
        }
        HashMap<Long, Long> orderIdToConmIds = new HashMap<Long, Long>(16);
        for (Map.Entry entrySet : conmBillInfoMap.entrySet()) {
            Long conmBillId = (Long)entrySet.getKey();
            Set orderIds = ((ConmBillInfo)entrySet.getValue()).getOrderBillIds();
            for (Long orderId : orderIds) {
                orderIdToConmIds.put(orderId, conmBillId);
            }
        }
        this.processConmPrePay(conmBillInfoMap);
        Map<Long, Long> supplierMasterIds = this.getSupplierMasterId(coreBillInfo);
        Map<Long, Integer> precisions = this.getPrecision(coreBillInfo);
        this.loadNeedCtrlFinBillInfos(coreBillInfo, conmBillInfoMap, purOrderIds, orderIdToConmIds);
        Set<String> prePayOverToleranceIds = this.processTolerance(coreBillInfo, supplierMasterIds, precisions, true);
        Set<String> sumAmtOverToleranceIds = this.processTolerance(coreBillInfo, supplierMasterIds, precisions, false);
        Set<Long> conmSumAmtToleranceIds = this.processConmToleance(conmBillInfoMap, precisions, supplierMasterIds);
        this.doValidate(coreBillInfo, prePayOverToleranceIds, sumAmtOverToleranceIds, conmBillInfoMap, orderIdToConmIds, conmSumAmtToleranceIds);
    }

    private void doValidate(Map<String, CoreBillInfo> coreBillInfos, Set<String> prePayOverToleranceIds, Set<String> sumAmtOverToleranceIds, Map<Long, ConmBillInfo> conmBillInfoMap, Map<Long, Long> orderIdToConmIds, Set<Long> conmSumAmtToleranceIds) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            String billNo = applyBill.getString("billno");
            Long orgId = applyBill.getLong("settleorg.id");
            Long currencyId = applyBill.getLong("settlecurrency.id");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            HashSet<Long> coreBillIds = new HashSet<Long>(16);
            for (DynamicObject row : entry) {
                boolean conmIsAllowOverPay;
                ConmBillInfo conmBillInfo;
                Long conmBillId;
                Long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                int seq = row.getInt("seq");
                String coreBillNo = row.getString("e_corebillno");
                if (coreBillIds.contains(coreBillId)) continue;
                Long asstactId = row.getLong("e_asstact.id");
                String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo coreBillInfo = coreBillInfos.get(key);
                if (coreBillInfo == null) continue;
                boolean isDiffCurrency = coreBillInfo.isDiffCurrency();
                String applyAmtField = isDiffCurrency ? ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                String coreBillType = row.getString("e_corebilltype");
                String coreBillName = null;
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("conm_purcontract".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("sctm_scpo".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("pm_om_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                }
                boolean isAllowOverPay = coreBillInfo.isAllowOverPay();
                coreBillIds.add(coreBillId);
                if (!isAllowOverPay) {
                    String msg;
                    if (prePayOverToleranceIds.contains(key)) {
                        msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c,\u6309%3$s\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%4$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e%3$s%5$s\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, seq, coreBillName, applyAmtField, coreBillNo);
                        this.addMessage(dataEntity, msg);
                        continue;
                    }
                    if (sumAmtOverToleranceIds.contains(key)) {
                        msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c,\u6309%3$s\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%4$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e%3$s%5$s\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, seq, coreBillName, applyAmtField, coreBillNo);
                        this.addMessage(dataEntity, msg);
                        continue;
                    }
                }
                if ((conmBillId = "pm_purorderbill".equals(coreBillType) ? orderIdToConmIds.get(coreBillId) : coreBillId) == null || (conmBillInfo = conmBillInfoMap.get(conmBillId)) == null || (conmIsAllowOverPay = conmBillInfo.isAllowOverPay()) || !conmSumAmtToleranceIds.contains(conmBillId)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c,\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%3$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u4e0e\u91c7\u8d2d\u5408\u540c\u4ef7\u7a0e\u5408\u8ba1\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"ApplyBillCoreBillAndConmAmtAuditValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, seq, applyAmtField);
                this.addMessage(dataEntity, msg);
            }
        }
    }

    private Set<Long> processConmToleance(Map<Long, ConmBillInfo> conmBillInfoMap, Map<Long, Integer> precisions, Map<Long, Long> supplierMasterIds) {
        HashSet<Long> overToleranceId = new HashSet<Long>(16);
        ArrayList conmParams = new ArrayList(16);
        ToleranceMatchService service = new ToleranceMatchService();
        for (Map.Entry<Long, ConmBillInfo> entrySet : conmBillInfoMap.entrySet()) {
            BigDecimal contrastValue;
            ConmBillInfo conmBillInfo = entrySet.getValue();
            HashMap<String, Number> param = new HashMap<String, Number>(16);
            BigDecimal controlValue = conmBillInfo.getConmBillSumAmt();
            if (controlValue.compareTo(contrastValue = conmBillInfo.getConmBillAmt()) == 0) continue;
            param.put("pk", entrySet.getKey());
            param.put("bos_org", conmBillInfo.getOrgId());
            param.put("bd_supplier", supplierMasterIds.get(conmBillInfo.getSupplierId()));
            param.put("controlvalue", controlValue);
            param.put("contrastvalue", contrastValue);
            param.put("bd_currency", conmBillInfo.getCurrencyId());
            param.put("precision", precisions.get(conmBillInfo.getCurrencyId()));
            conmParams.add(param);
        }
        Map results = service.getAllResult("ap_payapply", "conm_purcontract", "aprseleamount", "totalallamount", conmParams);
        for (Map.Entry result : results.entrySet()) {
            String reason = (String)result.getKey();
            List failToMatchPks = (List)result.getValue();
            if ("failtomatch".equals(reason)) {
                for (Long conmEntryId : failToMatchPks) {
                    ConmBillInfo info = conmBillInfoMap.get(conmEntryId);
                    if (info == null) continue;
                    BigDecimal controlValue = info.getConmBillSumAmt();
                    BigDecimal contrastValue = info.getConmBillAmt();
                    if (controlValue.abs().compareTo(contrastValue.abs()) <= 0) continue;
                    overToleranceId.add(conmEntryId);
                }
                continue;
            }
            overToleranceId.addAll(failToMatchPks);
        }
        return overToleranceId;
    }

    private Set<String> processTolerance(Map<String, CoreBillInfo> coreBillInfo, Map<Long, Long> supplierMasterIds, Map<Long, Integer> precisions, boolean isPrePay) {
        HashSet<String> overToleranceId = new HashSet<String>(16);
        ArrayList purOrderParams = new ArrayList(16);
        ArrayList conmParams = new ArrayList(16);
        ArrayList scpoParams = new ArrayList(16);
        ArrayList pmomParams = new ArrayList(16);
        ToleranceMatchService service = new ToleranceMatchService();
        if (isPrePay) {
            Object results;
            HashMap<String, Map<String, Object>> pk2Param;
            for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
                CoreBillInfo coreBillInfo2 = entrySet.getValue();
                if (coreBillInfo2.getPreparePayAmt().compareTo(BigDecimal.ZERO) == 0 || coreBillInfo2.getSumPrePayAmt().compareTo(coreBillInfo2.getPreparePayAmt()) == 0) continue;
                String coreBillType = coreBillInfo2.getCoreBillType();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("pk", entrySet.getKey());
                param.put("bos_org", coreBillInfo2.getOrgId());
                param.put("bd_supplier", supplierMasterIds.get(coreBillInfo2.getSupplierId()));
                param.put("controlvalue", coreBillInfo2.getSumPrePayAmt());
                param.put("contrastvalue", coreBillInfo2.getPreparePayAmt());
                param.put("bd_currency", coreBillInfo2.getCurrencyId());
                param.put("precision", precisions.get(coreBillInfo2.getCurrencyId()));
                if ("pm_purorderbill".equals(coreBillType)) {
                    purOrderParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomParams.add(param);
            }
            if (purOrderParams.size() > 0) {
                pk2Param = new HashMap<String, Map<String, Object>>(16);
                for (Map map : purOrderParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "payamount", purOrderParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (conmParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : conmParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "conm_purcontract", "e_approvedseleamt", "payamount", conmParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (scpoParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : scpoParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "sctm_scpo", "e_approvedseleamt", "payamount", scpoParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (pmomParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : pmomParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "payamount", pmomParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
        } else {
            Object results;
            HashMap<String, Map<String, Object>> pk2Param;
            for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
                CoreBillInfo coreBillInfo3 = entrySet.getValue();
                if (coreBillInfo3.getSumAmt().compareTo(coreBillInfo3.getCoreBillAmt()) == 0) continue;
                String coreBillType = coreBillInfo3.getCoreBillType();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("pk", entrySet.getKey());
                param.put("bos_org", coreBillInfo3.getOrgId());
                param.put("bd_supplier", supplierMasterIds.get(coreBillInfo3.getSupplierId()));
                param.put("controlvalue", coreBillInfo3.getSumAmt());
                param.put("contrastvalue", coreBillInfo3.getCoreBillAmt());
                param.put("bd_currency", coreBillInfo3.getCurrencyId());
                param.put("precision", precisions.get(coreBillInfo3.getCurrencyId()));
                if ("pm_purorderbill".equals(coreBillType)) {
                    purOrderParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomParams.add(param);
            }
            if (purOrderParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : purOrderParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "totalallamount", purOrderParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (conmParams.size() > 0) {
                pk2Param = new HashMap<String, Map<String, Object>>(16);
                for (Map map : conmParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "conm_purcontract", "e_approvedseleamt", "totalallamount", conmParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (scpoParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : scpoParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "sctm_scpo", "e_approvedseleamt", "totalallamount", scpoParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
            if (pmomParams.size() > 0) {
                pk2Param = new HashMap(16);
                for (Map map : pmomParams) {
                    pk2Param.put((String)map.get("pk"), map);
                }
                results = service.getAllResult("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "totalallamount", pmomParams);
                this.loadOverTolerancePk(pk2Param, (Map<String, Object>)results, overToleranceId);
            }
        }
        return overToleranceId;
    }

    private void loadOverTolerancePk(Map<String, Map<String, Object>> pk2Param, Map<String, Object> results, Set<String> overToleranceId) {
        for (Map.Entry<String, Object> result : results.entrySet()) {
            String reason = result.getKey();
            List failToMatchPks = (List)result.getValue();
            if ("failtomatch".equals(reason)) {
                for (String pk : failToMatchPks) {
                    Map<String, Object> param = pk2Param.get(pk);
                    if (param == null) continue;
                    BigDecimal controlvalue = (BigDecimal)param.get("controlvalue");
                    BigDecimal contrastvalue = (BigDecimal)param.get("contrastvalue");
                    if (controlvalue.abs().compareTo(contrastvalue.abs()) <= 0) continue;
                    overToleranceId.add(pk);
                }
                continue;
            }
            overToleranceId.addAll(failToMatchPks);
        }
    }

    private void loadNeedCtrlFinBillInfos(Map<String, CoreBillInfo> coreBillInfoMap, Map<Long, ConmBillInfo> conmBillInfoMap, Set<Long> purOrderIds, Map<Long, Long> orderIdToConmIds) {
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        coreBillIds.addAll(purOrderIds);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfoMap.entrySet()) {
            CoreBillInfo info = entrySet.getValue();
            coreBillIds.add(info.getCoreBillId());
        }
        QFilter filter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        filter.and(new QFilter("billstatus", "!=", (Object)"A"));
        if (this.minDate != null) {
            this.minDate = DateUtils.getDataFormat((Date)this.minDate, (boolean)true);
            filter.and(new QFilter("applydate", ">=", (Object)this.minDate));
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,billstatus,sourcebilltype,settleorg,paycurrency,settlecurrency,entry.e_paymenttype.biztype,entry.e_asstact,entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,entry.e_corebillentryid,entry.id,entry.e_closestatus", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : payBills) {
            String key;
            CoreBillInfo coreBillInfo;
            ConmBillInfo conmBillInfoByCore;
            Long conmBillId;
            Long coreBillId = bill.getLong("entry.e_corebillid");
            Long orgId = bill.getLong("settleorg");
            Long asstactId = bill.getLong("entry.e_asstact");
            Long curBillCurrencyId = bill.getLong("settlecurrency");
            Long payCurrencyId = bill.getLong("paycurrency");
            String closeStatus = bill.getString("entry.e_closestatus");
            BigDecimal approvedAmt = "B".equals(closeStatus) ? bill.getBigDecimal("entry.e_paidamt") : bill.getBigDecimal("entry.e_approvedseleamt");
            String payType = bill.getString("entry.e_paymenttype.biztype");
            if (!"202".equals(payType)) {
                ConmBillInfo conmBillInfoByConm = conmBillInfoMap.get(coreBillId);
                if (conmBillInfoMap.get(coreBillId) != null) {
                    conmBillInfoByConm.setConmBillSumAmt(conmBillInfoByConm.getConmBillSumAmt().add(approvedAmt));
                }
            }
            if ((conmBillId = orderIdToConmIds.get(coreBillId)) != null && orgId.equals((conmBillInfoByCore = conmBillInfoMap.get(conmBillId)).getOrgId()) && asstactId.equals(conmBillInfoByCore.getSupplierId()) && curBillCurrencyId.equals(conmBillInfoByCore.getCurrencyId())) {
                conmBillInfoByCore.setConmBillSumAmt(conmBillInfoByCore.getConmBillSumAmt().add(approvedAmt));
            }
            if ((coreBillInfo = coreBillInfoMap.get(key = coreBillId + "_" + orgId + "_" + asstactId + "_" + curBillCurrencyId)) == null) continue;
            if (!payCurrencyId.equals(curBillCurrencyId)) {
                coreBillInfo.setDiffCurrency(true);
            }
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
            if (!"202".equals(payType)) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
        }
    }

    private void processConmPrePay(Map<Long, ConmBillInfo> conmBillInfoMap) {
        if (conmBillInfoMap.size() == 0) {
            return;
        }
        Set<Long> conmBillIds = conmBillInfoMap.keySet();
        QFilter filter = new QFilter("entry.e_corebillid", "in", conmBillIds);
        filter.and(new QFilter("billstatus", "!=", (Object)"A"));
        if (this.minDate != null) {
            this.minDate = DateUtils.getDataFormat((Date)this.minDate, (boolean)true);
            filter.and(new QFilter("applydate", ">=", (Object)this.minDate));
        }
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,billstatus", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : applyBills) {
            Long conmBillId = bill.getLong("entry.e_corebillid");
            ConmBillInfo conmBillInfo = conmBillInfoMap.get(conmBillId);
            if ("D".equals(bill.getString("billstatus"))) {
                conmBillInfo.setConmBillSumAmt(conmBillInfo.getConmBillSumAmt().add(bill.getBigDecimal("entry.e_paidamt")));
                continue;
            }
            conmBillInfo.setConmBillSumAmt(conmBillInfo.getConmBillSumAmt().add(bill.getBigDecimal("entry.e_approvedseleamt")));
        }
    }

    private Map<String, CoreBillInfo> queryCoreBill(Map<Long, ConmBillInfo> conmBillAmtMap, Set<Long> purOrderIds) {
        List orderInfo;
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        HashMap coreOrderBillInfo = new HashMap(16);
        HashMap coreConBillInfo = new HashMap(16);
        HashMap coreOmBillInfo = new HashMap(16);
        HashMap corePmOmBillInfo = new HashMap(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                String coreBillType = row.getString("e_corebilltype");
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreOrderBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    coreConBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    coreOmBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                corePmOmBillInfo.put(coreBillId, new HashSet(2));
            }
        }
        if (coreOrderBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_purorderbill", conmBillAmtMap, purOrderIds);
        }
        if (coreConBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "conm_purcontract", conmBillAmtMap, purOrderIds);
        }
        if (coreOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "sctm_scpo", conmBillAmtMap, purOrderIds);
        }
        if (corePmOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"OmPurOrderbillService", (String)"getOmPurOrderbillInfo", (Object[])new Object[]{corePmOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_om_purorderbill", conmBillAmtMap, purOrderIds);
            this.minDate = null;
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params, String coreBillType, Map<Long, ConmBillInfo> conmBillAmtMap, Set<Long> purOrderIds) {
        HashSet<Long> allConmBillIds = new HashSet<Long>(16);
        for (Map<String, Object> map : params) {
            Date date;
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            Long id = (Long)map.get("billid");
            Iterator<Map.Entry<Long, ConmBillInfo>> asstactId = (Long)map.get("invoicesupplier");
            Long currencyId = (Long)map.get("settlecurrency");
            BigDecimal preparePayAmt = (BigDecimal)map.get("sumprepayamount");
            if (preparePayAmt == null) {
                preparePayAmt = BigDecimal.ZERO;
            }
            if ((date = (Date)map.get("createtime")) != null) {
                this.minDate = this.minDate == null ? date : (this.minDate.before(date) ? this.minDate : date);
            }
            List list = (List)map.get("entryinfo");
            HashSet<Long> conmBillIds = new HashSet<Long>(16);
            boolean conmIsAllowOverPay = false;
            BigDecimal conmBillAmt = BigDecimal.ZERO;
            Long orgId = 0L;
            for (Map entry : list) {
                orgId = (Long)entry.get("settleorg");
                String key = id + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo info = coreBillInfoMap.get(key);
                if ("pm_purorderbill".equals(coreBillType)) {
                    Long conmBillId = (Long)entry.get("conbillid");
                    Long conmCurrencyId = (Long)entry.get("consettlecurrency");
                    if (conmBillId != null && conmCurrencyId.equals(currencyId)) {
                        boolean conhasprepay;
                        Date conmDate = (Date)entry.get("concreatetime");
                        if (conmDate != null) {
                            if (this.minDate == null) {
                                this.minDate = conmDate;
                            } else {
                                Date date2 = this.minDate = this.minDate.before(conmDate) ? this.minDate : conmDate;
                            }
                        }
                        if (conhasprepay = ((Boolean)entry.get("conhasprepay")).booleanValue()) {
                            allConmBillIds.add(conmBillId);
                            conmBillIds.add(conmBillId);
                            conmIsAllowOverPay = (Boolean)entry.get("conisallowoverpay");
                            conmBillAmt = (BigDecimal)entry.get("consumamountandtax");
                        }
                    }
                }
                if (info == null) {
                    info = new CoreBillInfo();
                    info.setCoreBillId(id);
                    info.setAllowOverPay(isAllowOverPay);
                    info.setOrgId(orgId);
                    info.setCoreBillType(coreBillType);
                    info.setSupplierId(asstactId);
                    info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                    info.setCurrencyId(currencyId);
                    info.setPreparePayAmt(preparePayAmt);
                    coreBillInfoMap.put(key, info);
                } else {
                    info.setCoreBillAmt(info.getCoreBillAmt().add((BigDecimal)entry.get("amountandtax")));
                }
                if (!"conm_purcontract".equals(coreBillType)) continue;
                ConmBillInfo conmBillInfo = conmBillAmtMap.get(id);
                if (preparePayAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                allConmBillIds.add(id);
                if (conmBillInfo == null) {
                    conmBillInfo = new ConmBillInfo();
                    conmBillInfo.setConmBillId(id);
                    conmBillInfo.setAllowOverPay(isAllowOverPay);
                    conmBillInfo.setOrgId(orgId.longValue());
                    conmBillInfo.setSupplierId(asstactId);
                    conmBillInfo.setCurrencyId(currencyId);
                    conmBillInfo.setConmBillAmt((BigDecimal)entry.get("amountandtax"));
                    conmBillAmtMap.put(id, conmBillInfo);
                    continue;
                }
                conmBillInfo.setConmBillAmt(conmBillInfo.getConmBillAmt().add((BigDecimal)entry.get("amountandtax")));
            }
            if (conmBillIds.size() != 1) continue;
            Long conmBillId = (Long)conmBillIds.iterator().next();
            ConmBillInfo conmBillInfo = conmBillAmtMap.get(conmBillId);
            if (conmBillInfo == null) {
                conmBillInfo = new ConmBillInfo();
                conmBillInfo.setConmBillId((Long)conmBillIds.iterator().next());
                conmBillInfo.setAllowOverPay(conmIsAllowOverPay);
                conmBillInfo.setConmBillAmt(conmBillAmt);
                conmBillInfo.setCurrencyId(currencyId);
                conmBillInfo.setSupplierId(asstactId);
                conmBillInfo.setOrgId(orgId.longValue());
                conmBillInfo.getOrderBillIds().add(id);
                conmBillAmtMap.put(conmBillId, conmBillInfo);
                continue;
            }
            conmBillInfo.getOrderBillIds().add(id);
        }
        if (allConmBillIds.size() > 0) {
            Long conmBillId;
            HashMap conmIdToOrderIdsMap = new HashMap(16);
            HashMap<Long, Object> orderIdToConmIdsMap = new HashMap<Long, Object>(16);
            HashSet<Long> orderIds = new HashSet<Long>(16);
            DynamicObjectCollection purOrderEntrys = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("billentry.conbillid", "in", allConmBillIds)});
            for (DynamicObject orderEntry : purOrderEntrys) {
                orderIds.add(orderEntry.getLong("id"));
                conmBillId = orderEntry.getLong("billentry.conbillid");
                Set set = (Set)conmIdToOrderIdsMap.get(conmBillId);
                if (set == null) {
                    HashSet<Long> hashSet = new HashSet<Long>(16);
                    hashSet.add(orderEntry.getLong("id"));
                    conmIdToOrderIdsMap.put(conmBillId, hashSet);
                    continue;
                }
                set.add(orderEntry.getLong("id"));
            }
            for (Map.Entry<Long, ConmBillInfo> entrySet : conmBillAmtMap.entrySet()) {
                conmBillId = entrySet.getKey();
                Set set = (Set)conmIdToOrderIdsMap.get(conmBillId);
                if (set == null) continue;
                entrySet.getValue().getOrderBillIds().addAll(set);
            }
            DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)});
            for (Object order : purOrderBills) {
                Long l = order.getLong("id");
                Long l2 = order.getLong("billentry.conbillid");
                HashSet<Long> upConmIds = (HashSet<Long>)orderIdToConmIdsMap.get(l);
                if (upConmIds == null) {
                    upConmIds = new HashSet<Long>(16);
                    upConmIds.add(l2);
                    orderIdToConmIdsMap.put(l, upConmIds);
                    continue;
                }
                upConmIds.add(l2);
            }
            HashSet hadMultiConmsOrderId = new HashSet(16);
            for (Map.Entry entry : orderIdToConmIdsMap.entrySet()) {
                if (((Set)entry.getValue()).size() > 1) {
                    hadMultiConmsOrderId.add(entry.getKey());
                    continue;
                }
                purOrderIds.add((Long)entry.getKey());
            }
            HashSet hadmulitConmIds = new HashSet(16);
            for (Map.Entry entry : conmIdToOrderIdsMap.entrySet()) {
                for (Long orderId : hadMultiConmsOrderId) {
                    if (!((Set)entry.getValue()).contains(orderId)) continue;
                    hadmulitConmIds.add(entry.getKey());
                }
            }
            for (Long l : hadmulitConmIds) {
                conmBillAmtMap.remove(l);
            }
            Iterator<Map.Entry<Long, ConmBillInfo>> iterator = conmBillAmtMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ConmBillInfo> entry = iterator.next();
                ConmBillInfo conmBillInfo = entry.getValue();
                if (conmBillInfo.getOrderBillIds().size() != 0) continue;
                iterator.remove();
            }
        }
    }

    private Map<Long, Integer> getPrecision(Map<String, CoreBillInfo> coreBillInfo) {
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            currencyIds.add(entrySet.getValue().getCurrencyId());
        }
        HashMap<Long, Integer> precisions = new HashMap<Long, Integer>(16);
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (DynamicObject currency : currencys) {
            precisions.put(currency.getLong("id"), currency.getInt("amtprecision"));
        }
        return precisions;
    }

    private Map<Long, Long> getSupplierMasterId(Map<String, CoreBillInfo> coreBillInfo) {
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            supplierIds.add(entrySet.getValue().getSupplierId());
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        for (DynamicObject supplier : suppliers) {
            supplierMasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
        }
        return supplierMasterIds;
    }
}

