/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.vo.CoreBillInfo;
import org.apache.commons.lang.StringUtils;

public class ApplyPayBillConmAmtValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("e_conbillnumber");
        fields.add("e_corebilltype");
        fields.add("e_corebillid");
        fields.add("billno");
        fields.add("settlecurrency");
        fields.add("paycurrency");
        fields.add("settleorg");
        fields.add("e_asstact");
        fields.add("e_approvedamt");
        fields.add("entry.seq");
        fields.add("entry.e_paymenttype");
        return fields;
    }

    public void validate() {
        DynamicObjectCollection entry;
        ArrayList<String> conmBillNos = new ArrayList<String>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        HashMap<Object, HashSet<String>> conmBillNoToOrgAndSupplierMap = new HashMap<Object, HashSet<String>>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entry2 = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry2) {
                String coreBillType = row.getString("e_corebilltype");
                Long coreBillId = row.getLong("e_corebillid");
                String conBillNumber = row.getString("e_conbillnumber");
                String payType = row.getString("e_paymenttype.biztype");
                if ((!"pm_purorderbill".equals(coreBillType) || coreBillId == 0L || kd.fi.arapcommon.util.StringUtils.isEmpty((String)conBillNumber)) && (!"conm_purcontract".equals(coreBillType) || !"202".equals(payType) || kd.fi.arapcommon.util.StringUtils.isEmpty((String)conBillNumber))) continue;
                conmBillNos.add(conBillNumber);
            }
        }
        if (conmBillNos.size() == 0) {
            return;
        }
        HashMap<Object, CoreBillInfo> conmBillInfos = new HashMap<Object, CoreBillInfo>(16);
        DynamicObjectCollection conmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"billno,settlecurrency,totalallamount,invoicesupplier,billentry.entrysettleorg,isallowoverpay", (QFilter[])new QFilter[]{new QFilter("billno", "in", conmBillNos)});
        for (DynamicObject conmBill : conmBills) {
            HashSet<String> orgAndSupplierKeys;
            String billNo = conmBill.getString("billno");
            Long orgId = conmBill.getLong("billentry.entrysettleorg");
            if (orgId == 0L) continue;
            orgIds.add(orgId);
            Long supplierId = conmBill.getLong("invoicesupplier");
            supplierIds.add(supplierId);
            Long currencyId = conmBill.getLong("settlecurrency");
            CoreBillInfo info = (CoreBillInfo)conmBillInfos.get(billNo);
            if (info == null) {
                info = new CoreBillInfo();
                info.setOrgId(orgId);
                info.setConmBillNo(billNo);
                info.setSupplierId(supplierId);
                info.setCurrencyId(currencyId);
                info.setConmBillAmt(conmBill.getBigDecimal("totalallamount"));
                info.setAllowOverPay(conmBill.getBoolean("isallowoverpay"));
                conmBillInfos.put(billNo, info);
            }
            if ((orgAndSupplierKeys = (HashSet<String>)conmBillNoToOrgAndSupplierMap.get(billNo)) == null) {
                orgAndSupplierKeys = new HashSet<String>(16);
                orgAndSupplierKeys.add(orgId + "_" + supplierId + "_" + currencyId);
                conmBillNoToOrgAndSupplierMap.put(billNo, orgAndSupplierKeys);
                continue;
            }
            orgAndSupplierKeys.add(orgId + "_" + supplierId + "_" + currencyId);
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        for (ExtendedDataEntity[] supplier : suppliers) {
            supplierMasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
        }
        HashSet<Long> currentIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            currentIds.add(bill.getLong("id"));
            Long orgId = bill.getLong("settleorg.id");
            Long currencyId = bill.getLong("settlecurrency.id");
            Long payCurrencyId = bill.getLong("paycurrency.id");
            int precision = bill.getInt("settlecurrency.amtprecision");
            entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                CoreBillInfo info;
                String coreBillType = row.getString("e_corebilltype");
                Long coreBillId = row.getLong("e_corebillid");
                String conBillNumber = row.getString("e_conbillnumber");
                String payType = row.getString("e_paymenttype.biztype");
                Long asstactId = row.getLong("e_asstact.id");
                if ((!"pm_purorderbill".equals(coreBillType) || coreBillId == 0L || kd.fi.arapcommon.util.StringUtils.isEmpty((String)conBillNumber)) && (!"conm_purcontract".equals(coreBillType) || !"202".equals(payType) || kd.fi.arapcommon.util.StringUtils.isEmpty((String)conBillNumber))) continue;
                String key = orgId + "_" + asstactId + "_" + currencyId;
                Set orgAndSupplierKeys = (Set)conmBillNoToOrgAndSupplierMap.get(conBillNumber);
                if (orgAndSupplierKeys == null || !orgAndSupplierKeys.contains(key) || (info = (CoreBillInfo)conmBillInfos.get(conBillNumber)) == null) continue;
                info.setAmtPrecision(precision);
                info.setConmSumAmt(info.getConmSumAmt().add(row.getBigDecimal("e_approvedamt")));
                if (currencyId.equals(payCurrencyId)) continue;
                info.setDiffCurrency(true);
            }
        }
        DynamicObjectCollection historyApplyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,settleorg,settlecurrency,paycurrency,entry.e_asstact,billstatus,entry.e_approvedamt,entry.e_paidamt,entry.e_conbillnumber,entry.e_closestatus", (QFilter[])new QFilter[]{new QFilter("entry.e_conbillnumber", "in", conmBillNos), new QFilter("billstatus", "!=", (Object)"A"), new QFilter("settleorg", "in", orgIds)});
        for (DynamicObject bill : historyApplyBills) {
            Long payCurrencyId;
            if (currentIds.contains(bill.getLong("id"))) continue;
            String conmBillNo = bill.getString("entry.e_conbillnumber");
            String key = bill.getLong("settleorg") + "_" + bill.getLong("entry.e_asstact") + "_" + bill.getLong("settlecurrency");
            Set orgAndSupplierIdKeys = (Set)conmBillNoToOrgAndSupplierMap.get(conmBillNo);
            if (!orgAndSupplierIdKeys.contains(key)) continue;
            String closeStatus = bill.getString("entry.e_closestatus");
            BigDecimal currentAmt = "B".equals(closeStatus) ? bill.getBigDecimal("entry.e_paidamt") : bill.getBigDecimal("entry.e_approvedamt");
            CoreBillInfo info = (CoreBillInfo)conmBillInfos.get(conmBillNo);
            if (info == null) continue;
            info.setConmSumAmt(info.getConmSumAmt().add(currentAmt));
            Long settleCurrencyId = bill.getLong("settlecurrency");
            if (settleCurrencyId.equals(payCurrencyId = Long.valueOf(bill.getLong("paycurrency")))) continue;
            info.setDiffCurrency(true);
        }
        ArrayList toleranceParams = new ArrayList(16);
        for (Map.Entry entrySet : conmBillInfos.entrySet()) {
            BigDecimal conmSumAmt;
            CoreBillInfo info = (CoreBillInfo)entrySet.getValue();
            boolean isAllowOverPay = info.isAllowOverPay();
            if (!isAllowOverPay) continue;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            BigDecimal conmBillAmt = info.getConmBillAmt();
            if (conmBillAmt.compareTo(conmSumAmt = info.getConmSumAmt()) == 0) continue;
            param.put("pk", info.getConmBillNo());
            param.put("bos_org", info.getOrgId());
            param.put("controlvalue", conmSumAmt);
            param.put("contrastvalue", conmBillAmt);
            param.put("precision", info.getAmtPrecision());
            param.put("bd_currency", info.getCurrencyId());
            Long supplierMasterId = (Long)supplierMasterIds.get(info.getSupplierId());
            param.put("bd_supplier", supplierMasterId);
            param.put("bd_customer", null);
            toleranceParams.add(param);
        }
        HashMap<String, Object> overToleranceNos = new HashMap<String, Object>(16);
        if (toleranceParams.size() > 0) {
            ToleranceMatchService service = new ToleranceMatchService();
            Map results = service.getAllResult("ap_payapply", "conm_purcontract", "e_approvedseleamt", "totalallamount", toleranceParams);
            for (Map.Entry result : results.entrySet()) {
                String reason = (String)result.getKey();
                List failToMatchPks = (List)result.getValue();
                if ("failtomatch".equals(reason)) {
                    for (String pk : failToMatchPks) {
                        CoreBillInfo info = (CoreBillInfo)conmBillInfos.get(pk);
                        if (info == null) continue;
                        BigDecimal conmBillAmt = info.getConmBillAmt();
                        BigDecimal conmSumAmt = info.getConmSumAmt();
                        if (conmSumAmt.abs().compareTo(conmBillAmt.abs()) <= 0) continue;
                        overToleranceNos.put(info.getConmBillNo(), info);
                    }
                    continue;
                }
                for (String pk : failToMatchPks) {
                    overToleranceNos.put(pk, pk);
                }
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String approveAmtField;
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = bill.getString("billno");
            entry = bill.getDynamicObjectCollection("entry");
            HashSet<String> overToleranceConmNos = new HashSet<String>(16);
            boolean isDiffCurency = false;
            for (DynamicObject row : entry) {
                CoreBillInfo info;
                String coreBillType = row.getString("e_corebilltype");
                Long coreBillId = row.getLong("e_corebillid");
                String payType = row.getString("e_paymenttype.biztype");
                String conBillNumber = row.getString("e_conbillnumber");
                if ((!"pm_purorderbill".equals(coreBillType) || coreBillId == 0L || kd.fi.arapcommon.util.StringUtils.isEmpty((String)conBillNumber)) && (!"conm_purcontract".equals(coreBillType) || !"202".equals(payType)) || (info = (CoreBillInfo)conmBillInfos.get(conBillNumber)) == null) continue;
                if (info.isDiffCurrency()) {
                    isDiffCurency = true;
                }
                if (info.isAllowOverPay() || overToleranceNos.get(conBillNumber) == null) continue;
                overToleranceConmNos.add(conBillNumber);
            }
            String string = approveAmtField = isDiffCurency ? ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01", (String)"ApplyPayBillConmAmtValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6838\u51c6\u91d1\u989d", (String)"ApplyPayBillConmAmtValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
            if (overToleranceConmNos.size() <= 0) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001%2$s\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u4ef7\u7a0e\u5408\u8ba1\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u4e0b\u5217\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u7684\u660e\u7ec6\u884c\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\uff1a%3$s\u3002", (String)"ApplyPayBillConmAmtValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, approveAmtField, StringUtils.join(overToleranceConmNos, (String)"\uff0c")));
        }
    }
}

