/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;

public class ApplyPayClosePayValidator
extends AbstractValidator {
    public void validate() {
        Set<Long> validatorApplyBillIds = this.getUnPayBillIds();
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(32);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            orgIds.add(bill.getLong("settleorg.id"));
            billIds.add(bill.getLong("id"));
        }
        Map onTheWayApplyIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_payapply", orgIds, billIds);
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            if (!bill.getString("billstatus").equals("C") && !bill.getString("billstatus").equals("E")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u6216\u90e8\u5206\u5173\u95ed\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5141\u8bb8\u5173\u95ed\u3002", (String)"ApplyPayClosePayValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (validatorApplyBillIds.contains(bill.getLong("id"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4ed8\u6b3e\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u4ed8\u6b3e\u7533\u8bf7\u3002", (String)"ApplyPayClosePayValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (!onTheWayApplyIdsMap.containsKey(bill.getLong("id"))) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"ApplyPayClosePayValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> getUnPayBillIds() {
        Map allTargetBillIds;
        DynamicObject bill;
        ArrayList<Long> applyBillIds = new ArrayList<Long>(8);
        ArrayList<Long> applyRowIds = new ArrayList<Long>(8);
        ExtendedDataEntity[] datas = this.getDataEntities();
        Map paramMap = this.getOption().getVariables();
        String selectrows = (String)paramMap.get("selectrows");
        if (ObjectUtils.isEmpty((Object)selectrows)) {
            for (ExtendedDataEntity data : datas) {
                bill = data.getDataEntity();
                applyBillIds.add(bill.getLong("id"));
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                Iterator iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    applyRowIds.add(row.getLong("id"));
                }
            }
        } else {
            for (ExtendedDataEntity data : datas) {
                bill = data.getDataEntity();
                applyBillIds.add(bill.getLong("id"));
            }
            List selectrowList = (List)SerializationUtils.fromJsonString((String)selectrows, List.class);
            for (Object rowId : selectrowList) {
                if ("0".equals(rowId.toString())) continue;
                applyRowIds.add(Long.valueOf(rowId.toString()));
            }
        }
        if ((allTargetBillIds = BOTPNewHelper.loadAllTargetBillIds((String)"ap_payapply", (String)"entry", (Long[])applyBillIds.toArray(new Long[0]), (Long[])applyRowIds.toArray(new Long[0]))).isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet allCasPayBillIds = new HashSet(8);
        for (Map.Entry entrySet : allTargetBillIds.entrySet()) {
            List casPayBillIds = (List)((Map)entrySet.getValue()).get("cas_paybill");
            if (ObjectUtils.isEmpty((Object)casPayBillIds)) continue;
            allCasPayBillIds.addAll(casPayBillIds);
        }
        if (allCasPayBillIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        QFilter filter = new QFilter("id", "in", allCasPayBillIds);
        filter.and(new QFilter("billstatus", "!=", (Object)"D"));
        filter.and(new QFilter("billstatus", "!=", (Object)"F"));
        filter.and(new QFilter("billstatus", "!=", (Object)"G"));
        filter.and(new QFilter("billstatus", "!=", (Object)"H"));
        filter.and(new QFilter("billstatus", "!=", (Object)"I"));
        DynamicObjectCollection casPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (casPayBills.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> validatorCasBillIds = new HashSet<Long>(8);
        for (DynamicObject casPayBill : casPayBills) {
            validatorCasBillIds.add(casPayBill.getLong("id"));
        }
        HashSet<Long> validatorApplyBillIds = new HashSet<Long>(8);
        block6: for (Map.Entry entrySet : allTargetBillIds.entrySet()) {
            List casBillIds = (List)((Map)entrySet.getValue()).get("cas_paybill");
            if (ObjectUtils.isEmpty((Object)casBillIds)) continue;
            for (Long casBillId : casBillIds) {
                if (!validatorCasBillIds.contains(casBillId)) continue;
                validatorApplyBillIds.add((Long)entrySet.getKey());
                continue block6;
            }
        }
        return validatorApplyBillIds;
    }
}

