/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.util.JsonUtils;

public class AssignFinApValidator
extends AbstractValidator {
    public void validate() {
        List finApBillIds = (List)JsonUtils.jsonToObj((String)this.getOption().getVariableValue("finpks"), List.class);
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)this.getFinSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finApBillIds)});
        boolean isFinMatched = false;
        BigDecimal finApUnInvoiceAmount = BigDecimal.ZERO;
        String asstactName = "";
        for (DynamicObject finApBill : finApBills) {
            InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
            String message = assignService.validateFin(new DynamicObject[]{finApBill});
            if (!ObjectUtils.isEmpty((Object)message)) {
                this.addMessage(this.getDataEntities()[0], message);
            }
            if (finApBill.getBoolean("isinvoicematch")) {
                isFinMatched = true;
            }
            finApUnInvoiceAmount = finApUnInvoiceAmount.add(finApBill.getBigDecimal("uninvoicedamt"));
            asstactName = finApBill.getString("asstact.name");
        }
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject invoice = dataEntity.getDataEntity();
            orgIds.add(invoice.getLong("org.id"));
        }
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        BigDecimal invUnRelatedAmt = BigDecimal.ZERO;
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            InvoiceAssignService assignService;
            String message;
            String invAsstactName;
            DynamicObject invoice = dataEntity.getDataEntity();
            Long orgId = invoice.getLong("org.id");
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            if (config != null && "0".equals(config.getString("identicalpartyinvcom")) && !asstactName.equals(invAsstactName = invoice.getString("asstactname"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\uff08\u6536\u7968\u5355\u7f16\u53f7: %s\uff09\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"AssignFinApValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[]{invoice.getString("billno")}));
            }
            invUnRelatedAmt = invUnRelatedAmt.add(invoice.getBigDecimal("unrelatedamt"));
            if (invoice.getBoolean("ismatched") && !isFinMatched) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u7968\u5355:%s\u5df2\u5b58\u5728\u5339\u914d\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6307\u5b9a\u5e94\u4ed8\u64cd\u4f5c\u3002", (String)"AssginInvoiceValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{invoice.getString("billno")}));
            }
            if (ObjectUtils.isEmpty((Object)(message = (assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue())).validateInvoice(new DynamicObject[]{invoice})))) continue;
            this.addMessage(dataEntity, message);
        }
        if (finApUnInvoiceAmount.signum() != invUnRelatedAmt.signum()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u548c\u6536\u7968\u5355\u7684\u672a\u5173\u8054\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"AssignFinApValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private String getFinSelector() {
        return "billno,uninvoicedamt,isinvoicematch,sourcebilltype,billstatus,asstact,billsrctype";
    }
}

