/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.helper.ToleranceHepler;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.paysecurity.ApInvoiceExcessBusValidator;
import kd.fi.arapcommon.validator.paysecurity.BusValidatorResult;
import kd.fi.arapcommon.validator.paysecurity.FinApExcessBusValidator;

public class BillToleranceValidator {
    public static void finApTaxValidator(DynamicObject[] dataEntities) {
        if (!ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"ap_finapbill", (String)"e_tax", (String)"e_tax")) {
            return;
        }
        ArrayList toleranceParams = new ArrayList(16);
        HashMap<Long, DynamicObject> materialGroupMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject bill : dataEntities) {
            boolean isWriteOff = bill.getBoolean("iswrittenoff");
            boolean isPremBill = bill.getBoolean("ispremium");
            boolean isTanspay = bill.getBoolean("istanspay");
            String billType = bill.getString("billtypeid.number");
            if (isWriteOff || isPremBill || isTanspay || "ApFin_borr_BT_S".equals(billType)) continue;
            DynamicObject currency = bill.getDynamicObject("currency");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            int precision = currency.getInt("amtprecision");
            Long currencyId = currency.getLong("id");
            Long orgId = bill.getLong("org.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            List materialIds = entry.stream().map(v -> v.getLong("material.id")).collect(Collectors.toList());
            HashMap<Long, ArrayList<Long>> materialIdToMaterialgroup = new HashMap<Long, ArrayList<Long>>(16);
            ArrayList<DynamicObject> materialGroups = new ArrayList<DynamicObject>(8);
            for (Long materialId : materialIds) {
                DynamicObject group = (DynamicObject)materialGroupMap.get(materialId);
                if (group == null && (group = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "=", (Object)materialId)})) != null) {
                    materialGroupMap.put(materialId, group);
                }
                if (group == null) continue;
                materialGroups.add(group);
            }
            for (DynamicObject group : materialGroups) {
                Long materialId = group.getLong("material");
                ArrayList<Long> materialGroupIds = (ArrayList<Long>)materialIdToMaterialgroup.get(materialId);
                if (materialGroupIds == null) {
                    materialGroupIds = new ArrayList<Long>(16);
                    materialGroupIds.add(group.getLong("group"));
                    materialIdToMaterialgroup.put(materialId, materialGroupIds);
                    continue;
                }
                materialGroupIds.add(group.getLong("group"));
            }
            for (DynamicObject row : entry) {
                BigDecimal realTax;
                BigDecimal amount = row.getBigDecimal("e_amount");
                BigDecimal taxRate = row.getBigDecimal("taxrate");
                BigDecimal tax = row.getBigDecimal("e_tax");
                if (tax.compareTo(realTax = amount.multiply(taxRate).divide(new BigDecimal("100"), precision, RoundingMode.HALF_UP)) == 0) continue;
                Long materialId = row.getLong("material.id");
                HashMap<String, Object> toleranceMap = new HashMap<String, Object>(8);
                toleranceMap.put("e_tax", tax);
                toleranceMap.put("controlvalue", tax);
                toleranceMap.put("contrastvalue", realTax);
                toleranceMap.put("bd_currency", currencyId);
                toleranceMap.put("bd_material", materialId);
                toleranceMap.put("precision", precision);
                List materialGroup = (List)materialIdToMaterialgroup.get(materialId);
                toleranceMap.put("bd_materialgroup", materialGroup);
                if ("bd_supplier".equals(asstactType)) {
                    toleranceMap.put("bd_supplier", asstactId);
                    toleranceMap.put("bd_customer", null);
                } else {
                    toleranceMap.put("bd_customer", asstactId);
                    toleranceMap.put("bd_supplier", null);
                }
                toleranceMap.put("bos_org", orgId);
                toleranceMap.put("pk", row.getLong("id"));
                toleranceParams.add(toleranceMap);
            }
        }
        ToleranceMatchService service = new ToleranceMatchService();
        List result = service.getResultByToleranceType("ap_finapbill", "ap_finapbill", "e_tax", "e_tax", toleranceParams);
        ArrayList<Long> overTaxentryIds = new ArrayList<Long>(16);
        for (Map resultMap : result) {
            overTaxentryIds.add((Long)resultMap.get("pk"));
        }
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            String billNo = bill.getString("billno");
            for (DynamicObject row : entry) {
                Long entryId = row.getLong("id");
                if (!overTaxentryIds.contains(entryId)) continue;
                errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u7a0e\u989d\u4e0e\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97\u7684\u7a0e\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u5173\u6ce8\u662f\u5426\u5b58\u5728\u7a0e\u52a1\u98ce\u9669\u3002", (String)"BillToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq")));
            }
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public static void busQtyAndAmtValidator(DynamicObject[] bills) {
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (DynamicObject bill : bills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourceBillType)) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() == 0) {
            return;
        }
        FinApExcessBusValidator validator = new FinApExcessBusValidator();
        List results = validator.validate(billIds, "submit");
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (BusValidatorResult result : results) {
            String message = result.getMessage();
            errMessage.add(message);
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public static void coreBillPriceValidator(DynamicObject[] bills) {
        Long coreBillEntryId;
        DynamicObjectCollection entry;
        boolean execcontrolOpen;
        String entityName = bills[0].getDynamicObjectType().getName();
        if ("ap_busbill".equals(entityName) ? !(execcontrolOpen = BillToleranceValidator.initValidata("SZJK-PRE-0096")) : !(execcontrolOpen = BillToleranceValidator.initValidata("SZJK-PRE-0097"))) {
            return;
        }
        boolean noBusOrderPriceTol = false;
        boolean noBusConPriceTol = false;
        boolean noBusScpoPriceTol = false;
        boolean noBusPmomPriceTol = false;
        boolean noFinOrderPriceTol = false;
        boolean noFinConPriceTol = false;
        boolean noFinScpoPriceTol = false;
        boolean noFinPmomPriceTol = false;
        if ("ap_busbill".equals(entityName)) {
            noBusOrderPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"pm_purorderbill", (String)"e_unitprice", (String)"price");
            noBusConPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"conm_purcontract", (String)"e_unitprice", (String)"price");
            noBusScpoPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"sctm_scpo", (String)"e_unitprice", (String)"price");
            noBusPmomPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"pm_om_purorderbill", (String)"e_unitprice", (String)"price");
        } else {
            noFinOrderPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"pm_purorderbill", (String)"price", (String)"price");
            noFinConPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"conm_purcontract", (String)"price", (String)"price");
            noFinScpoPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"sctm_scpo", (String)"price", (String)"price");
            noFinPmomPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"pm_om_purorderbill", (String)"price", (String)"price");
        }
        String billName = bills[0].getDataEntityType().getDisplayName().getLocaleValue();
        String entryName = "ap_busbill".equals(entityName) ? "entry" : "detailentry";
        String materialField = "ap_busbill".equals(entityName) ? "e_material.id" : "material.id";
        String coreBillTypeField = "ap_busbill".equals(entityName) ? "e_corebilltype" : "corebilltype";
        String priceField = "ap_busbill".equals(entityName) ? "e_unitprice" : "price";
        HashSet<Long> purOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> conmEntryIds = new HashSet<Long>(16);
        HashSet<Long> scpoEntryIds = new HashSet<Long>(16);
        HashSet<Long> pmomEntryIds = new HashSet<Long>(16);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        HashSet<Long> customerIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            if (!BillToleranceValidator.priceNeedValidate(entityName, bill)) continue;
            String asstactType = bill.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(bill.getLong("asstact.id"));
            } else {
                customerIds.add(bill.getLong("asstact.id"));
            }
            DynamicObjectCollection entry2 = bill.getDynamicObjectCollection(entryName);
            Iterator iterator = entry2.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                Long coreBillEntryId2 = row.getLong("corebillentryid");
                if (coreBillEntryId2 == 0L) continue;
                materialIds.add(row.getLong(materialField));
                String coreBillType = row.getString(coreBillTypeField);
                if ("pm_purorderbill".equals(coreBillType)) {
                    purOrderEntryIds.add(coreBillEntryId2);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmEntryIds.add(coreBillEntryId2);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoEntryIds.add(coreBillEntryId2);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomEntryIds.add(coreBillEntryId2);
            }
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        if (supplierIds.size() > 0) {
            DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
            for (Object supplier : suppliers) {
                supplierMasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
            }
        }
        HashMap<Long, Long> customerMasterIds = new HashMap<Long, Long>(16);
        if (customerIds.size() > 0) {
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIds)});
            for (DynamicObject customer : customers) {
                customerMasterIds.put(customer.getLong("id"), customer.getLong("masterid"));
            }
        }
        HashMap<Object, ArrayList<Long>> materialIdToMaterialgroup = new HashMap<Object, ArrayList<Long>>(16);
        HashMap<Long, Long> materialMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
        for (Object material : materials) {
            materialMasterIds.put(material.getLong("id"), material.getLong("masterid"));
        }
        DynamicObjectCollection materialGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "in", materialIds)});
        for (DynamicObject group : materialGroups) {
            Long materialId = group.getLong("material");
            ArrayList<Long> materialGroupIds = (ArrayList<Long>)materialIdToMaterialgroup.get(materialId);
            if (materialGroupIds == null) {
                materialGroupIds = new ArrayList<Long>(16);
                materialGroupIds.add(group.getLong("group"));
                materialIdToMaterialgroup.put(materialId, materialGroupIds);
                continue;
            }
            materialGroupIds.add(group.getLong("group"));
        }
        HashMap<Long, BigDecimal> coreBillEntryPriceMap = new HashMap<Long, BigDecimal>(16);
        if (purOrderEntryIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", purOrderEntryIds)});
            for (DynamicObject purBill : purBills) {
                coreBillEntryPriceMap.put(purBill.getLong("billentry.id"), purBill.getBigDecimal("billentry.price"));
            }
        }
        if (conmEntryIds.size() > 0) {
            DynamicObjectCollection conmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conmEntryIds)});
            for (DynamicObject conmBill : conmBills) {
                coreBillEntryPriceMap.put(conmBill.getLong("billentry.id"), conmBill.getBigDecimal("billentry.price"));
            }
        }
        if (scpoEntryIds.size() > 0) {
            DynamicObjectCollection scpoBills = QueryServiceHelper.query((String)"sctm_scpo", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", scpoEntryIds)});
            for (DynamicObject scpoBill : scpoBills) {
                coreBillEntryPriceMap.put(scpoBill.getLong("billentry.id"), scpoBill.getBigDecimal("billentry.price"));
            }
        }
        if (pmomEntryIds.size() > 0) {
            DynamicObjectCollection pmomBills = QueryServiceHelper.query((String)"pm_om_purorderbill", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", pmomEntryIds)});
            for (DynamicObject pmomBill : pmomBills) {
                coreBillEntryPriceMap.put(pmomBill.getLong("billentry.id"), pmomBill.getBigDecimal("billentry.price"));
            }
        }
        ArrayList purToleranceParams = new ArrayList(16);
        ArrayList conmToleranceParams = new ArrayList(16);
        ArrayList scpoToleranceParams = new ArrayList(16);
        ArrayList pmomToleranceParams = new ArrayList(16);
        for (DynamicObject bill : bills) {
            Long billId = bill.getLong("id");
            if (!BillToleranceValidator.priceNeedValidate(entityName, bill)) continue;
            int precision = bill.getInt("currency.priceprecision");
            Long orgId = bill.getLong("org.id");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            Long currencyId = bill.getLong("currency.id");
            entry = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject row : entry) {
                BigDecimal billPrice;
                BigDecimal coreBillPrice;
                coreBillEntryId = row.getLong("corebillentryid");
                String coreBillType = row.getString(coreBillTypeField);
                Long materialId = row.getLong(materialField);
                if (coreBillEntryId == 0L || (coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId)) == null || (billPrice = row.getBigDecimal(priceField)).compareTo(coreBillPrice) == 0) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("bos_org", orgId);
                if ("bd_supplier".equals(asstactType)) {
                    param.put("bd_supplier", supplierMasterIds.get(asstactId));
                    param.put("bd_customer", null);
                } else {
                    param.put("bd_customer", customerMasterIds.get(asstactId));
                    param.put("bd_supplier", null);
                }
                param.put("bd_material", materialMasterIds.get(materialId));
                param.put("bd_materialgroup", materialIdToMaterialgroup.get(materialId));
                param.put("bd_currency", currencyId);
                param.put("controlvalue", billPrice);
                param.put("contrastvalue", coreBillPrice);
                param.put("precision", precision);
                String pk = billId + "_" + row.getInt("seq");
                param.put("pk", pk);
                if ("pm_purorderbill".equals(coreBillType)) {
                    purToleranceParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmToleranceParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoToleranceParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomToleranceParams.add(param);
            }
        }
        HashSet<String> overPriceToleranceIds = new HashSet<String>(16);
        ToleranceMatchService service = new ToleranceMatchService();
        if (purToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "pm_purorderbill", priceField, "price", purToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (conmToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "conm_purcontract", priceField, "price", conmToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (scpoToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "sctm_scpo", priceField, "price", scpoToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (pmomToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "pm_om_purorderbill", priceField, "price", pmomToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        HashMap<String, String> coreBillNameMap = new HashMap<String, String>(8);
        coreBillNameMap.put("pm_purorderbill", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_03", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("conm_purcontract", ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"CoreBillPriceToleranceValidator_04", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("sctm_scpo", ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_05", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("pm_om_purorderbill", ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_06", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (DynamicObject bill : bills) {
            Long billId = bill.getLong("id");
            if (!BillToleranceValidator.priceNeedValidate(entityName, bill)) continue;
            String billNo = bill.getString("billno");
            entry = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject row : entry) {
                coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillEntryId == 0L) continue;
                String pk = billId + "_" + row.getInt("seq");
                String coreBillType = row.getString(coreBillTypeField);
                BigDecimal controlPrice = row.getBigDecimal(priceField);
                BigDecimal coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                if (coreBillPrice == null) continue;
                if ("pm_purorderbill".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (noBusOrderPriceTol) {
                            if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                            errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (noFinOrderPriceTol) {
                        if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (noBusConPriceTol) {
                            if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                            errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (noFinConPriceTol) {
                        if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (noBusScpoPriceTol) {
                            if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                            errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (noFinScpoPriceTol) {
                        if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                if ("ap_busbill".equals(entityName)) {
                    if (noBusPmomPriceTol) {
                        if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                        errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if (noFinPmomPriceTol) {
                    if (controlPrice.compareTo(coreBillPrice) == 0) continue;
                    errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                    continue;
                }
                if (!overPriceToleranceIds.contains(pk)) continue;
                errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToleranceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
            }
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public static void busAmtValidator(DynamicObject[] bills) {
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (DynamicObject bill : bills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourceBillType)) continue;
            billIds.add(bill.getLong("id"));
        }
        if (billIds.size() == 0) {
            return;
        }
        ApInvoiceExcessBusValidator validator = new ApInvoiceExcessBusValidator();
        List results = validator.validate(billIds, "submit");
        ArrayList<String> errMessage = new ArrayList<String>(16);
        for (BusValidatorResult result : results) {
            String message = result.getMessage();
            errMessage.add(message);
        }
        if (errMessage.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join(errMessage, (String)"\n"));
        }
    }

    public static boolean isNeedValidator(DynamicObject bill) {
        boolean isWriteOff = bill.getBoolean("iswrittenoff");
        boolean isPremBill = bill.getBoolean("ispremium");
        boolean isTanspay = bill.getBoolean("istanspay");
        String billType = bill.getString("billtypeid.number");
        return !isWriteOff && !isPremBill && !isTanspay && !"ApFin_borr_BT_S".equals(billType);
    }

    public static boolean priceNeedValidate(String entityName, DynamicObject bill) {
        if ("ap_busbill".equals(entityName)) {
            boolean isadjust = bill.getBoolean("isadjust");
            boolean isReval = bill.getBoolean("isrevaluation");
            String expenceBillIds = ((DynamicObject)bill.getDynamicObjectCollection("entry").get(0)).getString("e_expensebillids_tag");
            boolean isExpenceBill = expenceBillIds != null && !"".equals(expenceBillIds);
            return !isadjust && !isReval && !isExpenceBill;
        }
        boolean isWriteOff = bill.getBoolean("iswrittenoff");
        boolean isPremBill = bill.getBoolean("ispremium");
        boolean isTanspay = bill.getBoolean("istanspay");
        String billType = bill.getString("billtypeid.number");
        String expenceBillIds = ((DynamicObject)bill.getDynamicObjectCollection("detailentry").get(0)).getString("e_expensebillids_tag");
        boolean isExpenceBill = expenceBillIds != null && !"".equals(expenceBillIds);
        return !isWriteOff && !isPremBill && !isTanspay && !"ApFin_borr_BT_S".equals(billType) && !isExpenceBill;
    }

    public static boolean initValidata(String number) {
        DynamicObject execcontrol = QueryServiceHelper.queryOne((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (execcontrol == null) {
            return false;
        }
        return execcontrol.getBoolean("enable");
    }
}

