/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinApBillAnti4AssignValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Boolean> orgParamMap = new HashMap<Long, Boolean>(8);
        Map<Long, DynamicObject> collectInvoiceMap = this.getCollInvoices();
        ArrayList<Long> finApBillIds = new ArrayList<Long>(32);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            finApBillIds.add(info.getLong("id"));
            DynamicObjectCollection invEntrys = info.getDynamicObjectCollection("inventry");
            String billStatus = info.getString("billstatus");
            Long orgPk = info.getDynamicObject("org").getLong("id");
            Boolean param = (Boolean)orgParamMap.get(orgPk);
            if (param == null) {
                param = SystemParameterHelper.getAPBooleanParam((long)orgPk, (String)"ap_033");
                orgParamMap.put(orgPk, param);
            }
            for (DynamicObject invRow : invEntrys) {
                String iSrcType = invRow.getString("i_srctype");
                if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) && Boolean.FALSE.equals(param) && "C".equals(billStatus)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u6307\u5b9a\u53d1\u7968\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a\u3002", (String)"FinApBillAnti4AssignOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                if (!InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue().equals(iSrcType)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u6536\u7968\u5355\u6307\u5b9a\uff0c\u8bf7\u5148\u4ece\u6536\u7968\u5355\u5904\u53d6\u6d88\u6307\u5b9a\u3002", (String)"FinApBillAnti4AssignOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
        this.collectInvToValidator(orgParamMap, collectInvoiceMap);
        Map onTheWayBillIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgParamMap.keySet(), finApBillIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            if (!onTheWayBillIdsMap.containsKey(info.getLong("id"))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"FinApBillAnti4AssignValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private void collectInvToValidator(Map<Long, Boolean> orgParamMap, Map<Long, DynamicObject> collectInvoiceMap) {
        if (collectInvoiceMap.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("org", "in", orgParamMap.keySet());
        filter.and(new QFilter("inventry.invid", "in", collectInvoiceMap.keySet()));
        filter.and(new QFilter("inventry.i_srctype", "in", (Object)InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue()));
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> assignFinApInvIds = new HashSet<Long>(16);
        for (DynamicObject finApBill : finApBills) {
            assignFinApInvIds.add(finApBill.getLong("inventry.invid"));
        }
        StringBuilder errorMessage = new StringBuilder("unsubmit".equals(this.getOperateKey()) ? ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\u3002\u7531\u4e8e\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53d1\u7968\u53f7\u7801%2$s\u7684\u6536\u7968\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FinApBillAnti4AssignValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u7531\u4e8e\u53d1\u7968\u4ee3\u7801%1$s\uff0c\u53d1\u7968\u53f7\u7801%2$s\u7684\u6536\u7968\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a", (String)"FinApBillAnti4AssignValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject apBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntrys = apBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntrys) {
                long invId = invRow.getLong("invid");
                DynamicObject collectInvoice = collectInvoiceMap.get(invId);
                if (collectInvoice != null && collectInvoice.getBoolean("isvoucher")) {
                    errorMessage.append(ResManager.loadKDString((String)"\u6536\u7968\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c", (String)"FinApBillAnti4AssignValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    this.addErrorMessage(dataEntity, String.format(errorMessage.toString(), invRow.getString("i_invoicecode"), invRow.getString("i_invoiceno")));
                    continue;
                }
                if (!InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype")) && !InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue().equals(invRow.getString("i_srctype")) || collectInvoice == null) continue;
                if (assignFinApInvIds.contains(invId)) {
                    errorMessage.append(ResManager.loadKDString((String)"\u5df2\u6307\u5b9a\u5e94\u4ed8\u4e0d\u80fd\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a", (String)"FinApBillAnti4AssignValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    this.addErrorMessage(dataEntity, String.format(errorMessage.toString(), invRow.getString("i_invoicecode"), invRow.getString("i_invoiceno")));
                    continue;
                }
                if (invRow.getBigDecimal("i_usedamt").add(collectInvoice.getBigDecimal("unrelatedamt")).compareTo(collectInvoice.getBigDecimal("pricetaxtotal")) == 0) continue;
                errorMessage.append(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5df2\u6307\u5b9a\u4e0d\u80fd\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a", (String)"FinApBillAnti4AssignValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                this.addErrorMessage(dataEntity, String.format(errorMessage.toString(), invRow.getString("i_invoicecode"), invRow.getString("i_invoiceno")));
            }
        }
    }

    private Map<Long, DynamicObject> getCollInvoices() {
        HashSet<Long> allCollectInvoiceIds = new HashSet<Long>(16);
        Set collectInvoiceSrcTypeEnums = InvoiceHelper.getCollectInvoiceSrcTypeEnums((boolean)true);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection invEntrys = info.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntrys) {
                String iSrcType = invRow.getString("i_srctype");
                if (!collectInvoiceSrcTypeEnums.contains(iSrcType)) continue;
                allCollectInvoiceIds.add(invRow.getLong("invid"));
            }
        }
        if (allCollectInvoiceIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(2);
        }
        DynamicObject[] allCollectInvoice = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,unrelatedamt,pricetaxtotal,isvoucher", (QFilter[])new QFilter[]{new QFilter("id", "in", allCollectInvoiceIds)});
        return Arrays.stream(allCollectInvoice).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
    }
}

