/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.pojo.InvoiceArticulateBillDTO;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;

public class FinApBillInvCollValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (!"submit".equals(operateKey)) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> orgIds = new HashSet<Long>(4);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            orgIds.add(bill.getLong("org.id"));
            DynamicObjectCollection invEntry = bill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            for (DynamicObject invRow : invEntry) {
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        if (!ObjectUtils.isEmpty(invoiceIds)) {
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,unrelatedamt,receivablessupp,pricetaxtotal,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
            for (DynamicObject invoice : invoices) {
                invoiceMap.put(invoice.getLong("id"), invoice);
            }
        }
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
            ArrayList<DynamicObject> invEntryList = new ArrayList<DynamicObject>(8);
            for (DynamicObject invRow : invEntries) {
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                invEntryList.add(invRow);
            }
            if (invEntryList.isEmpty()) continue;
            BigDecimal priceTaxTotal = bill.getBigDecimal("pricetaxtotal");
            BigDecimal sumInvPriceTaxTotal = BigDecimal.ZERO;
            DynamicObject asstact = bill.getDynamicObject("asstact");
            Long orgId = bill.getLong("org.id");
            for (DynamicObject invEntry : invEntryList) {
                DynamicObject config;
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invEntry.getLong("invid"));
                if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                BigDecimal unRelatedAmt = invoice == null ? invEntry.getBigDecimal("i_pricetaxtotal") : invoice.getBigDecimal("unrelatedamt");
                sumInvPriceTaxTotal = sumInvPriceTaxTotal.add(unRelatedAmt);
                String invAssName = invEntry.getString("i_asstactname");
                if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invEntry.getString("i_srctype"))) {
                    long asstactId;
                    if (invoice != null && asstact != null && (asstactId = asstact.getLong("id")) != invoice.getLong("receivablessupp")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4e0e\u6536\u7968\u5355%s\u5f80\u6765\u6237\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6539\u6210\u4e00\u81f4\u540e\u63d0\u4ea4\u3002", (String)"FinApBillInvCollValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{invEntry.getString("i_billno")}));
                    }
                    if (invoice != null && BigDecimal.ZERO.compareTo(invoice.getBigDecimal("unrelatedamt")) == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u7968\u5355%s\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u52ff\u91cd\u590d\u5360\u7528\u3002\u8bf7\u5220\u9664\u5bf9\u5e94\u53d1\u7968\u660e\u7ec6\u884c\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"FinApBillInvCollValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{invEntry.getString("i_billno")}));
                    }
                }
                if ((config = (DynamicObject)configByOrg.get(orgId)) == null || !"0".equals(config.getString("identicalpartyinvcom")) || invAssName.equals(bill.getString("asstact.name"))) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\u660e\u7ec6\u7b2c%s\u884c\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"FinApBillInvCollValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[]{invEntry.getString("seq")}));
            }
            if (BigDecimal.ZERO.compareTo(priceTaxTotal.multiply(sumInvPriceTaxTotal)) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d\u4e0e\u672a\u5173\u8054\u91d1\u989d\u5408\u8ba1\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinApBillInvCollValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            Set<Long> needDeleteInvIds = this.preArticulate(bill, invoiceMap);
            if (needDeleteInvIds.isEmpty()) continue;
            for (DynamicObject invEntry : invEntryList) {
                if (!needDeleteInvIds.contains(invEntry.getLong("invid"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5df2\u65e0\u989d\u5ea6\u5360\u7528\u6536\u7968\u5355%s\uff0c\u8bf7\u5220\u9664\u5bf9\u5e94\u53d1\u7968\u660e\u7ec6\u884c\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"FinApBillInvCollValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[]{invEntry.getString("i_billno")}));
            }
        }
    }

    private Set<Long> preArticulate(DynamicObject bill, Map<Long, DynamicObject> invoiceMap) {
        HashSet<Long> needDeleteInvIds = new HashSet<Long>(8);
        DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
        InvoiceArticulateBillDTO finApArticulateVO = new InvoiceArticulateBillDTO();
        finApArticulateVO.setCanArticulateAmt(bill.getBigDecimal("pricetaxtotal"));
        ArrayList<InvoiceArticulateBillDTO> invoiceBillVOs = new ArrayList<InvoiceArticulateBillDTO>(8);
        for (Object invRow : invEntries) {
            long l = invRow.getLong("invid");
            DynamicObject invoice = invoiceMap.get(l);
            if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
            BigDecimal unRelatedAmt = invoice == null ? invRow.getBigDecimal("i_pricetaxtotal") : invoice.getBigDecimal("unrelatedamt");
            InvoiceArticulateBillDTO invoiceBillVO = new InvoiceArticulateBillDTO();
            invoiceBillVO.setBillOriginType(invRow.getString("i_srctype")).setBillId(l).setCanArticulateAmt(unRelatedAmt).setBillNo(invRow.getString("i_billno"));
            invoiceBillVOs.add(invoiceBillVO);
        }
        invoiceBillVOs.sort(new Comparator<InvoiceArticulateBillDTO>(){

            @Override
            public int compare(InvoiceArticulateBillDTO o1, InvoiceArticulateBillDTO o2) {
                return o1.getBillNo().compareTo(o2.getBillNo());
            }
        });
        HashMap<String, List> assignInvoiceISrcTypeMap = new HashMap<String, List>(8);
        for (InvoiceArticulateBillDTO invoiceArticulateBillDTO : invoiceBillVOs) {
            String iSrcType = invoiceArticulateBillDTO.getBillOriginType();
            List sameISrcTypeInvoices = assignInvoiceISrcTypeMap.getOrDefault(iSrcType, new ArrayList(32));
            sameISrcTypeInvoices.add(invoiceArticulateBillDTO);
            assignInvoiceISrcTypeMap.put(iSrcType, sameISrcTypeInvoices);
        }
        for (Map.Entry entry : assignInvoiceISrcTypeMap.entrySet()) {
            List sameSrcTypeInvoiceVOs = (List)entry.getValue();
            ArrayList<InvoiceArticulateBillDTO> mainBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            ArrayList<InvoiceArticulateBillDTO> asstBillArticulateVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
            for (InvoiceArticulateBillDTO sameSrcTypeInvoiceVO : sameSrcTypeInvoiceVOs) {
                if (sameSrcTypeInvoiceVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                    mainBillArticulateVOs.add(sameSrcTypeInvoiceVO);
                    continue;
                }
                if (sameSrcTypeInvoiceVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                asstBillArticulateVOs.add(sameSrcTypeInvoiceVO);
            }
            this.articulate(mainBillArticulateVOs, asstBillArticulateVOs, 1893666802358029312L);
        }
        ArrayList<InvoiceArticulateBillDTO> collectMainBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
        ArrayList<InvoiceArticulateBillDTO> arrayList = new ArrayList<InvoiceArticulateBillDTO>(32);
        ArrayList<InvoiceArticulateBillDTO> othersMainBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
        ArrayList<InvoiceArticulateBillDTO> collectAsstBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
        ArrayList<InvoiceArticulateBillDTO> articulateFinApAsstBillVOs = new ArrayList<InvoiceArticulateBillDTO>(32);
        for (InvoiceArticulateBillDTO invoiceBillVO : invoiceBillVOs) {
            if (invoiceBillVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            if (InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invoiceBillVO.getBillOriginType())) {
                if (invoiceBillVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                    collectMainBillVOs.add(invoiceBillVO);
                } else {
                    collectAsstBillVOs.add(invoiceBillVO);
                }
            } else if (invoiceBillVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) > 0) {
                othersMainBillVOs.add(invoiceBillVO);
            } else {
                arrayList.add(invoiceBillVO);
            }
            if (finApArticulateVO.getCanArticulateAmt().signum() != invoiceBillVO.getCanArticulateAmt().signum()) continue;
            articulateFinApAsstBillVOs.add(invoiceBillVO);
        }
        this.articulate(collectMainBillVOs, arrayList, 1893666802358029312L);
        this.articulate(othersMainBillVOs, collectAsstBillVOs, 1893666802358029312L);
        this.articulate(Collections.singletonList(finApArticulateVO), articulateFinApAsstBillVOs, 1893667005572058112L);
        for (InvoiceArticulateBillDTO invoiceBillVO : invoiceBillVOs) {
            DynamicObject invoice;
            if (!InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(invoiceBillVO.getBillOriginType()) || (invoice = invoiceMap.get(invoiceBillVO.getBillId())) == null || invoiceBillVO.getCanArticulateAmt().compareTo(invoice.getBigDecimal("unrelatedamt")) != 0) continue;
            needDeleteInvIds.add(invoiceBillVO.getBillId());
        }
        return needDeleteInvIds;
    }

    private void articulate(List<InvoiceArticulateBillDTO> mainBillArticulateVOs, List<InvoiceArticulateBillDTO> asstBillArticulateVOs, long writeOffType) {
        if (mainBillArticulateVOs.isEmpty() || asstBillArticulateVOs.isEmpty()) {
            return;
        }
        Iterator<InvoiceArticulateBillDTO> asstIterator = asstBillArticulateVOs.iterator();
        InvoiceArticulateBillDTO nowAsstArticulateVO = asstIterator.next();
        for (InvoiceArticulateBillDTO mainBillArticulateVO : mainBillArticulateVOs) {
            BigDecimal mainArticulateAmt = mainBillArticulateVO.getCanArticulateAmt();
            while (nowAsstArticulateVO != null) {
                BigDecimal asstArticulateAmt = nowAsstArticulateVO.getCanArticulateAmt();
                if (nowAsstArticulateVO.getCanArticulateAmt().compareTo(BigDecimal.ZERO) == 0) {
                    nowAsstArticulateVO = asstIterator.hasNext() ? asstIterator.next() : null;
                    continue;
                }
                BigDecimal articulateAmt = BigDecimal.ZERO;
                if (1893666802358029312L == writeOffType) {
                    articulateAmt = mainArticulateAmt.abs().compareTo(asstArticulateAmt.abs()) >= 0 ? asstArticulateAmt.negate() : mainArticulateAmt;
                    mainArticulateAmt = mainArticulateAmt.subtract(articulateAmt);
                    asstArticulateAmt = asstArticulateAmt.add(articulateAmt);
                } else if (1893667005572058112L == writeOffType) {
                    articulateAmt = mainArticulateAmt.abs().compareTo(asstArticulateAmt.abs()) >= 0 ? asstArticulateAmt : mainArticulateAmt;
                    mainArticulateAmt = mainArticulateAmt.subtract(articulateAmt);
                    asstArticulateAmt = asstArticulateAmt.subtract(articulateAmt);
                }
                nowAsstArticulateVO.setCanArticulateAmt(asstArticulateAmt);
                if (asstArticulateAmt.compareTo(BigDecimal.ZERO) == 0) {
                    InvoiceArticulateBillDTO invoiceArticulateBillDTO = nowAsstArticulateVO = asstIterator.hasNext() ? asstIterator.next() : null;
                }
                if (mainArticulateAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            mainBillArticulateVO.setCanArticulateAmt(mainArticulateAmt);
            if (nowAsstArticulateVO != null) continue;
            break;
        }
    }
}

