/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ap.mservice.ToleranceMatchService;

public class FinApBillTaxValidator
extends AbstractValidator {
    public void validate() {
        ArrayList toleranceParams = new ArrayList(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject currency = bill.getDynamicObject("currency");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            int precision = currency.getInt("amtprecision");
            Long currencyId = currency.getLong("id");
            Long orgId = bill.getLong("org.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                BigDecimal amount = row.getBigDecimal("e_amount");
                BigDecimal taxRate = row.getBigDecimal("taxrate");
                BigDecimal tax = row.getBigDecimal("e_tax");
                BigDecimal realTax = amount.multiply(taxRate).divide(new BigDecimal("100"), precision);
                HashMap<String, Number> toleranceMap = new HashMap<String, Number>(8);
                toleranceMap.put("e_tax", tax);
                toleranceMap.put("controlvalue", tax);
                toleranceMap.put("contrastvalue", realTax);
                toleranceMap.put("bd_currency", currencyId);
                if ("bd_supplier".equals(asstactType)) {
                    toleranceMap.put("bd_supplier", asstactId);
                } else {
                    toleranceMap.put("bd_customer", asstactId);
                }
                toleranceMap.put("bd_currency", currencyId);
                toleranceMap.put("bos_org", orgId);
                toleranceMap.put("pk", row.getLong("id"));
                toleranceParams.add(toleranceMap);
            }
        }
        ToleranceMatchService service = new ToleranceMatchService();
        List result = service.getResultByToleranceType("ap_finapbill", "ap_finapbill", "e_tax", "e_tax", toleranceParams);
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        for (Map resultMap : result) {
            entryIds.add((Long)resultMap.get("pk"));
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            String billNo = bill.getString("billno");
            for (DynamicObject row : entry) {
                Long entryId = row.getLong("id");
                if (!entryIds.contains(entryId)) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u7a0e\u989d\u4e0e\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97\u7684\u7a0e\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u5173\u6ce8\u662f\u5426\u5b58\u5728\u7a0e\u52a1\u98ce\u9669\u3002", (String)"FinApBillTaxValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), bill.getString("billno"), row.getInt("seq")));
            }
        }
    }
}

