/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinApBillUnAuditPushValidator
extends AbstractValidator {
    private Map<Long, Boolean> ap002ParamMap = new HashMap<Long, Boolean>(8);

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(datas.length);
        for (ExtendedDataEntity data : datas) {
            DynamicObject finApBill = data.getDataEntity();
            billIds.add(finApBill.getLong("id"));
        }
        Map dirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)this.entityKey, (Long[])billIds.toArray(new Long[0]));
        if (dirtTargetBillMap.isEmpty()) {
            return;
        }
        Map<String, DynamicObjectCollection> batchTarBillObjMap = this.getBatchTarBillObjMap(dirtTargetBillMap);
        block1: for (ExtendedDataEntity data : datas) {
            DynamicObject finApBill = data.getDataEntity();
            long billId = finApBill.getLong("id");
            Map singleTarBillIdMap = (Map)dirtTargetBillMap.get(billId);
            if (singleTarBillIdMap == null || singleTarBillIdMap.isEmpty()) continue;
            Set singleTarBillIdMapEntries = singleTarBillIdMap.entrySet();
            for (Map.Entry singleTarBillIdMapEntry : singleTarBillIdMapEntries) {
                boolean judgeTarOther;
                boolean judgeTarFinar;
                boolean judgeTarFinap;
                Set<String> ignoreTarBillEntitys;
                String tarBillEntity = (String)singleTarBillIdMapEntry.getKey();
                Set singleTarBillIds = (Set)singleTarBillIdMapEntry.getValue();
                if (singleTarBillIds == null || singleTarBillIds.isEmpty() || (ignoreTarBillEntitys = this.getIgnoreTarBillEntitys()).contains(tarBillEntity)) continue;
                DynamicObjectCollection tarBills = batchTarBillObjMap.get(tarBillEntity);
                if (!(this.entityKey.equals(tarBillEntity) ? (judgeTarFinap = this.judgeTarFinap(data, singleTarBillIds, tarBills)) : ("ar_finarbill".equals(tarBillEntity) ? (judgeTarFinar = this.judgeTarFinar(data, singleTarBillIds, tarBills)) : (judgeTarOther = this.judgeTarOther(data, singleTarBillIds, tarBillEntity, tarBills))))) continue;
                continue block1;
            }
        }
    }

    protected boolean judgeTarOther(ExtendedDataEntity data, Set<Long> singleTarBillIds, String tarBillEntity, DynamicObjectCollection tarBills) {
        boolean judgeTarOther = false;
        for (DynamicObject otherTarBill : tarBills) {
            long otherTarBillId = otherTarBill.getLong("id");
            if (!singleTarBillIds.contains(otherTarBillId)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        return judgeTarOther;
    }

    protected boolean judgeTarFinar(ExtendedDataEntity data, Set<Long> singleTarBillIds, DynamicObjectCollection tarBills) {
        boolean judgeTarFinar = false;
        DynamicObject dataEntity = data.getDataEntity();
        long orgId = dataEntity.getLong("org.id");
        Boolean ap002 = this.ap002ParamMap.get(orgId);
        if (ap002 == null) {
            ap002 = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ap_002");
            this.ap002ParamMap.put(orgId, ap002);
        }
        for (DynamicObject tarFinArBill : tarBills) {
            DynamicObject detailEntry;
            long tarFinArBillId = tarFinArBill.getLong("id");
            String billstatus = tarFinArBill.getString("billstatus");
            if (!singleTarBillIds.contains(tarFinArBillId)) continue;
            if (ap002.booleanValue()) {
                if (!"A".equals(billstatus)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    judgeTarFinar = true;
                    break;
                }
                if (!BOTPHelper.isPush((String)"ar_finarbill", (Long)tarFinArBill.getLong("id"))) continue;
                return true;
            }
            String billType = tarFinArBill.getString("billtype.number");
            DynamicObjectCollection detailEntryColl = dataEntity.getDynamicObjectCollection("detailentry");
            boolean isPrePaid = false;
            Iterator iterator = detailEntryColl.iterator();
            while (iterator.hasNext() && !(isPrePaid = (detailEntry = (DynamicObject)iterator.next()).getBoolean("e_prepaid"))) {
            }
            if ("arfin_other_BT_S".equals(billType) && isPrePaid) {
                if ("A".equals(billstatus)) {
                    judgeTarFinar = true;
                    continue;
                }
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                break;
            }
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            judgeTarFinar = true;
            break;
        }
        return judgeTarFinar;
    }

    protected boolean judgeTarFinap(ExtendedDataEntity data, Set<Long> singleTarBillIds, DynamicObjectCollection tarBills) {
        boolean judgeTarFinap = false;
        for (DynamicObject tarFinApBill : tarBills) {
            long tarFinApBillId = tarFinApBill.getLong("id");
            if (!singleTarBillIds.contains(tarFinApBillId)) continue;
            boolean ispremium = tarFinApBill.getBoolean("ispremium");
            if (!ispremium) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                judgeTarFinap = true;
                break;
            }
            String billstatus = tarFinApBill.getString("billstatus");
            if (!"A".equals(billstatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditPushValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                judgeTarFinap = true;
                break;
            }
            boolean isPush = BOTPHelper.isPush((String)"ap_finapbill", (Long)tarFinApBill.getLong("id"));
            if (!isPush) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\uff0c\u672c\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditPushValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            judgeTarFinap = true;
            break;
        }
        return judgeTarFinap;
    }

    protected Map<String, DynamicObjectCollection> getBatchTarBillObjMap(Map<Long, Map<String, Set<Long>>> dirtTargetBillMap) {
        HashMap<String, DynamicObjectCollection> batchTarBillObjMap = new HashMap<String, DynamicObjectCollection>(8);
        HashMap<String, HashSet<Long>> batchTarBillIdMap = new HashMap<String, HashSet<Long>>(8);
        Set<Map.Entry<Long, Map<String, Set<Long>>>> dirtTargetBillMapEntries = dirtTargetBillMap.entrySet();
        for (Map.Entry<Long, Map<String, Set<Long>>> dirtTargetBillMapEntry : dirtTargetBillMapEntries) {
            Map<String, Set<Long>> singleTarBillIdMap = dirtTargetBillMapEntry.getValue();
            Set<Map.Entry<String, Set<Long>>> singleTarBillIdMapEntries = singleTarBillIdMap.entrySet();
            for (Map.Entry<String, Set<Long>> singleTarBillIdMapEntry : singleTarBillIdMapEntries) {
                String singleTarBillEntity = singleTarBillIdMapEntry.getKey();
                Set<Long> singleTarBillIds = singleTarBillIdMapEntry.getValue();
                HashSet<Long> batchTarBillIds = (HashSet<Long>)batchTarBillIdMap.get(singleTarBillEntity);
                if (batchTarBillIds == null) {
                    batchTarBillIds = new HashSet<Long>(8);
                    batchTarBillIds.addAll(singleTarBillIds);
                } else {
                    batchTarBillIds.addAll(singleTarBillIds);
                }
                batchTarBillIdMap.put(singleTarBillEntity, batchTarBillIds);
            }
        }
        Set batchTarBillIdMapEntries = batchTarBillIdMap.entrySet();
        for (Map.Entry batchTarBillIdMapEntry : batchTarBillIdMapEntries) {
            String tarBillEntity = (String)batchTarBillIdMapEntry.getKey();
            Set batchTarBillIds = (Set)batchTarBillIdMapEntry.getValue();
            if (batchTarBillIds == null) continue;
            String selector = "id,billstatus";
            if (this.entityKey.equals(tarBillEntity)) {
                selector = selector + ",ispremium";
            } else if ("ar_finarbill".equals(tarBillEntity)) {
                selector = selector + ",billtype.number";
            }
            DynamicObjectCollection batchTarBillColl = QueryServiceHelper.query((String)tarBillEntity, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)batchTarBillIds)});
            batchTarBillObjMap.put(tarBillEntity, batchTarBillColl);
        }
        return batchTarBillObjMap;
    }

    protected Set<String> getIgnoreTarBillEntitys() {
        HashSet<String> ignoreTarBillEntitys = new HashSet<String>(8);
        ignoreTarBillEntitys.add("ap_journal");
        ignoreTarBillEntitys.add("cas_paybill");
        return ignoreTarBillEntitys;
    }
}

