/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import org.apache.commons.lang.StringUtils;

public class FinApConBillValidator {
    public void validate(DynamicObject[] bills) {
        boolean validatorOpen = this.validataOpen();
        if (!validatorOpen) {
            return;
        }
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        HashSet<Long> coreBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                long conBillId;
                String coreBillType = row.getString("corebilltype");
                if (!"pm_purorderbill".equals(coreBillType)) continue;
                long coreBillId = row.getLong("corebillid");
                long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L || (conBillId = row.getLong("e_conbillid")) != 0L) continue;
                coreBillIds.add(coreBillId);
                coreBillEntryIds.add(coreBillEntryId);
            }
        }
        if (coreBillIds.size() == 0 || coreBillEntryIds.size() == 0) {
            return;
        }
        Map purBillIdToconBillIds = BOTPNewHelper.loadNearSourceBillIds((String)"pm_purorderbill", (String)"billentry", (Long[])coreBillIds.toArray(new Long[0]), (Long[])coreBillEntryIds.toArray(new Long[0]), (String)"conm_purcontract");
        if (purBillIdToconBillIds.size() == 0) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>(8);
        block2: for (DynamicObject bill : bills) {
            String billNo = bill.getString("billno");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                String coreBillType;
                String expenseBillIds = row.getString("e_expensebillids_tag");
                boolean isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
                if (isExpenseBill || !"pm_purorderbill".equals(coreBillType = row.getString("corebilltype"))) continue;
                long coreBillId = row.getLong("corebillid");
                long conBillId = row.getLong("e_conbillid");
                if (conBillId != 0L || purBillIdToconBillIds.get(coreBillId) == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u4e0a\u6e38\u5b58\u5728\u91c7\u8d2d\u5408\u540c\u65f6\uff0c\u5f53\u524d\u5355\u636e\u987b\u8bb0\u5f55\u5408\u540cID\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u670d\u52a1\u4e91>\u5355\u636e\u8f6c\u6362\u5f00\u53d1>\u8f6c\u6362\u89c4\u5219>\u5b57\u6bb5\u6620\u5c04\u201d\u68c0\u67e5\u660e\u7ec6\u884c\u201c\u5408\u540cID\u201d\u5b57\u6bb5\u6620\u5c04\u7684\u914d\u7f6e\u3002", (String)"FinApConBillValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo);
                messages.add(msg);
                continue block2;
            }
        }
        if (messages.size() > 0) {
            throw new KDBizException(StringUtils.join(messages, (String)"\n"));
        }
    }

    private boolean validataOpen() {
        DynamicObject execcontrol = QueryServiceHelper.queryOne((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0081"})});
        if (execcontrol == null) {
            return false;
        }
        return execcontrol.getBoolean("enable");
    }
}

