/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.enums.ECTxBizEnum;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApInvDeleteRowValidator
extends AbstractValidator {
    public void validate() {
        Map<String, List<String>> unFinishedTxInfoMap = this.getECUnFinishInvoiceIds();
        if (ObjectUtils.isEmpty(unFinishedTxInfoMap)) {
            return;
        }
        List ecTxEnums = InvoiceHelper.getInvoiceECTxBiz();
        Set needValidateTxs = ecTxEnums.stream().map(ECTxBizEnum::getKey).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntries = finApBill.getDynamicObjectCollection("inventry");
            block1: for (DynamicObject invEntry : invEntries) {
                String invId = invEntry.getString("invid");
                List<String> unFinishedTxs = unFinishedTxInfoMap.get(invId);
                if (ObjectUtils.isEmpty(unFinishedTxs)) continue;
                for (String unFinishedTx : unFinishedTxs) {
                    if (!needValidateTxs.contains(unFinishedTx)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\u7684\u6536\u7968\u5355\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u901a\u8fc7\u6536\u7968\u5355\u7684\u2018\u8054\u67e5-\u8054\u67e5\u4e8b\u52a1\u65e5\u5fd7\u2019\u529f\u80fd\u67e5\u770b\u5bf9\u5e94\u7684\u4fe1\u606f\u6216\u5728\u2018\u5206\u5e03\u5f0f\u7ba1\u7406-\u5206\u5e03\u5f0f\u4e8b\u52a1-\u4e8b\u52a1\u67e5\u8be2\u2019\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"FinApInvDeleteRowValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue block1;
                }
            }
        }
    }

    private Map<String, List<String>> getECUnFinishInvoiceIds() {
        HashMap<String, List<String>> unFinishedTxInfoMap = new HashMap<String, List<String>>(8);
        Map optionMap = this.getOption().getVariables();
        String invPkStr = (String)optionMap.get("invPk");
        long invPk = 0L;
        if (EmptyUtils.isNotEmpty((Object)invPkStr)) {
            invPk = Long.parseLong(invPkStr);
        }
        String pks = (String)optionMap.get("invPks");
        Set<Long> delRowIds = new HashSet(16);
        if (EmptyUtils.isNotEmpty((Object)pks)) {
            delRowIds = (Set)JSONObject.parseObject((String)pks, Set.class);
        }
        if (invPk != 0L) {
            delRowIds.add(invPk);
        }
        ArrayList<String> needValidatorInvIds = new ArrayList<String>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntries = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invEntry : invEntries) {
                long invId = invEntry.getLong("invid");
                if (!delRowIds.contains(invId) || !InvoiceSrcTypeEnum.INVOICECOLLECT.getValue().equals(invEntry.getString("i_srctype"))) continue;
                needValidatorInvIds.add(String.valueOf(invId));
            }
        }
        if (needValidatorInvIds.isEmpty()) {
            return unFinishedTxInfoMap;
        }
        Map unfinishedTxBusinessInfo = TxCheckUtil.loadUnfinishedTxBusinessInfo(needValidatorInvIds);
        if (ObjectUtils.isEmpty((Object)unfinishedTxBusinessInfo)) {
            return unFinishedTxInfoMap;
        }
        for (Map.Entry entrySet : unfinishedTxBusinessInfo.entrySet()) {
            String txBizNo = (String)entrySet.getKey();
            List billIds = (List)entrySet.getValue();
            for (String billId : billIds) {
                List txBizNos = unFinishedTxInfoMap.getOrDefault(billId, new ArrayList(8));
                txBizNos.add(txBizNo);
                unFinishedTxInfoMap.put(billId, txBizNos);
            }
        }
        return unFinishedTxInfoMap;
    }
}

