/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;

public class FinApPreiumCoreBillIdValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(4);
        selector.add("detailentry.corebillid");
        return selector;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            HashSet<Long> coreBillIds = new HashSet<Long>(8);
            BigDecimal premiumAmt = bill.getBigDecimal("premiumamt");
            if (premiumAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                coreBillIds.add(entry.getLong("corebillid"));
            }
            if (coreBillIds.size() <= 1) continue;
            String errorMessageTemplate = ResManager.loadKDString((String)"\u542b\u8d28\u4fdd\u91d1\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u4e2a\u4e0d\u540c\u7684\u6838\u5fc3\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApPreiumCoreBillIdValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
            String message = String.format(errorMessageTemplate, bill.getString("billno"));
            this.addErrorMessage(dataEntity, message);
        }
    }
}

