/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;

public class FinApPremiumValidator
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(4);
        selector.add("ispremium");
        selector.add("sourcebillid");
        selector.add("pricetaxtotal");
        selector.add("billno");
        return selector;
    }

    public void validate() {
        Map<Long, BigDecimal> sourcePremiums = this.getSourcePremiums();
        if (sourcePremiums.size() == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!bill.getBoolean("ispremium")) continue;
            Long sourceBillId = bill.getLong("sourcebillid");
            BigDecimal premium = bill.getBigDecimal("pricetaxtotal");
            BigDecimal sourcePremium = sourcePremiums.get(sourceBillId);
            if (sourcePremium.compareTo(premium) == 0) continue;
            String errorMessageTemplate = ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e%S\u5e94\u4ed8\u91d1\u989d\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u8d28\u4fdd\u91d1\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApPremiumValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
            String message = String.format(errorMessageTemplate, bill.getString("billno"));
            this.addErrorMessage(dataEntity, message);
        }
    }

    private Map<Long, BigDecimal> getSourcePremiums() {
        HashMap<Long, BigDecimal> sourcePremium = new HashMap<Long, BigDecimal>(8);
        ArrayList<Long> sourcebillids = new ArrayList<Long>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!bill.getBoolean("ispremium")) continue;
            Long sourcebillid = bill.getLong("sourcebillid");
            sourcebillids.add(sourcebillid);
        }
        if (sourcebillids.size() > 0) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"premiumamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcebillids)})) {
                sourcePremium.put(bill.getLong("id"), bill.getBigDecimal("premiumamt"));
            }
        }
        return sourcePremium;
    }
}

