/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinApSubmitPremiumValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, BigDecimal> sourcePremium = this.getSourcePremiums();
        if (sourcePremium.size() != 0) {
            this.validate(sourcePremium);
        }
    }

    private void validate(Map<Long, BigDecimal> sourcePremiums) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!bill.getBoolean("ispremium")) continue;
            Long sourceBillId = bill.getLong("sourcebillid");
            BigDecimal sourcePremium = sourcePremiums.get(sourceBillId);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entryrow : entry) {
                BigDecimal entryPremium = entryrow.getBigDecimal("e_pricetaxtotal");
                if (entryPremium.multiply(sourcePremium).compareTo(BigDecimal.ZERO) >= 0) continue;
                String errorMessageTemplate = ResManager.loadKDString((String)"\u5355\u636e%S\u660e\u7ec6\u884c\u91d1\u989d\u65b9\u5411\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u8d28\u4fdd\u91d1\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApSubmitPremiumValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                String message = String.format(errorMessageTemplate, bill.getString("billno"));
                this.addErrorMessage(dataEntity, message);
            }
        }
    }

    private Map<Long, BigDecimal> getSourcePremiums() {
        HashMap<Long, BigDecimal> sourcePremium = new HashMap<Long, BigDecimal>(64);
        ArrayList<Long> sourcebillids = new ArrayList<Long>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!bill.getBoolean("ispremium")) continue;
            Long sourcebillid = bill.getLong("sourcebillid");
            sourcebillids.add(sourcebillid);
        }
        if (sourcebillids.size() > 0) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"premiumamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcebillids)})) {
                sourcePremium.put(bill.getLong("id"), bill.getBigDecimal("premiumamt"));
            }
        }
        return sourcePremium;
    }
}

