/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinInvAmtValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        HashMap<Long, Boolean> checkInvoiceMap = new HashMap<Long, Boolean>(8);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateName = "save".equals(operateKey) ? ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"FinInvAmtValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ("audit".equals(operateKey) ? ResManager.loadKDString((String)"\u5ba1\u6838", (String)"FinInvAmtValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"FinInvAmtValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        DynamicObject[] finApBills = (DynamicObject[])Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        Map moreOccupyFinMap = InvoiceHelper.getInvoiceOtherOccupyMap((DynamicObject[])finApBills, new HashSet(2));
        Map invoiceMap = InvoiceHelper.getInvoiceMap((ExtendedDataEntity[])dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if ("save".equals(operateKey) && !bill.getBoolean("iswrittenoff")) continue;
            Long orgPk = bill.getLong("org.id");
            Boolean checkInvoiceAmount = (Boolean)checkInvoiceMap.get(orgPk);
            if (EmptyUtils.isEmpty((Object)checkInvoiceAmount)) {
                checkInvoiceAmount = SystemParameterHelper.getAPBooleanParam((long)orgPk, (String)"ap_021");
                checkInvoiceMap.put(orgPk, checkInvoiceAmount);
            }
            DynamicObjectCollection invEntrys = bill.getDynamicObjectCollection("inventry");
            ArrayList<DynamicObject> invEntryList = new ArrayList<DynamicObject>(8);
            for (DynamicObject invRow : invEntrys) {
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                if (invoice != null && "2".equals(invoice.getString("invoicestatus"))) continue;
                invEntryList.add(invRow);
            }
            if (!checkInvoiceAmount.booleanValue() || invEntryList.isEmpty()) continue;
            BigDecimal invPriceTaxTotal = BigDecimal.ZERO;
            BigDecimal invTaxToTal = BigDecimal.ZERO;
            BigDecimal invAmountTotal = BigDecimal.ZERO;
            for (DynamicObject invEntry : invEntryList) {
                invPriceTaxTotal = invPriceTaxTotal.add(invEntry.getBigDecimal("i_pricetaxtotal"));
                invTaxToTal = invTaxToTal.add(invEntry.getBigDecimal("i_tax"));
                invAmountTotal = invAmountTotal.add(invEntry.getBigDecimal("i_amount"));
            }
            if ("save".equals(operateKey) || "audit".equals(operateKey)) {
                BigDecimal headPriceTax = bill.getBigDecimal("pricetaxtotal");
                BigDecimal headAmount = bill.getBigDecimal("amount");
                BigDecimal headTax = bill.getBigDecimal("tax");
                if (headPriceTax.compareTo(invPriceTaxTotal) != 0 || headTax.compareTo(invTaxToTal) != 0 || headAmount.compareTo(invAmountTotal) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672c\u5355\u4e0e\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\u5b58\u5728\u4e0d\u76f8\u7b49\u9879\u6216\u53d1\u7968\u5df2\u88ab\u5176\u4ed6\u7684\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u4e0d\u5141\u8bb8%1$s\u3002", (String)"FinInvAmtValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), operateName));
                    continue;
                }
            }
            if (!moreOccupyFinMap.containsKey(bill.getString("billno"))) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672c\u5355\u4e0e\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\u5b58\u5728\u4e0d\u76f8\u7b49\u9879\u6216\u53d1\u7968\u5df2\u88ab\u5176\u4ed6\u7684\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u4e0d\u5141\u8bb8%1$s\u3002", (String)"FinInvAmtValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), operateName));
        }
    }
}

