/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ap.vo.MatchBillChain;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceMatchNumberValidator
extends AbstractValidator {
    public void validate() {
        MatchBillChain matchBillChain = (MatchBillChain)JSON.parseObject((String)this.getOption().getVariableValue("pagechaindata"), MatchBillChain.class);
        LinkedList chains = matchBillChain.getChains();
        Map chainMap = matchBillChain.getChainMap();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String matchType = dataEntity.getString("matchtype");
            DynamicObjectCollection invEntrys = dataEntity.getDynamicObjectCollection("entry");
            DynamicObjectCollection resultEntrys = dataEntity.getDynamicObjectCollection("resultentry");
            Map<Long, Map<String, List<DynamicObject>>> resultGroupMap = resultEntrys.stream().collect(Collectors.groupingBy(e -> e.getLong("rs_invpk"), Collectors.groupingBy(e -> e.getString("rs_entity"))));
            for (DynamicObject invEntry : invEntrys) {
                BigDecimal invUnMatchTotal = invEntry.getBigDecimal(matchType.equals("AMT") ? "unmatchamt" : "unmatchqty");
                Long invPk = invEntry.getLong("invpk");
                Map<String, List<DynamicObject>> invResultMap = resultGroupMap.get(invPk);
                int invSeq = invEntry.getInt("seq") - 1;
                if (invResultMap == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5339\u914d\u7b2c%d\u884c\u7684\u6536\u7968\u5355\u6570\u636e\u3002", (String)"InvoiceMatchNumberValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), invSeq + 1));
                }
                String invMatchRule = invEntry.getString("invmatchrule");
                int limit = chains.indexOf(chainMap.get(invMatchRule.toLowerCase())) + 1;
                List validChains = chains.stream().limit(limit).collect(Collectors.toList());
                Map<Long, Pair> tmpMap = null;
                String matchTypeKey = matchType.equals("AMT") ? "rs_amt" : "rs_qty";
                MatchBillChain.MatchChain tmpChain = null;
                for (MatchBillChain.MatchChain chain : validChains) {
                    List entityResults = invResultMap.getOrDefault(chain.getBillEntity(), new ArrayList(0));
                    String chainEntityName = MetadataServiceHelper.getDataEntityType((String)chain.getBillEntity()).getDisplayName().getLocaleValue();
                    if (entityResults.size() == 0) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\u7b2c%1$s\u884c\uff1a\u672a\u9009\u62e9%2$s\u7684\u5339\u914d\u6570\u636e\u3002", (String)"InvoiceMatchNumberValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), invSeq + 1, chainEntityName));
                        continue;
                    }
                    if (tmpMap == null) {
                        tmpMap = entityResults.stream().collect(Collectors.toMap(e -> e.getLong("rs_entryid"), e -> Pair.of((Object)e.getBigDecimal(matchTypeKey), (Object)e.getInt("rs_seq"))));
                        tmpChain = chain;
                    } else {
                        Map<Long, List<DynamicObject>> upentryPkGroup = entityResults.stream().collect(Collectors.groupingBy(e -> e.getLong("rs_upentrypk")));
                        Map<Long, BigDecimal> collect = upentryPkGroup.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((List)kv.getValue()).stream().map(e -> e.getBigDecimal(matchTypeKey)).reduce(BigDecimal.ZERO, BigDecimal::add)));
                        for (Map.Entry<Long, BigDecimal> keyVal : collect.entrySet()) {
                            Pair compare = tmpMap.get(keyVal.getKey());
                            BigDecimal compare2 = keyVal.getValue();
                            boolean flag = Objects.nonNull(compare) && Objects.nonNull(compare2) && ((BigDecimal)compare.getLeft()).compareTo(compare2) == 0;
                            if (flag || tmpChain == null) continue;
                            String compareEntity = MetadataServiceHelper.getDataEntityType((String)tmpChain.getBillEntity()).getDisplayName().getLocaleValue();
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7684\u5339\u914d\u6570\u503c\u4e0d\u7b49\u4e8e%3$s\u7684\u5339\u914d\u6570\u503c\u4e4b\u548c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceMatchNumberValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), compareEntity, compare.getRight(), chainEntityName));
                        }
                        tmpMap = entityResults.stream().collect(Collectors.toMap(e -> e.getLong("rs_entryid"), e -> Pair.of((Object)e.getBigDecimal(matchTypeKey), (Object)(e.getInt("seq") - 1))));
                        tmpChain = chain;
                    }
                    BigDecimal matchTotal = entityResults.stream().map(e -> e.getBigDecimal(matchTypeKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (invUnMatchTotal.compareTo(BigDecimal.ZERO) == 0 || matchTotal.compareTo(invUnMatchTotal) == 0) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\u7b2c%1$s\u884c\u7684\u5339\u914d\u6570\u503c\u4e0d\u7b49\u4e8e%2$s\u7684\u5339\u914d\u6570\u503c\u4e4b\u548c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceMatchNumberValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), invSeq + 1, chainEntityName));
                }
            }
        }
    }
}

