/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.ErStdConfig;

public class InvoiceSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(InvoiceSaveValidator.class);

    public void validate() {
        DynamicObject invoice;
        HashMap<String, ExtendedDataEntity> needValidatorInvoiceMap = new HashMap<String, ExtendedDataEntity>(64);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            invoice = dataEntity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            needValidatorInvoiceMap.put(invoice.getString("serialno"), dataEntity);
        }
        logger.info("InvoiceSaveValidator needValidatorInvoiceMap size :" + needValidatorInvoiceMap.size());
        if (needValidatorInvoiceMap.isEmpty()) {
            return;
        }
        DataSet invoiceDatSet = QueryServiceHelper.queryDataSet((String)"queryInvoiceIds", (String)"ap_invoice", (String)"serialno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", needValidatorInvoiceMap.keySet())}, (String)"");
        for (Row invRow : invoiceDatSet) {
            needValidatorInvoiceMap.remove(invRow.getString("serialno"));
        }
        if (needValidatorInvoiceMap.isEmpty()) {
            return;
        }
        logger.info("InvoiceSaveValidator needValidatorInvoiceMap size :" + needValidatorInvoiceMap.size());
        Set<String> hasExpenseInvSerialNos = this.getHasExpenseInvMap(needValidatorInvoiceMap.values());
        logger.info("InvoiceSaveValidator hasExpenseInvMap :" + hasExpenseInvSerialNos);
        if (ObjectUtils.isEmpty(hasExpenseInvSerialNos)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : needValidatorInvoiceMap.values()) {
            invoice = dataEntity.getDataEntity();
            if (!hasExpenseInvSerialNos.contains(invoice.getString("serialno"))) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u91cd\u590d\u62a5\u9500\uff08\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff1b\u53d1\u7968\u4ee3\u7801\uff1a%2$s\uff09\u3002", (String)"InvoiceSaveValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoice.getString("invoiceno"), invoice.getString("invoicecode")));
        }
    }

    private Set<String> getHasExpenseInvMap(Collection<ExtendedDataEntity> needValidatorInvoices) {
        logger.info("InvoiceSaveValidator getHasExpenseInvMap begin .");
        DynamicObject[] invoices = (DynamicObject[])needValidatorInvoices.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        ArrayList serialNos = new ArrayList(64);
        Map orgForSerialsMap = InvoiceHelper.getSerialMap((DynamicObject[])invoices);
        HashMap tempOrgForSerialsMap = new HashMap(64);
        for (Map.Entry entrySet : orgForSerialsMap.entrySet()) {
            tempOrgForSerialsMap.put(entrySet.getKey(), String.join((CharSequence)",", (Iterable)entrySet.getValue()));
            serialNos.addAll((Collection)entrySet.getValue());
        }
        HashSet<String> hasExpenseInvSerialNos = new HashSet<String>(64);
        if ("true".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh"))) {
            logger.info("InvoiceSaveValidator getHasExpenseInvMap serialNos is : " + serialNos);
            QFilter filter = new QFilter("serial_no", "in", serialNos);
            filter.and("status", "in", Arrays.asList("30", "60", "65", "70"));
            DataSet hasExpenseInvDataSet = QueryServiceHelper.queryDataSet((String)"queryHasExpenseInv", (String)"rim_expense_relation", (String)"serial_no", (QFilter[])new QFilter[]{filter}, (String)"");
            for (Row hasExpenseInvRow : hasExpenseInvDataSet) {
                hasExpenseInvSerialNos.add(hasExpenseInvRow.getString("serial_no"));
            }
        } else {
            logger.info("InvoiceSaveValidator getHasExpenseInvMap tempOrgForSerialsMap is :" + tempOrgForSerialsMap);
            List invoiceVOS = CallCloudHelper.queryCloudInvoice(tempOrgForSerialsMap);
            if (ObjectUtils.isEmpty((Object)invoiceVOS)) {
                return hasExpenseInvSerialNos;
            }
            for (InvoiceVO invoiceVO : invoiceVOS) {
                if ("1".equals(invoiceVO.getExpenseStatus())) continue;
                hasExpenseInvSerialNos.add(invoiceVO.getSerialNo());
            }
        }
        return hasExpenseInvSerialNos;
    }
}

