/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.opplugin.InvoiceSubmitOp;
import kd.fi.ap.piaozone.InvoiceHelper;

public class InvoiceSrcCollectValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(InvoiceSubmitOp.class);

    public void validate() {
        OperateOption option = this.getOption();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        boolean autoOp = option.containsVariable("isreffin");
        logger.info("InvoiceSrcCollectValidator isreffin is " + autoOp);
        if (autoOp) {
            return;
        }
        ArrayList<Long> finApCollectInvoiceIds = new ArrayList<Long>(64);
        ArrayList<Long> applyCollectInvoiceIds = new ArrayList<Long>(64);
        ArrayList<Long> replaceCollectInvoiceIds = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(64);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject invoice = dataEntity.getDataEntity();
            long invoiceId = invoice.getLong("id");
            String businessSource = invoice.getString("businesssource");
            if ("ap_payapply".equals(businessSource)) {
                applyCollectInvoiceIds.add(invoiceId);
            } else if ("ap_finapbill".equals(businessSource)) {
                finApCollectInvoiceIds.add(invoiceId);
            }
            replaceCollectInvoiceIds.add(invoiceId);
            orgIds.add(invoice.getLong("org.id"));
        }
        if (finApCollectInvoiceIds.isEmpty() && applyCollectInvoiceIds.isEmpty() && replaceCollectInvoiceIds.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> unOperatorInv4FinApMap = new HashMap<Long, DynamicObject>(8);
        if (!finApCollectInvoiceIds.isEmpty()) {
            Set unHandDeleteRowType = InvoiceHelper.getCollectInvoiceSrcTypeEnums((boolean)true);
            QFilter qf = new QFilter("inventry.invid", "in", finApCollectInvoiceIds);
            qf.and(new QFilter("inventry.i_srctype", "in", (Object)unHandDeleteRowType));
            qf.and(new QFilter("org", "in", orgIds));
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,inventry.invid,inventry.i_srctype", (QFilter[])new QFilter[]{qf});
            for (DynamicObject finApRow : finApBills) {
                unOperatorInv4FinApMap.put(finApRow.getLong("inventry.invid"), finApRow);
            }
        }
        HashMap<Long, DynamicObject> unOperatorInv4ApplyMap = new HashMap<Long, DynamicObject>(8);
        if (!applyCollectInvoiceIds.isEmpty()) {
            QFilter qf = new QFilter("inventry.invid", "in", applyCollectInvoiceIds);
            qf.and(new QFilter("inventry.i_srctype", "in", Arrays.asList(ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue(), ApplyInvSrcTypeEnum.ASSIGNINVOICE.getValue())));
            qf.and(new QFilter("settleorg", "in", orgIds));
            DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"billno,inventry.invid,inventry.i_srctype", (QFilter[])new QFilter[]{qf});
            for (DynamicObject apply : applyBills) {
                unOperatorInv4ApplyMap.put(apply.getLong("inventry.invid"), apply);
            }
        }
        HashMap<Long, DynamicObject> unOperatorInv4ReplaceMap = new HashMap<Long, DynamicObject>(8);
        if (!replaceCollectInvoiceIds.isEmpty()) {
            QFilter filter = new QFilter("newinventry.n_invid", "in", replaceCollectInvoiceIds);
            filter.and(new QFilter("newinventry.n_srctype", "=", (Object)ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue()));
            filter.and(new QFilter("org", "in", orgIds));
            filter.and(new QFilter("billstatus", "!=", (Object)"C"));
            DynamicObjectCollection replaceBills = QueryServiceHelper.query((String)"ap_replaceinvapply", (String)"billno,newinventry.n_invid", (QFilter[])new QFilter[]{filter});
            for (DynamicObject replace : replaceBills) {
                unOperatorInv4ReplaceMap.put(replace.getLong("newinventry.n_invid"), replace);
            }
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject replaceBill;
            DynamicObject applyBill;
            DynamicObject invoice = dataEntity.getDataEntity();
            long invoiceId = invoice.getLong("id");
            DynamicObject finApBill = (DynamicObject)unOperatorInv4FinApMap.get(invoiceId);
            if (finApBill != null) {
                String billNo = finApBill.getString("billno");
                String srcType = finApBill.getString("inventry.i_srctype");
                String srcRowTypeName = ObjectUtils.isEmpty((Object)InvoiceSrcTypeEnum.getName((String)srcType)) ? ResManager.loadKDString((String)"\u4e8c\u5f00\u6269\u5c55\u53d1\u7968\u660e\u7ec6", (String)"InvoiceSrcCollectValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]) : InvoiceSrcTypeEnum.getName((String)srcType);
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\uff08%1$s\uff09%2$s\u751f\u6210\u7684\u6536\u7968\u5355\uff0c\u65e0\u6cd5\u624b\u5de5%3$s\u3002", (String)"InvoiceSrcCollectValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, srcRowTypeName, this.getOperationName()));
            }
            if ((applyBill = (DynamicObject)unOperatorInv4ApplyMap.get(invoiceId)) != null) {
                String billNo = applyBill.getString("billno");
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355%1$s\u5173\u8054\u7684\u6536\u7968\u5355\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5%2$s\u3002", (String)"InvoiceSrcCollectValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, this.getOperationName()));
            }
            if ((replaceBill = (DynamicObject)unOperatorInv4ReplaceMap.get(invoiceId)) == null) continue;
            String billNo = replaceBill.getString("billno");
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6362\u7968\u7533\u8bf7%1$s\u5173\u8054\u7684\u6536\u7968\u5355\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5%2$s\u3002", (String)"InvoiceSrcCollectValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, this.getOperationName()));
        }
    }
}

