/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class InvoiceUnauditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ArrayList<Long> invoiceIds = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject invoice = entity.getDataEntity();
            long orgId = invoice.getLong("org.id");
            orgIds.add(orgId);
            invoiceIds.add(invoice.getLong("id"));
        }
        Map ap001Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.FALSE, new ArrayList(orgIds), (String)"ap_001");
        Map<Long, List<DynamicObject>> invToFinApMap = this.getInvToFinApMap(invoiceIds, orgIds);
        Set<Long> returnFinApIds = this.getReturnFinApIds(invToFinApMap);
        Map<Long, String> onTheWayInvMessageMap = this.invoiceOnTheWayValidate(orgIds, invoiceIds);
        block1: for (ExtendedDataEntity entity : entities) {
            boolean ap001;
            String billNos;
            List<DynamicObject> finApBills;
            DynamicObject invoice = entity.getDataEntity();
            long orgId = invoice.getLong("org.id");
            long invoiceId = invoice.getLong("id");
            if (onTheWayInvMessageMap.containsKey(invoiceId)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a%2$s", (String)"InvoiceUnauditValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoice.getString("billno"), onTheWayInvMessageMap.get(invoiceId)));
            }
            if (ObjectUtils.isEmpty(finApBills = invToFinApMap.get(invoiceId))) continue;
            ArrayList<String> invoiceAssignFinApNos = new ArrayList<String>(8);
            ArrayList<String> finApAssignInvoiceNos = new ArrayList<String>(8);
            boolean isExistUnAFinAp = false;
            for (DynamicObject finApBill : finApBills) {
                String billNo = finApBill.getString("billno");
                String iSrcType = finApBill.getString("inventry.i_srctype");
                if (InvoiceSrcTypeEnum.ASSIGNFINAPBILL.getValue().equals(iSrcType)) {
                    invoiceAssignFinApNos.add(billNo);
                } else if (InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue().equals(iSrcType) || InvoiceSrcTypeEnum.INVOICEMATCH.getValue().equals(iSrcType)) {
                    finApAssignInvoiceNos.add(billNo);
                }
                if ("A".equals(finApBill.getString("billstatus"))) continue;
                isExistUnAFinAp = true;
            }
            if (!finApAssignInvoiceNos.isEmpty()) {
                billNos = finApAssignInvoiceNos.size() > 3 ? String.join((CharSequence)"\u3001", finApAssignInvoiceNos.subList(0, 3)) : String.join((CharSequence)"\u3001", finApAssignInvoiceNos);
                if (finApAssignInvoiceNos.size() > 3) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5df2\u88ab\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%1$s\u201d\u7b49\u6307\u5b9a\uff0c\u8bf7\u5148\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\u4e2d\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceUnauditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNos));
                } else {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5df2\u88ab\u8d22\u52a1\u5e94\u4ed8\u5355\u201c%1$s\u201d\u6307\u5b9a\uff0c\u8bf7\u5148\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\u4e2d\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceUnauditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNos));
                }
            }
            if (!invoiceAssignFinApNos.isEmpty()) {
                billNos = invoiceAssignFinApNos.size() > 3 ? String.join((CharSequence)"\u3001", invoiceAssignFinApNos.subList(0, 3)) : String.join((CharSequence)"\u3001", invoiceAssignFinApNos);
                if (invoiceAssignFinApNos.size() > 3) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5df2\u6307\u5b9a\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u7b49\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceUnauditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNos));
                } else {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5df2\u6307\u5b9a\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceUnauditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNos));
                }
            }
            boolean bl = ap001 = ap001Map.get(orgId) != null && (Boolean)ap001Map.get(orgId) != false;
            if (ap001 && isExistUnAFinAp) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e0b\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\u3002", (String)"InvoiceUnauditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject finBill : finApBills) {
                if (!ap001 || !"A".equals(finBill.getString("billstatus")) || !returnFinApIds.contains(finBill.getLong("id"))) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e0b\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u6ee1\u8db3\u5220\u9664\u6761\u4ef6\u3002", (String)"InvoiceUnauditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                break;
            }
            for (DynamicObject finApRow : finApBills) {
                if (ap001 || !InvoiceSrcTypeEnum.BYINVOICE.getValue().equals(finApRow.getString("inventry.i_srctype"))) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4e0b\u6e38\u6709\u5e94\u4ed8\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"InvoiceUnauditValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue block1;
            }
        }
    }

    private Map<Long, String> invoiceOnTheWayValidate(Set<Long> orgIds, List<Long> billIds) {
        Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, billIds);
        HashMap<Long, String> onTheWayInvMessageMap = new HashMap<Long, String>(8);
        if (onTheWayInvoiceIdsMap.isEmpty()) {
            return onTheWayInvMessageMap;
        }
        ArrayList allReplaceIds = new ArrayList(32);
        for (Map.Entry entrySet : onTheWayInvoiceIdsMap.entrySet()) {
            allReplaceIds.addAll((Collection)entrySet.getValue());
        }
        DynamicObjectCollection replaceBills = QueryServiceHelper.query((String)"ap_replaceinvapply", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", allReplaceIds)});
        HashMap<Long, String> replaceBillNoMap = new HashMap<Long, String>(32);
        for (DynamicObject replaceBill : replaceBills) {
            replaceBillNoMap.put(replaceBill.getLong("id"), replaceBill.getString("billno"));
        }
        for (Map.Entry entrySet : onTheWayInvoiceIdsMap.entrySet()) {
            Long invoiceId = (Long)entrySet.getKey();
            Set replaceIds = (Set)entrySet.getValue();
            ArrayList replaceBillNos = new ArrayList(8);
            for (Long replaceId : replaceIds) {
                replaceBillNos.add(replaceBillNoMap.get(replaceId));
            }
            onTheWayInvMessageMap.put(invoiceId, String.format(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u672a\u5ba1\u6838\u7684\u6362\u7968\u7533\u8bf7\uff08%1$s\uff09\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u7533\u8bf7\u540e\u91cd\u8bd5\u3002", (String)"InvoiceUnauditValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", replaceBillNos)));
        }
        return onTheWayInvMessageMap;
    }

    private Set<Long> getReturnFinApIds(Map<Long, List<DynamicObject>> invToFinApMap) {
        if (ObjectUtils.isEmpty(invToFinApMap)) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> allFinApBillIds = new HashSet<Long>(64);
        for (Map.Entry<Long, List<DynamicObject>> entrySet : invToFinApMap.entrySet()) {
            List<DynamicObject> finApBills = entrySet.getValue();
            for (DynamicObject finApBill : finApBills) {
                if (!"A".equals(finApBill.getString("billstatus"))) continue;
                allFinApBillIds.add(finApBill.getLong("id"));
            }
        }
        if (ObjectUtils.isEmpty(allFinApBillIds)) {
            return new HashSet<Long>(2);
        }
        Map targetBillIdMap = BOTPHelper.findDirtTargetBillIds((String)"ap_finapbill", (Long[])allFinApBillIds.toArray(new Long[0]), (String)"cas_paybill", (String)"cas_paybill");
        return targetBillIdMap.keySet();
    }

    private Map<Long, List<DynamicObject>> getInvToFinApMap(List<Long> invoiceIds, Set<Long> orgIds) {
        HashMap<Long, List<DynamicObject>> invToFinApMap = new HashMap<Long, List<DynamicObject>>(64);
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and(new QFilter("inventry.invid", "in", invoiceIds));
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billstatus,billno,inventry.invid,inventry.i_srctype", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)finApBills)) {
            return invToFinApMap;
        }
        for (DynamicObject finApBill : finApBills) {
            long invId = finApBill.getLong("inventry.invid");
            List finApList = invToFinApMap.getOrDefault(invId, new ArrayList(8));
            finApList.add(finApBill);
            invToFinApMap.put(invId, finApList);
        }
        return invToFinApMap;
    }
}

