/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ArrayUtils;

public class InvoiceUnsubmitValidator4Match
extends AbstractValidator {
    public void validate() {
        QFilter qFilter;
        DynamicObject[] matchRecords;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Object[] invoiceBillPks = (Long[])Stream.of(dataEntities).map(inv -> (Long)inv.getBillPkId()).toArray(Long[]::new);
        Map<Long, ExtendedDataEntity> billMap = Stream.of(dataEntities).collect(Collectors.toMap(inv -> (Long)inv.getBillPkId(), bill -> bill));
        if (ArrayUtils.isNotEmpty((Object[])invoiceBillPks) && (matchRecords = BusinessDataServiceHelper.load((String)"invoice_match_record", (String)"invoicebill,matchentry.apbillid", (QFilter[])(qFilter = new QFilter("invoicebill", "in", (Object)invoiceBillPks)).toArray())).length > 0) {
            HashSet apBillPks;
            HashMap relationMap = new HashMap(64);
            for (DynamicObject matchRecord : matchRecords) {
                apBillPks = matchRecord.getDynamicObjectCollection("matchentry").stream().map(entry -> entry.getLong("apbillid")).collect(Collectors.toSet());
                apBillPks.remove(0L);
                Long invoicePk = matchRecord.getLong("invoicebill");
                HashSet orDefault = relationMap.getOrDefault(invoicePk, new HashSet(0));
                orDefault.addAll(apBillPks);
                relationMap.put(invoicePk, orDefault);
            }
            DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter("id", "in", (Object)relationMap.values().stream().flatMap(Collection::stream).distinct().toArray()).toArray());
            Map<Long, String> apBillMap = apBills.stream().collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill.getString("billno")));
            for (Map.Entry keyVal : relationMap.entrySet()) {
                apBillPks = (HashSet)keyVal.getValue();
                ExtendedDataEntity extendedDataEntity = billMap.get(keyVal.getKey());
                String apBillNos = apBillPks.stream().map(apBillMap::get).collect(Collectors.joining(","));
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6536\u7968\u5339\u914d\u751f\u6210\u7684\u5e94\u4ed8\u5355\uff08%s\uff09\u3002", (String)"InvoiceUnsubmitValidator4Match_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), apBillNos));
            }
        }
    }
}

