/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.ApplyInvSrcTypeEnum;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.StringUtils;

public class PayApplyInvoiceValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PayApplyInvoiceValidator.class);

    public void validate() {
        Object[] datas = this.dataEntities;
        if (ObjectUtils.isEmpty((Object[])(datas = (ExtendedDataEntity[])Arrays.stream(datas).filter(entity -> entity.getDataEntity().getBoolean("isprepayinvoice")).toArray(ExtendedDataEntity[]::new)))) {
            return;
        }
        Map<Long, DynamicObject> inDbInvoiceMap = this.getInDbInvoiceMap((ExtendedDataEntity[])datas);
        Map<String, InvoiceVO> InvoiceVOMap = this.getCloudInvoiceMap((ExtendedDataEntity[])datas, inDbInvoiceMap);
        ArrayList<ExtendedDataEntity> needToleranceBills = new ArrayList<ExtendedDataEntity>(16);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (Object dataEntity : datas) {
            String sourceBillType;
            DynamicObject applyBill = dataEntity.getDataEntity();
            orgIds.add(applyBill.getLong("applyorg.id"));
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            boolean isExistNoPrePay = false;
            HashSet<String> asstactTypes = new HashSet<String>(4);
            HashSet<Long> asstactIds = new HashSet<Long>(4);
            BigDecimal e_approvedseleamt = BigDecimal.ZERO;
            for (DynamicObject applyRow : entry) {
                if ("202".equals(applyRow.getString("e_paymenttype.biztype"))) {
                    e_approvedseleamt = e_approvedseleamt.add(applyRow.getBigDecimal("e_approvedseleamt"));
                } else {
                    isExistNoPrePay = true;
                }
                asstactTypes.add(applyRow.getString("e_asstacttype"));
                asstactIds.add(applyRow.getLong("e_asstact.masterid"));
            }
            if (isExistNoPrePay) {
                this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u201c\u5230\u7968\u9884\u4ed8\u201d\u6253\u5f00\u65f6\uff0c\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u5fc5\u987b\u90fd\u4e3a\u9884\u4ed8\u6b3e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyInvoiceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (invEntry.isEmpty()) {
                this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u201c\u5230\u7968\u9884\u4ed8\u201d\u6253\u5f00\u65f6\uff0c\u53d1\u7968\u660e\u7ec6\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u91c7\u96c6\u6216\u6307\u5b9a\u53d1\u7968\u540e\u91cd\u8bd5\u3002", (String)"PayApplyInvoiceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if ("ar_finarbill".equals(sourceBillType = applyBill.getString("sourcebilltype")) || "ap_finapbill".equals(sourceBillType)) {
                String sourceBillName = "ap_finapbill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"PayApplyInvoiceValidator_13", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355", (String)"PayApplyInvoiceValidator_14", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u901a\u8fc7%1$s\u4e0b\u63a8\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u5230\u7968\u9884\u4ed8\u201d\uff0c\u8bf7\u5173\u95ed\u540e\u91cd\u8bd5\u3002", (String)"PayApplyInvoiceValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), sourceBillName));
            }
            if (asstactTypes.size() != 1 || asstactIds.size() != 1) {
                String asstacCaption = "ap_payapply_BT_S".equals(applyBill.getString("billtype.number")) ? ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546", (String)"PayApplyInvoiceValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"PayApplyInvoiceValidator_12", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5230\u7968\u9884\u4ed8\u201d\u6253\u5f00\u65f6\uff0c\u660e\u7ec6\u884c\u7684\u5f80\u6765\u7c7b\u578b\u4e0e%1$s\u5fc5\u987b\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyInvoiceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), asstacCaption));
            }
            BigDecimal aprseleAmount = applyBill.getBigDecimal("aprseleamount");
            HashSet<String> amtDirectionStrs = new HashSet<String>(4);
            HashSet<String> otherOccupyInvBillNos = new HashSet<String>(4);
            HashSet<String> hasMatchInvBillNos = new HashSet<String>(4);
            for (DynamicObject invRow : invEntry) {
                BigDecimal priceTaxTotal;
                DynamicObject invoice = inDbInvoiceMap.get(invRow.getLong("invid"));
                InvoiceVO invoiceVO = InvoiceVOMap.get(invRow.getString("i_serialno"));
                if (invoice == null && invoiceVO == null) continue;
                String invoiceNo = invoice == null ? invoiceVO.getInvoiceNo() : invoice.getString("invoiceno");
                String invoiceCode = invoice == null ? invoiceVO.getInvoiceCode() : invoice.getString("invoicecode");
                BigDecimal bigDecimal = priceTaxTotal = invoice == null ? invoiceVO.getTotalAmount() : invoice.getBigDecimal("pricetaxtotal");
                if (priceTaxTotal.multiply(aprseleAmount).compareTo(BigDecimal.ZERO) < 0) {
                    String message = null;
                    message = ObjectUtils.isEmpty((Object)invoiceNo) && ObjectUtils.isEmpty((Object)invoiceCode) && invoice != null ? String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355%1$s", (String)"PayApplyInvoiceValidator_16", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoice.getString("billno")) : this.spiltCodeAndNoStr(invoiceNo, invoiceCode);
                    if (message == null || amtDirectionStrs.size() >= 3) continue;
                    amtDirectionStrs.add(message);
                    continue;
                }
                if (invoice != null && priceTaxTotal.compareTo(invoice.getBigDecimal("unrelatedamt")) != 0) {
                    if (otherOccupyInvBillNos.size() >= 3) continue;
                    otherOccupyInvBillNos.add(invoice.getString("billno"));
                    continue;
                }
                if (invoice == null || !invoice.getBoolean("ismatched") || hasMatchInvBillNos.size() >= 3) continue;
                hasMatchInvBillNos.add(invoice.getString("billno"));
            }
            if (!amtDirectionStrs.isEmpty()) {
                String message = String.join((CharSequence)"\uff1b", amtDirectionStrs);
                if (amtDirectionStrs.size() == 3) {
                    this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u51c6\u91d1\u989d\u4e0e%1$s\u7b49\u4ef7\u7a0e\u5408\u8ba1\u7684\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyInvoiceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), message));
                } else {
                    this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u6838\u51c6\u91d1\u989d\u4e0e%1$s\u4ef7\u7a0e\u5408\u8ba1\u7684\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayApplyInvoiceValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]), message));
                }
            }
            if (!otherOccupyInvBillNos.isEmpty()) {
                this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355%1$s\u5df2\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u5173\u8054\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u9884\u4ed8\u6b3e\u53d1\u7968\uff0c\u8bf7\u53d6\u6d88\u4e0e\u5e94\u4ed8\u7684\u5173\u8054\u540e\u91cd\u8bd5\u3002", (String)"PayApplyInvoiceValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", otherOccupyInvBillNos)));
            }
            if (!hasMatchInvBillNos.isEmpty()) {
                this.addMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355%1$s\u5df2\u8fdb\u884c\u53d1\u7968\u5339\u914d\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u9884\u4ed8\u6b3e\u53d1\u7968\uff0c\u8bf7\u53d6\u6d88\u5339\u914d\u540e\u91cd\u8bd5\u3002", (String)"PayApplyInvoiceValidator_15", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", hasMatchInvBillNos)));
            }
            if (isExistNoPrePay || invEntry.isEmpty()) continue;
            needToleranceBills.add((ExtendedDataEntity)dataEntity);
        }
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        for (Object dataEntity : datas) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            Long orgId = applyBill.getLong("applyorg.id");
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            if (config == null || !"0".equals(config.getString("identicalpartyinvcom"))) continue;
            DynamicObjectCollection invEntrys = applyBill.getDynamicObjectCollection("inventry");
            DynamicObjectCollection entrys = applyBill.getDynamicObjectCollection("entry");
            block4: for (DynamicObject invEntry : invEntrys) {
                String invAsstName = invEntry.getString("i_asstactname");
                if (StringUtils.isEmpty((String)invAsstName)) {
                    DynamicObject invoice = inDbInvoiceMap.get(invEntry.getLong("invid"));
                    invAsstName = invoice.getString("asstactname");
                }
                for (DynamicObject entry : entrys) {
                    String asstactName = entry.getString("e_asstact.name");
                    if (asstactName.equals(invAsstName)) continue;
                    this.addMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\u660e\u7ec6\u7b2c%1$s\u884c\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PayApplyInvoiceValidator_17", (String)"fi-ap-opplugin", (Object[])new Object[]{invEntry.getString("seq")}));
                    continue block4;
                }
            }
        }
        this.doToleranceValidator(needToleranceBills, inDbInvoiceMap, InvoiceVOMap);
    }

    private void doToleranceValidator(List<ExtendedDataEntity> needToleranceBills, Map<Long, DynamicObject> inDbInvoiceMap, Map<String, InvoiceVO> InvoiceVOMap) {
        if (needToleranceBills.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(32);
        for (ExtendedDataEntity dataEntity : needToleranceBills) {
            Object invRow2;
            DynamicObject applyBill = dataEntity.getDataEntity();
            BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (Object invRow2 : invEntry) {
                DynamicObject invoice = inDbInvoiceMap.get(invRow2.getLong("invid"));
                InvoiceVO invoiceVO = InvoiceVOMap.get(invRow2.getString("i_serialno"));
                if (invoice != null) {
                    if ("2".equals(invoice.getString("invoicestatus"))) continue;
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("pricetaxtotal"));
                    continue;
                }
                if (invoiceVO == null || "2".equals(invoiceVO.getInvoiceStatus())) continue;
                invoiceTotalAmount = invoiceTotalAmount.add(invoiceVO.getTotalAmount());
            }
            BigDecimal e_approvedseleamt = BigDecimal.ZERO;
            invRow2 = entry.iterator();
            while (invRow2.hasNext()) {
                DynamicObject applyRow = (DynamicObject)invRow2.next();
                if (!"202".equals(applyRow.getString("e_paymenttype.biztype"))) continue;
                e_approvedseleamt = e_approvedseleamt.add(applyRow.getBigDecimal("e_approvedseleamt"));
            }
            String eAsstactType = ((DynamicObject)entry.get(0)).getString("e_asstacttype");
            Long asstactMasterId = ((DynamicObject)entry.get(0)).getLong("e_asstact.masterid");
            HashMap<String, Number> toleranceParamMap = new HashMap<String, Number>(8);
            toleranceParamMap.put("controlvalue", e_approvedseleamt);
            toleranceParamMap.put("contrastvalue", invoiceTotalAmount);
            toleranceParamMap.put("precision", applyBill.getInt("settlecurrency.amtprecision"));
            toleranceParamMap.put("pk", applyBill.getLong("id"));
            toleranceParamMap.put("bos_org", applyBill.getLong("settleorg.id"));
            if ("bd_supplier".equals(eAsstactType)) {
                toleranceParamMap.put("bd_supplier", asstactMasterId);
                toleranceParamMap.put("bd_customer", 0L);
                toleranceParamMap.put("bd_material", 0L);
            } else if ("bd_customer".equals(eAsstactType)) {
                toleranceParamMap.put("bd_supplier", 0L);
                toleranceParamMap.put("bd_customer", asstactMasterId);
                toleranceParamMap.put("bd_material", 0L);
            } else {
                toleranceParamMap.put("bd_supplier", 0L);
                toleranceParamMap.put("bd_customer", 0L);
                toleranceParamMap.put("bd_material", 0L);
            }
            toleranceParamMap.put("bd_currency", applyBill.getLong("settlecurrency.id"));
            toleranceParamMap.put("bd_materialgroup", 0L);
            params.add(toleranceParamMap);
        }
        if (params.isEmpty()) {
            return;
        }
        Set<String> canMatchDim = this.canMatchDim(params);
        logger.info("PayApplyInvoiceValidator validate params is :" + params);
        ToleranceMatchService toleranceMatchService = new ToleranceMatchService();
        List resultByToleranceType = toleranceMatchService.getResultByToleranceType("ap_payapply", "ap_invoice", "e_approvedseleamt", "pricetaxtotal", params);
        logger.info("PayApplyInvoiceValidator validate resultByToleranceType is :" + resultByToleranceType);
        Set<Object> overBillIds = new HashSet(8);
        if (!ObjectUtils.isEmpty((Object)resultByToleranceType)) {
            overBillIds = resultByToleranceType.stream().map(m -> m.get("pk")).collect(Collectors.toSet());
        }
        for (ExtendedDataEntity dataEntity : needToleranceBills) {
            Object invRow3;
            DynamicObject applyBill = dataEntity.getDataEntity();
            BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (Object invRow3 : invEntry) {
                DynamicObject invoice = inDbInvoiceMap.get(invRow3.getLong("invid"));
                InvoiceVO invoiceVO = InvoiceVOMap.get(invRow3.getString("i_serialno"));
                if (invoice != null) {
                    if ("2".equals(invoice.getString("invoicestatus"))) continue;
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("pricetaxtotal"));
                    continue;
                }
                if (invoiceVO == null || "2".equals(invoiceVO.getInvoiceStatus())) continue;
                invoiceTotalAmount = invoiceTotalAmount.add(invoiceVO.getTotalAmount());
            }
            BigDecimal e_approvedseleamt = BigDecimal.ZERO;
            invRow3 = entry.iterator();
            while (invRow3.hasNext()) {
                DynamicObject applyRow = (DynamicObject)invRow3.next();
                if (!"202".equals(applyRow.getString("e_paymenttype.biztype"))) continue;
                e_approvedseleamt = e_approvedseleamt.add(applyRow.getBigDecimal("e_approvedseleamt"));
            }
            long billId = applyBill.getLong("id");
            if (canMatchDim.contains(String.valueOf(billId)) && overBillIds.contains(billId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u9884\u4ed8\u53d1\u7968\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayApplyInvoiceValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (canMatchDim.contains(String.valueOf(billId)) || e_approvedseleamt.compareTo(invoiceTotalAmount) == 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u9884\u4ed8\u53d1\u7968\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayApplyInvoiceValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private String spiltCodeAndNoStr(String invoiceNo, String invoiceCode) {
        StringBuilder message = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)invoiceNo)) {
            message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s", (String)"PayApplyInvoiceValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceNo));
        }
        if (!ObjectUtils.isEmpty((Object)invoiceCode)) {
            if (message.length() != 0) {
                message.append("\u3001");
            }
            message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s", (String)"PayApplyInvoiceValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceCode));
        }
        return message.length() == 0 ? null : message.toString();
    }

    private Map<Long, DynamicObject> getInDbInvoiceMap(ExtendedDataEntity[] datas) {
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,pricetaxtotal,unrelatedamt,serialno,invoiceno,invoicecode,billno,ismatched,invoicestatus,asstactname", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        HashMap<Long, DynamicObject> inDbInvoiceMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            inDbInvoiceMap.put(invoice.getLong("id"), invoice);
        }
        return inDbInvoiceMap;
    }

    private Map<String, InvoiceVO> getCloudInvoiceMap(ExtendedDataEntity[] datas, Map<Long, DynamicObject> inDbInvoiceMap) {
        HashSet<String> hasInDbSerials = new HashSet<String>(8);
        for (Map.Entry<Long, DynamicObject> entry : inDbInvoiceMap.entrySet()) {
            DynamicObject invoice = entry.getValue();
            String serialNo = invoice.getString("serialno");
            if (ObjectUtils.isEmpty((Object)serialNo)) continue;
            hasInDbSerials.add(serialNo);
        }
        HashMap<Long, Set> orgForSerialNosMap = new HashMap<Long, Set>(8);
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject applyBill = dataEntity.getDataEntity();
            long orgId = applyBill.getLong("settleorg.id");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                String serialNo = invRow.getString("i_serialno");
                if (!ApplyInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(invRow.getString("i_srctype")) || hasInDbSerials.contains(serialNo)) continue;
                Set serialNos = orgForSerialNosMap.getOrDefault(orgId, new HashSet(8));
                serialNos.add(serialNo);
                orgForSerialNosMap.put(orgId, serialNos);
            }
        }
        HashMap<String, InvoiceVO> hashMap = new HashMap<String, InvoiceVO>(8);
        if (!orgForSerialNosMap.isEmpty()) {
            HashMap orgForSerialMap = new HashMap(64);
            for (Map.Entry entrySet : orgForSerialNosMap.entrySet()) {
                orgForSerialMap.put(entrySet.getKey(), String.join((CharSequence)",", (Iterable)entrySet.getValue()));
            }
            List invoiceVOS = CallCloudHelper.queryCloudInvoice(orgForSerialMap);
            for (InvoiceVO invoiceVO : invoiceVOS) {
                hashMap.put(invoiceVO.getSerialNo(), invoiceVO);
            }
        }
        return hashMap;
    }

    private Set<String> canMatchDim(List<Map<String, Object>> params) {
        HashSet<String> result = new HashSet<String>(16);
        if (params.size() == 0) {
            return result;
        }
        DynamicObject toleranceType = BusinessDataServiceHelper.loadSingle((String)"ap_tolerancetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)"ap_payapply"), new QFilter("contraster", "=", (Object)"ap_invoice"), new QFilter("controlitem", "=", (Object)"e_approvedseleamt"), new QFilter("contrastitem", "=", (Object)"pricetaxtotal"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceType == null) {
            return result;
        }
        Long toleranceTypeId = toleranceType.getLong("id");
        DynamicObject toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)"ap_payapply"), new QFilter("contraster", "=", (Object)"ap_invoice"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceScheme == null) {
            return result;
        }
        DynamicObjectCollection entry = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Long rowToleranceTypeId = row.getDynamicObject("e_tolerancetypeid").getLong("id");
            if (!toleranceTypeId.equals(rowToleranceTypeId)) continue;
            this.match(row, params, result);
            break;
        }
        return result;
    }

    private void match(DynamicObject row, List<Map<String, Object>> params, Set<String> result) {
        String toleranceDim = row.getString("e_tolerancedim");
        String dimensionMap = row.getString("e_dimensionmap");
        String[] toleranceDims = new String[]{};
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        if (toleranceDim != null && !"".equals(toleranceDim)) {
            toleranceDims = toleranceDim.substring(1).split(",");
            HashMap<String, ArrayList<Map<String, Object>>> paramGroupByDim = new HashMap<String, ArrayList<Map<String, Object>>>(16);
            for (Map<String, Object> param : params) {
                StringBuilder matchKey = null;
                for (String dim : toleranceDims) {
                    if (!param.containsKey(dim)) {
                        matchKey = null;
                        break;
                    }
                    Object object = param.get(dim);
                    if (object == null || "".equals(object)) {
                        if (matchKey == null) {
                            matchKey = new StringBuilder("null");
                            continue;
                        }
                        matchKey.append('_').append("null");
                        continue;
                    }
                    if (object instanceof List) {
                        List dimList = (List)object;
                        List dimStrList = dimList.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
                        if (matchKey == null) {
                            matchKey = new StringBuilder(String.join((CharSequence)"_", dimStrList));
                            continue;
                        }
                        matchKey.append('_').append(String.valueOf(object));
                        continue;
                    }
                    if (matchKey == null) {
                        matchKey = new StringBuilder(String.valueOf(param.get(dim)));
                        continue;
                    }
                    matchKey.append('_').append(String.valueOf(param.get(dim)));
                }
                if (matchKey == null) continue;
                ArrayList<Map<String, Object>> paramList = (ArrayList<Map<String, Object>>)paramGroupByDim.get(matchKey.toString());
                if (paramList == null) {
                    paramList = new ArrayList<Map<String, Object>>(16);
                    paramList.add(param);
                    paramGroupByDim.put(matchKey.toString(), paramList);
                    continue;
                }
                paramList.add(param);
            }
            ArrayList tolerances = new ArrayList(16);
            Map toleranceDimMap = (Map)SerializationUtils.fromJsonString((String)dimensionMap, Map.class);
            for (DynamicObject entry : subEntry) {
                HashMap rowTolerance = new HashMap(16);
                for (Map.Entry entrySet : toleranceDimMap.entrySet()) {
                    if (!((String)entrySet.getValue()).endsWith("_pk")) continue;
                    String string = ((String)entrySet.getValue()).substring(0, ((String)entrySet.getValue()).length() - 3);
                    String dimensionValues = entry.getString((String)entrySet.getKey());
                    List dimensionPkList = Stream.of(dimensionValues.split(",")).collect(Collectors.toList());
                    HashMap<Long, String> dimensionPkLongList = new HashMap<Long, String>(8);
                    for (String pk : dimensionPkList) {
                        if ("".equals(pk)) continue;
                        dimensionPkLongList.put(Long.valueOf(pk), pk);
                    }
                    rowTolerance.put(string, dimensionPkLongList);
                }
                tolerances.add(rowTolerance);
            }
            block5: for (Map.Entry entrySet : paramGroupByDim.entrySet()) {
                List value = (List)entrySet.getValue();
                Map firstParam = (Map)value.get(0);
                for (Map map : tolerances) {
                    boolean isMatch = true;
                    for (String dim : toleranceDims) {
                        Object dimValues = firstParam.get(dim);
                        Map dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            List values = (List)dimValues;
                            boolean isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)firstParam.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    for (Map param : value) {
                        result.add(String.valueOf(param.get("pk")));
                    }
                    continue block5;
                }
            }
        } else {
            for (Map<String, Object> param : params) {
                result.add(String.valueOf(param.get("pk")));
            }
        }
    }
}

