/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.SupplierBalanceQueryService;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;

public class PayApplySupplierBalanceCtrlService
implements IExecCtrlService<Object> {
    public <T> T execute(Object ... param) {
        if (param == null || param.length == 0) {
            return null;
        }
        DynamicObject[] bills = (DynamicObject[])param;
        return (T)this.doValidator(bills);
    }

    private List<String> doValidator(DynamicObject[] bills) {
        ArrayList<String> result = new ArrayList<String>(16);
        ArrayList params = new ArrayList(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> asstactIds = new HashSet<Long>(16);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(16);
        HashMap<String, String> supplierName = new HashMap<String, String>(16);
        HashMap<String, BigDecimal> supplierUnPaidAmtMap = new HashMap<String, BigDecimal>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashMap<Long, Long> supplierId2MasterIds = new HashMap<Long, Long>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Object asstactType;
                String payType = row.getString("e_paymenttype.biztype");
                if ("202".equals(payType) || !"bd_supplier".equals(asstactType = row.getString("e_asstacttype"))) continue;
                Long asstactId = row.getLong("e_asstact.id");
                asstactIds.add(asstactId);
            }
        }
        if (asstactIds.size() == 0) {
            return null;
        }
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (DynamicObject supplier : suppliers) {
            supplierId2MasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
        }
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
            Long orgId = bill.getLong("settleorg.id");
            Long currencyId = bill.getLong("settlecurrency.id");
            orgIds.add(orgId);
            orgNameMap.put(orgId, bill.getString("settleorg.name"));
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String asstactType;
                String payType = row.getString("e_paymenttype.biztype");
                if ("202".equals(payType) || !"bd_supplier".equals(asstactType = row.getString("e_asstacttype"))) continue;
                Long asstactId = row.getLong("e_asstact.id");
                Long masterId = supplierId2MasterIds.getOrDefault(asstactId, asstactId);
                String asstStr = orgId + "_" + masterId;
                supplierName.put(asstStr, row.getString("e_asstact.name"));
                String key = orgId + "_" + masterId + "_" + currencyId;
                BigDecimal upPaidAmt = row.getBigDecimal("e_approvedamt");
                BigDecimal sumUnPaidAmt = (BigDecimal)supplierUnPaidAmtMap.get(key);
                if (sumUnPaidAmt == null) {
                    supplierUnPaidAmtMap.put(key, upPaidAmt);
                    HashMap<String, Long> param = new HashMap<String, Long>(16);
                    param.put("org", orgId);
                    param.put("asstact", masterId);
                    param.put("currency", currencyId);
                    params.add(param);
                    continue;
                }
                supplierUnPaidAmtMap.put(key, sumUnPaidAmt.add(upPaidAmt));
            }
        }
        if (supplierUnPaidAmtMap.size() == 0) {
            return null;
        }
        this.getSupplierUnPaidAmt(orgIds, asstactIds, supplierId2MasterIds, supplierUnPaidAmtMap, billIds);
        SupplierBalanceQueryService service = new SupplierBalanceQueryService();
        List supplierBalance = service.queryBalance(params);
        for (Map map : supplierBalance) {
            BigDecimal dif;
            String asstStr;
            String asstName;
            String key = map.get("org") + "_" + map.get("asstact") + "_" + map.get("currency");
            BigDecimal unPaidAmt = (BigDecimal)supplierUnPaidAmtMap.get(key);
            if (unPaidAmt == null || (asstName = (String)supplierName.get(asstStr = map.get("org") + "_" + map.get("asstact"))) == null || (dif = unPaidAmt.subtract((BigDecimal)map.get("balanceamt"))).compareTo(BigDecimal.ZERO) <= 0) continue;
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u4f9b\u5e94\u5546\uff1a%2$s\uff0c\u5c06\u8d85\u989d %3$s", (String)"PayApplySupplierBalanceSubmitValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), orgNameMap.get(map.get("org")), asstName, dif);
            result.add(message);
        }
        return result;
    }

    private void getSupplierUnPaidAmt(Set<Long> orgIds, Set<Long> asstactIds, Map<Long, Long> supplierId2MasterIds, Map<String, BigDecimal> supplierUnPaidAmtMap, Set<Long> billIds) {
        for (Map.Entry<Long, Long> entrySet : supplierId2MasterIds.entrySet()) {
            asstactIds.add(entrySet.getValue());
        }
        QFilter orgFilter = new QFilter("settleorg", "in", orgIds);
        QFilter payStatusFilter = new QFilter("paystatus", "in", (Object)new String[]{"Unpaid", "Inpayment"});
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C", "E"});
        QFilter asstactFilter = new QFilter("entry.e_asstact.masterid", "in", asstactIds);
        QFilter closeStatus = new QFilter("entry.e_closestatus", "=", (Object)"A");
        DynamicObjectCollection historyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,settleorg,settlecurrency,entry.e_asstact.masterid,entry.e_approvedamt,entry.e_paidamt,entry.e_paymenttype.biztype", (QFilter[])new QFilter[]{orgFilter, payStatusFilter, statusFilter, asstactFilter, closeStatus});
        for (DynamicObject bill : historyBills) {
            Long billId = bill.getLong("id");
            String payType = bill.getString("entry.e_paymenttype.biztype");
            if (billIds.contains(billId) || "202".equals(payType)) continue;
            Long asstactId = bill.getLong("entry.e_asstact.masterid");
            String key = bill.getLong("settleorg") + "_" + asstactId + "_" + bill.getLong("settlecurrency");
            BigDecimal sumUnPaidAmt = supplierUnPaidAmtMap.get(key);
            if (sumUnPaidAmt == null) continue;
            BigDecimal curBillUnPaidAmt = bill.getBigDecimal("entry.e_approvedamt").subtract(bill.getBigDecimal("entry.e_paidamt"));
            supplierUnPaidAmtMap.put(key, sumUnPaidAmt.add(curBillUnPaidAmt));
        }
    }
}

