/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IOthersExecCtrlService;

public class PayTransitPrePayValidator
implements IOthersExecCtrlService {
    public Set<String> preparePropertys() {
        HashSet<String> lst = new HashSet<String>(16);
        lst.add("entry_lk_sbillid");
        lst.add("sourcebilltype");
        return lst;
    }

    public Map<Long, String> validate(DynamicObject[] others) {
        ArrayList<Long> finApBillIds = new ArrayList<Long>(16);
        for (DynamicObject bill : others) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (!"ap_finapbill".equals(sourceBillType)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObjectCollection entrylk = row.getDynamicObjectCollection("entry_lk");
                if (ObjectUtils.isEmpty((Object)entrylk)) continue;
                Long finApBillId = (Long)((DynamicObject)entrylk.get(0)).get("entry_lk_sbillid");
                finApBillIds.add(finApBillId);
            }
        }
        if (finApBillIds.size() == 0) {
            return null;
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno,org,asstact.masterid,detailentry.corebilltype,detailentry.corebillid,detailentry.e_conbillid,detailentry.e_conbillnumber,detailentry.corebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        ArrayList<Long> purBillIds = new ArrayList<Long>(16);
        ArrayList<Long> conmBillIds = new ArrayList<Long>(16);
        for (DynamicObject bill : finApBills) {
            String coreBillType = bill.getString("detailentry.corebilltype");
            Long coreBillId = bill.getLong("detailentry.corebillid");
            if ("pm_purorderbill".equals(coreBillType)) {
                purBillIds.add(coreBillId);
                Long conBillId = bill.getLong("detailentry.e_conbillid");
                if (conBillId != 0L) {
                    conmBillIds.add(conBillId);
                }
            }
            if (!"conm_purcontract".equals(coreBillType)) continue;
            conmBillIds.add(coreBillId);
        }
        ArrayList<Long> havePreAmtPurBillIds = new ArrayList<Long>(16);
        ArrayList<Long> havePreAmtConmBillIds = new ArrayList<Long>(16);
        ArrayList<Long> havePreAmtCoreBillIds = new ArrayList<Long>(16);
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        if (purBillIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billno,purbillentry_pay.payamount", (QFilter[])new QFilter[]{new QFilter("id", "in", purBillIds), new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE)});
            for (DynamicObject purBill : purBills) {
                Long purBillId = purBill.getLong("id");
                havePreAmtPurBillIds.add(purBillId);
                havePreAmtCoreBillIds.add(purBillId);
                BigDecimal sumPurPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
                if (sumPurPerAmt == null) {
                    coreBillPrePayAmt.put(purBillId, purBill.getBigDecimal("purbillentry_pay.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(purBillId, sumPurPerAmt.add(purBill.getBigDecimal("purbillentry_pay.payamount")));
            }
        }
        if (conmBillIds.size() > 0) {
            DynamicObjectCollection conmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"id,billno,payentry.payamount", (QFilter[])new QFilter[]{new QFilter("id", "in", conmBillIds), new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE)});
            for (DynamicObject conmBill : conmBills) {
                Long conmBillId = conmBill.getLong("id");
                havePreAmtConmBillIds.add(conmBillId);
                havePreAmtCoreBillIds.add(conmBillId);
                BigDecimal sumConmPerAmt = (BigDecimal)coreBillPrePayAmt.get(conmBillId);
                if (sumConmPerAmt == null) {
                    coreBillPrePayAmt.put(conmBillId, conmBill.getBigDecimal("payentry.payamount"));
                    continue;
                }
                coreBillPrePayAmt.put(conmBillId, sumConmPerAmt.add(conmBill.getBigDecimal("payentry.payamount")));
            }
        }
        if (coreBillPrePayAmt.size() == 0) {
            return new HashMap<Long, String>(2);
        }
        Map<Long, String> coreBillKeys = this.getCoreBillMatchKey(havePreAmtPurBillIds, havePreAmtConmBillIds);
        Map<Long, BigDecimal> coreBillSumPrePayMap = this.loadPayedPreBillAmt(havePreAmtCoreBillIds);
        for (DynamicObject apBill : finApBills) {
            String coreBillName;
            String coreMatchKey;
            String coreBillType = apBill.getString("detailentry.corebilltype");
            Long coreBillId = apBill.getLong("detailentry.corebillid");
            Long conBillId = apBill.getLong("detailentry.e_conbillid");
            Long masterId = apBill.getLong("asstact.masterid");
            String coreBillNo = apBill.getString("detailentry.corebillno");
            String conmBillNo = apBill.getString("detailentry.e_conbillnumber");
            String apMatchKey = apBill.getLong("org") + "_" + masterId;
            if (!apMatchKey.equals(coreMatchKey = coreBillKeys.get(coreBillId))) continue;
            BigDecimal corePreAmt = (BigDecimal)coreBillPrePayAmt.get(coreBillId);
            BigDecimal conmPreAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
            if (corePreAmt == null && conmPreAmt == null) continue;
            BigDecimal coreSumPreAmt = coreBillSumPrePayMap.get(coreBillId);
            String string = coreBillName = "pm_purorderbill".equals(coreBillType) ? ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"PayTransitPrePayValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"PayTransitPrePayValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
            if (coreSumPreAmt != null && coreSumPreAmt.compareTo(corePreAmt) >= 0) continue;
            if ("pm_purorderbill".equals(coreBillType)) {
                if (conBillId == 0L) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002\u76d1\u6d4b\u5230\u4e0a\u6e38%1$s %2$s\u5b58\u5728\u672a\u652f\u4ed8\u7684\u9884\u4ed8\u6b3e\uff0c\u8bf7\u5168\u90e8\u652f\u4ed8\u540e\u91cd\u8bd5\u3002", (String)"PayTransitPrePayValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), coreBillName, coreBillNo));
                }
                BigDecimal conSumPreAmt = coreBillSumPrePayMap.get(conBillId);
                if (conmPreAmt != null && conSumPreAmt != null && conSumPreAmt.compareTo(conmPreAmt) >= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002\u76d1\u6d4b\u5230\u4e0a\u6e38\u91c7\u8d2d\u5408\u540c %1$s\u5b58\u5728\u672a\u652f\u4ed8\u7684\u9884\u4ed8\u6b3e\uff0c\u8bf7\u5168\u90e8\u652f\u4ed8\u540e\u91cd\u8bd5\u3002", (String)"PayTransitPrePayValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), conmBillNo));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002\u76d1\u6d4b\u5230\u4e0a\u6e38%1$s %2$s\u5b58\u5728\u672a\u652f\u4ed8\u7684\u9884\u4ed8\u6b3e\uff0c\u8bf7\u5168\u90e8\u652f\u4ed8\u540e\u91cd\u8bd5\u3002", (String)"PayTransitPrePayValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), coreBillName, coreBillNo));
        }
        return null;
    }

    private Map<Long, String> getCoreBillMatchKey(List<Long> purOrderBillIds, List<Long> conBillIds) {
        Long masterId;
        Long billId;
        HashMap<Long, String> coreBillMapKey = new HashMap<Long, String>(16);
        if (purOrderBillIds.size() > 0) {
            DynamicObjectCollection hadPrePurBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,invoicesupplier.masterid,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", purOrderBillIds)}, null);
            for (DynamicObject bill : hadPrePurBills) {
                billId = bill.getLong("id");
                masterId = bill.getLong("invoicesupplier.masterid");
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, bill.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        if (conBillIds.size() > 0) {
            DynamicObjectCollection hadPreConBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"id,invoicesupplier.masterid,billentry.entrysettleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", conBillIds)}, null);
            for (DynamicObject bill : hadPreConBills) {
                billId = bill.getLong("id");
                masterId = bill.getLong("invoicesupplier.masterid");
                if (coreBillMapKey.get(billId) != null) continue;
                coreBillMapKey.put(billId, bill.getLong("billentry.entrysettleorg") + "_" + masterId);
            }
        }
        return coreBillMapKey;
    }

    private Map<Long, BigDecimal> loadPayedPreBillAmt(List<Long> coreBillIds) {
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        payBillFilter.and("paymenttype.biztype", "=", (Object)"202");
        DynamicObjectCollection prePayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (DynamicObject bill : prePayBills) {
            Long coreBillId = bill.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = bill.getBigDecimal("entry.e_payableamt").subtract(bill.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPrePayAmt != null) {
                coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, currentPayAmt);
        }
        return coreBillSumPrePayMap;
    }
}

