/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.ReplaceInvSrcTypeEnum;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;

public class ReplaceInvoiceSubmitAndAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set orgIds = Arrays.stream(dataEntities).map(bill -> bill.getDataEntity().getLong("org.id")).collect(Collectors.toSet());
        Map appParametersMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, new ArrayList(orgIds), (String[])new String[]{"ap_021", "ap_024"});
        Set<String> selectFinAndApplyValidateBillNos = this.getSelectFinAndApplyValidatorSeqMap();
        Map<String, Long> changedReplaceNo4InvIdMap = this.getDataHasChangedNoMap();
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap();
        Map<String, InvoiceVO> invoiceVoMap = this.getCollectInvoiceVoMap();
        Map<String, String> amtNotSameBillNosMap = this.validateInvoiceAmt4FinAp(appParametersMap, invoiceMap, invoiceVoMap);
        Map<String, String> newInvUnInvAmtValidateMap = this.validateNewInvUnInvAmt(invoiceMap, appParametersMap);
        Map<String, String> validatorApplyAmtMap = this.validateApplyAmt(invoiceMap, invoiceVoMap);
        Map<String, String> newInvHasAssignApplyBillNoMap = this.newInvHasAssignApply(invoiceMap);
        Map<String, String> validatorBlueInvAmtMap = this.validateBlueInvAmt(invoiceMap, invoiceVoMap);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String invoiceBillNo;
            DynamicObject replaceBill = dataEntity.getDataEntity();
            String billNo = replaceBill.getString("billno");
            DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
            if (newInvEntry.isEmpty()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65b0\u53d1\u7968\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u91c7\u96c6\u53d1\u7968\u6216\u6307\u5b9a\u53d1\u7968\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            String relateFinNotZeroMessage = null;
            for (DynamicObject newInvRow : newInvEntry) {
                if (newInvRow.getLong("n_apbillid") == 0L || BigDecimal.ZERO.compareTo(newInvRow.getBigDecimal("n_usedamt")) != 0) continue;
                invoiceBillNo = newInvRow.getString("n_invbillno");
                if (ObjectUtils.isEmpty((Object)invoiceBillNo)) {
                    relateFinNotZeroMessage = String.format(ResManager.loadKDString((String)"\u65b0\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff09\u7684\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_12", (String)"fi-ap-opplugin", (Object[])new Object[0]), newInvRow.getString("n_invoiceno"), newInvRow.getString("n_invoicecode"));
                    break;
                }
                relateFinNotZeroMessage = String.format(ResManager.loadKDString((String)"\u65b0\u53d1\u7968\uff08%1$s\uff09\u7684\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_13", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceBillNo);
                break;
            }
            if (relateFinNotZeroMessage != null) {
                this.addMessage(dataEntity, relateFinNotZeroMessage);
                continue;
            }
            if (changedReplaceNo4InvIdMap.containsKey(billNo)) {
                Long invoiceId = changedReplaceNo4InvIdMap.get(billNo);
                DynamicObject invoice = invoiceMap.get(invoiceId);
                invoiceBillNo = "";
                if (invoice != null) {
                    invoiceBillNo = invoice.getString("billno");
                }
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u539f\u53d1\u7968\uff08\u6536\u7968\u5355%1$s\uff09\u7684\u5173\u8054\u5355\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u53d6\u6d88\u6362\u7968\u540e\u91cd\u65b0\u53d1\u8d77\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceBillNo));
                continue;
            }
            if (validatorBlueInvAmtMap.containsKey(billNo)) {
                this.addMessage(dataEntity, validatorBlueInvAmtMap.get(billNo));
                continue;
            }
            if (selectFinAndApplyValidateBillNos.contains(billNo)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65b0\u53d1\u7968\u660e\u7ec6\u201c\u8d22\u52a1\u5e94\u4ed8\u5355\u201d\u548c\u201c\u4ed8\u6b3e\u7533\u8bf7\u5355\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5e76\u4e14\u6240\u6709\u65b0\u53d1\u7968\u7684\u201c\u8d22\u52a1\u5e94\u4ed8\u5355\u201d\u548c\u201c\u4ed8\u6b3e\u7533\u8bf7\u5355\u201d\u7684\u5355\u636e\u6570\u4e0e\u539f\u53d1\u7968\u7684\u201c\u8d22\u52a1\u5e94\u4ed8\u5355\u201d\u548c\u201c\u4ed8\u6b3e\u7533\u8bf7\u5355\u201d\u7684\u5355\u636e\u6570\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (newInvHasAssignApplyBillNoMap.containsKey(billNo)) {
                this.addMessage(dataEntity, newInvHasAssignApplyBillNoMap.get(billNo));
                continue;
            }
            if (amtNotSameBillNosMap.containsKey(billNo)) {
                this.addMessage(dataEntity, amtNotSameBillNosMap.get(billNo));
                continue;
            }
            if (newInvUnInvAmtValidateMap.containsKey(billNo)) {
                this.addMessage(dataEntity, newInvUnInvAmtValidateMap.get(billNo));
                continue;
            }
            if (!validatorApplyAmtMap.containsKey(billNo)) continue;
            this.addMessage(dataEntity, validatorApplyAmtMap.get(billNo));
        }
    }

    private Map<String, String> validateBlueInvAmt(Map<Long, DynamicObject> invoiceMap, Map<String, InvoiceVO> invoiceVoMap) {
        ExtendedDataEntity[] dataEntities;
        HashMap<String, String> validatorBlueInvAmtMap = new HashMap<String, String>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replace = dataEntity.getDataEntity();
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                if (newInvRow.getLong("pid") != 0L) continue;
                HashSet<String> validateNewInvNos = new HashSet<String>(8);
                String srcType = newInvRow.getString("n_srctype");
                String serialNo = newInvRow.getString("n_serialno");
                long invId = newInvRow.getLong("n_invid");
                long blueInvId = newInvRow.getLong("n_blueinvid");
                if (blueInvId != 0L) {
                    BigDecimal redInvPriceTaxAmt = ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType) ? invoiceVoMap.get(serialNo).getTotalTaxAmount() : invoiceMap.get(invId).getBigDecimal("pricetaxtotal");
                    BigDecimal blueInvPriceTaxAmt = invoiceMap.get(blueInvId).getBigDecimal("pricetaxtotal");
                    if (redInvPriceTaxAmt.abs().compareTo(blueInvPriceTaxAmt.abs()) > 0) {
                        if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                            validateNewInvNos.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"ReplaceInvoiceSubmitAndAuditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceVoMap.get(serialNo).getInvoiceNo(), invoiceVoMap.get(serialNo).getInvoiceCode()));
                        } else {
                            String str = ResManager.loadKDString((String)"\u6536\u7968\u5355", (String)"ReplaceInvoiceSubmitAndAuditValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                            validateNewInvNos.add(String.format("%1$s\uff1a%2$s", str, invoiceMap.get(invId).getString("billno")));
                        }
                    }
                }
                if (validateNewInvNos.isEmpty()) continue;
                validatorBlueInvAmtMap.put(replace.getString("billno"), String.format(ResManager.loadKDString((String)"\u65b0\u53d1\u7968\uff08%1$s\uff09\u7684\u4ef7\u7a0e\u5408\u8ba1\u7edd\u5bf9\u503c\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5bf9\u5e94\u84dd\u7968\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", validateNewInvNos)));
            }
        }
        return validatorBlueInvAmtMap;
    }

    private Map<String, String> newInvHasAssignApply(Map<Long, DynamicObject> invoiceMap) {
        HashMap<String, String> newInvHasAssignApplyBillNoMap = new HashMap<String, String>(8);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> newInvoiceIds = new HashSet<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject replace = dataEntity.getDataEntity();
            orgIds.add(replace.getLong("org.id"));
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                if (newInvRow.getLong("n_applybillid") == 0L) continue;
                newInvoiceIds.add(newInvRow.getLong("n_invid"));
            }
        }
        if (newInvoiceIds.isEmpty()) {
            return newInvHasAssignApplyBillNoMap;
        }
        DataSet applyBillDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,inventry.invid,billno", (QFilter[])new QFilter[]{new QFilter("settleorg", "in", orgIds), new QFilter("inventry.invid", "in", newInvoiceIds)}, (String)"");
        if (!applyBillDataSet.hasNext()) {
            return newInvHasAssignApplyBillNoMap;
        }
        HashMap<Long, Long> invoice4ApplyMap = new HashMap<Long, Long>(8);
        HashMap<Long, String> applyBillNoMap = new HashMap<Long, String>(8);
        for (Row row : applyBillDataSet) {
            applyBillNoMap.put(row.getLong("id"), row.getString("billno"));
            invoice4ApplyMap.put(row.getLong("inventry.invid"), row.getLong("id"));
        }
        block3: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject replace = dataEntity.getDataEntity();
            String billNo = replace.getString("billno");
            HashSet<Long> oldApplyIds = new HashSet<Long>(8);
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long applyBillId = oldInvRow.getLong("o_applybillid");
                if (applyBillId == 0L) continue;
                oldApplyIds.add(applyBillId);
            }
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                Long otherApplyId;
                long pid = newInvRow.getLong("pid");
                long applyBillId = newInvRow.getLong("n_applybillid");
                long invId = newInvRow.getLong("n_invid");
                if (pid != 0L || applyBillId == 0L || ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype")) || (otherApplyId = (Long)invoice4ApplyMap.get(invId)) == null || oldApplyIds.contains(otherApplyId)) continue;
                DynamicObject invoice = invoiceMap.get(invId);
                String invoiceBillNo = "";
                if (invoice != null) {
                    invoiceBillNo = invoice.getString("billno");
                }
                newInvHasAssignApplyBillNoMap.put(billNo, String.format(ResManager.loadKDString((String)"\u65b0\u53d1\u7968\uff08\u6536\u7968\u5355%1$s\uff09\u5df2\u5173\u8054\u4ed8\u6b3e\u7533\u8bf7\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u518d\u5173\u8054\u4ed8\u6b3e\u7533\u8bf7\u5355%3$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceBillNo, applyBillNoMap.get(otherApplyId), newInvRow.getString("n_applybillno")));
                continue block3;
            }
        }
        return newInvHasAssignApplyBillNoMap;
    }

    private Map<String, String> validateApplyAmt(Map<Long, DynamicObject> invoiceMap, Map<String, InvoiceVO> invoiceVoMap) {
        DynamicObject[] applyBills;
        HashMap<String, String> validatorApplyAmtMap = new HashMap<String, String>(8);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> applyBillIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject[] replace = dataEntity.getDataEntity();
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                long applyBillId = newInvRow.getLong("n_applybillid");
                if (applyBillId == 0L) continue;
                applyBillIds.add(applyBillId);
            }
        }
        if (applyBillIds.isEmpty()) {
            return validatorApplyAmtMap;
        }
        HashMap<Long, List> applyInvoiceMap = new HashMap<Long, List>(8);
        HashMap<Long, DynamicObject> applyBillMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> needQueryInvIds = new HashSet<Long>(8);
        for (DynamicObject applybill : applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"id,invid,aprseleamount,settlecurrency,settleorg,e_asstacttype,e_asstact,settlecurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", applyBillIds)})) {
            long id = applybill.getLong("id");
            DynamicObjectCollection invEntry = applybill.getDynamicObjectCollection("inventry");
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                invoiceIds.add(invId);
                if (invoiceMap.containsKey(invId)) continue;
                needQueryInvIds.add(invId);
            }
            applyInvoiceMap.put(id, invoiceIds);
            applyBillMap.put(id, applybill);
        }
        if (!needQueryInvIds.isEmpty()) {
            DynamicObject[] invoices;
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", needQueryInvIds)})) {
                invoiceMap.put(invoice.getLong("id"), invoice);
            }
        }
        ToleranceMatchService toleranceMatchService = new ToleranceMatchService();
        block5: for (ExtendedDataEntity dataEntity : dataEntities) {
            Object oldInvRow2;
            DynamicObject replace = dataEntity.getDataEntity();
            String billNo = replace.getString("billno");
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            for (Object oldInvRow2 : oldInvEntry) {
                List tempInvIds;
                long invoiceId = oldInvRow2.getLong("o_invid");
                long applyBillId = oldInvRow2.getLong("o_applybillid");
                if (applyBillId == 0L || (tempInvIds = (List)applyInvoiceMap.get(applyBillId)) == null) continue;
                tempInvIds.remove(invoiceId);
                applyInvoiceMap.put(applyBillId, tempInvIds);
            }
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            oldInvRow2 = newInvEntry.iterator();
            while (oldInvRow2.hasNext()) {
                DynamicObject newInvRow = (DynamicObject)oldInvRow2.next();
                long invoiceId = newInvRow.getLong("n_invid");
                long pid = newInvRow.getLong("pid");
                long blueInvoiceId = newInvRow.getLong("n_blueinvid");
                String srcType = newInvRow.getString("n_srctype");
                String serialNo = newInvRow.getString("n_serialno");
                long applyBillId = newInvRow.getLong("n_applybillid");
                if (applyBillId == 0L || pid != 0L) continue;
                List invoiceIds = applyInvoiceMap.getOrDefault(applyBillId, new ArrayList(4));
                if (blueInvoiceId != 0L) {
                    invoiceIds.add(blueInvoiceId);
                }
                if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                    invoiceIds.add(serialNo);
                } else {
                    invoiceIds.add(invoiceId);
                }
                applyInvoiceMap.put(applyBillId, invoiceIds);
            }
            ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(32);
            for (Map.Entry entrySet : applyInvoiceMap.entrySet()) {
                Long applyBillId = (Long)entrySet.getKey();
                List invoiceIds = (List)entrySet.getValue();
                DynamicObject applyBill = (DynamicObject)applyBillMap.get(applyBillId);
                if (applyBill == null || invoiceIds == null) continue;
                BigDecimal aprseleamount = applyBill.getBigDecimal("aprseleamount");
                BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
                for (Object invoiceId : invoiceIds) {
                    if (invoiceId instanceof Long) {
                        DynamicObject invoice = invoiceMap.get(invoiceId);
                        if (invoice == null || "2".equals(invoice.getString("invoicestatus"))) continue;
                        invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("pricetaxtotal"));
                        continue;
                    }
                    InvoiceVO invoiceVO = invoiceVoMap.get(String.valueOf(invoiceId));
                    if (invoiceVO == null || "2".equals(invoiceVO.getInvoiceStatus())) continue;
                    invoiceTotalAmount = invoiceTotalAmount.add(invoiceVO.getTotalAmount());
                }
                DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
                String eAsstactType = ((DynamicObject)entry.get(0)).getString("e_asstacttype");
                Long asstactMasterId = ((DynamicObject)entry.get(0)).getLong("e_asstact.masterid");
                HashMap<String, Number> toleranceParamMap = new HashMap<String, Number>(8);
                toleranceParamMap.put("controlvalue", aprseleamount);
                toleranceParamMap.put("contrastvalue", invoiceTotalAmount);
                toleranceParamMap.put("precision", applyBill.getInt("settlecurrency.amtprecision"));
                toleranceParamMap.put("pk", applyBill.getLong("id"));
                toleranceParamMap.put("bos_org", applyBill.getLong("settleorg.id"));
                if ("bd_supplier".equals(eAsstactType)) {
                    toleranceParamMap.put("bd_supplier", asstactMasterId);
                    toleranceParamMap.put("bd_customer", 0L);
                    toleranceParamMap.put("bd_material", 0L);
                } else if ("bd_customer".equals(eAsstactType)) {
                    toleranceParamMap.put("bd_supplier", 0L);
                    toleranceParamMap.put("bd_customer", asstactMasterId);
                    toleranceParamMap.put("bd_material", 0L);
                } else {
                    toleranceParamMap.put("bd_supplier", 0L);
                    toleranceParamMap.put("bd_customer", 0L);
                    toleranceParamMap.put("bd_material", 0L);
                }
                toleranceParamMap.put("bd_currency", applyBill.getLong("settlecurrency.id"));
                toleranceParamMap.put("bd_materialgroup", 0L);
                params.add(toleranceParamMap);
            }
            Set<String> canMatchDim = this.canMatchDim(params);
            List resultByToleranceType = toleranceMatchService.getResultByToleranceType("ap_payapply", "ap_invoice", "e_approvedseleamt", "pricetaxtotal", params);
            Set<Object> overBillIds = new HashSet(8);
            if (!ObjectUtils.isEmpty((Object)resultByToleranceType)) {
                overBillIds = resultByToleranceType.stream().map(m -> m.get("pk")).collect(Collectors.toSet());
            }
            for (Map.Entry entrySet : applyInvoiceMap.entrySet()) {
                Long applyBillId = (Long)entrySet.getKey();
                if (canMatchDim.contains(String.valueOf(applyBillId)) && overBillIds.contains(applyBillId)) {
                    validatorApplyAmtMap.put(billNo, ResManager.loadKDString((String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u9884\u4ed8\u53d1\u7968\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue block5;
                }
                if (canMatchDim.contains(String.valueOf(applyBillId))) continue;
                DynamicObject applyBill = (DynamicObject)applyBillMap.get(applyBillId);
                List invoiceIds = (List)applyInvoiceMap.get(applyBillId);
                if (applyBill == null || invoiceIds == null) continue;
                BigDecimal aprseleamount = applyBill.getBigDecimal("aprseleamount");
                BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
                for (Object invoiceId : invoiceIds) {
                    if (invoiceId instanceof Long) {
                        DynamicObject invoice = invoiceMap.get(invoiceId);
                        if (invoice == null || "2".equals(invoice.getString("invoicestatus"))) continue;
                        invoiceTotalAmount = invoiceTotalAmount.add(invoice.getBigDecimal("pricetaxtotal"));
                        continue;
                    }
                    InvoiceVO invoiceVO = invoiceVoMap.get(String.valueOf(invoiceId));
                    if (invoiceVO == null || "2".equals(invoiceVO.getInvoiceStatus())) continue;
                    invoiceTotalAmount = invoiceTotalAmount.add(invoiceVO.getTotalAmount());
                }
                if (aprseleamount.compareTo(invoiceTotalAmount) == 0) continue;
                validatorApplyAmtMap.put(billNo, ResManager.loadKDString((String)"\u9884\u4ed8\u91d1\u989d\u4e0e\u9884\u4ed8\u53d1\u7968\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue block5;
            }
        }
        return validatorApplyAmtMap;
    }

    private Map<String, String> validateNewInvUnInvAmt(Map<Long, DynamicObject> invoiceMap, Map<Long, Map<String, Object>> appParametersMap) {
        ExtendedDataEntity[] dataEntities;
        HashMap<String, String> newInvUnInvAmtValidateMap = new HashMap<String, String>(8);
        block0: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replace = dataEntity.getDataEntity();
            long orgId = replace.getLong("org.id");
            String billNo = replace.getString("billno");
            Map<String, Object> parametersMap = appParametersMap.get(orgId);
            if (((Boolean)parametersMap.get("ap_021")).booleanValue() || ((Boolean)parametersMap.get("ap_024")).booleanValue()) continue;
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                DynamicObject invoice;
                if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                long pid = newInvRow.getLong("pid");
                BigDecimal usedAmt = newInvRow.getBigDecimal("n_usedamt");
                if (pid != 0L || (invoice = invoiceMap.get(newInvRow.getLong("n_invid"))) == null) continue;
                BigDecimal unRelatedAmt = invoice.getBigDecimal("unrelatedamt");
                if (usedAmt.abs().compareTo(unRelatedAmt.abs()) <= 0 && unRelatedAmt.signum() * usedAmt.signum() >= 0 && "C".equals(invoice.getString("billstatus"))) continue;
                newInvUnInvAmtValidateMap.put(billNo, String.format(ResManager.loadKDString((String)"\u65b0\u53d1\u7968\uff08\u6536\u7968\u5355%1$s\uff09\u672a\u5173\u8054\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoice.getString("billno")));
                continue block0;
            }
        }
        return newInvUnInvAmtValidateMap;
    }

    private Map<String, String> validateInvoiceAmt4FinAp(Map<Long, Map<String, Object>> appParametersMap, Map<Long, DynamicObject> invoiceMap, Map<String, InvoiceVO> invoiceVoMap) {
        HashMap<String, String> amtNotSameBillNosMap = new HashMap<String, String>(8);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> amtValidate4ApBillIds = new HashSet<Long>(16);
        HashSet<Long> usedAmtValidate4ApBillIds = new HashSet<Long>(16);
        HashSet<Long> needAmtValidateOrgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject replace = dataEntity.getDataEntity();
            long orgId = replace.getLong("org.id");
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            Map<String, Object> parametersMap = appParametersMap.get(orgId);
            for (DynamicObject newInvRow : newInvEntry) {
                long apBillId = newInvRow.getLong("n_apbillid");
                if (apBillId == 0L) continue;
                if (((Boolean)parametersMap.get("ap_021")).booleanValue() || ((Boolean)parametersMap.get("ap_024")).booleanValue()) {
                    amtValidate4ApBillIds.add(apBillId);
                    needAmtValidateOrgIds.add(orgId);
                    continue;
                }
                usedAmtValidate4ApBillIds.add(apBillId);
            }
        }
        if (amtValidate4ApBillIds.isEmpty() && usedAmtValidate4ApBillIds.isEmpty()) {
            return amtNotSameBillNosMap;
        }
        HashMap<Long, Set> finApInvoiceMap = new HashMap<Long, Set>(8);
        HashMap<Long, DynamicObject> finApBillMap = new HashMap<Long, DynamicObject>(8);
        ArrayList<Long> tempApBillIds = new ArrayList<Long>(32);
        tempApBillIds.addAll(amtValidate4ApBillIds);
        tempApBillIds.addAll(usedAmtValidate4ApBillIds);
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,id,amount,tax,pricetaxtotal,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", tempApBillIds)});
        HashSet<Long> needQueryInvoiceIds = new HashSet<Long>(8);
        for (DynamicObject finApBill : finApBills) {
            long id = finApBill.getLong("id");
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            HashSet<Long> invoiceIds = new HashSet<Long>(8);
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                invoiceIds.add(invId);
                if (invoiceMap.containsKey(invId)) continue;
                needQueryInvoiceIds.add(invId);
            }
            finApInvoiceMap.put(id, invoiceIds);
            finApBillMap.put(id, finApBill);
        }
        if (!needQueryInvoiceIds.isEmpty()) {
            DynamicObject[] invoices;
            DynamicObject[] dynamicObjectArray = invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", needQueryInvoiceIds)});
            int n = dynamicObjectArray.length;
            for (int finApBill = 0; finApBill < n; ++finApBill) {
                DynamicObject invoice = dynamicObjectArray[finApBill];
                invoiceMap.put(invoice.getLong("id"), invoice);
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject invoice;
            DynamicObject replace = dataEntity.getDataEntity();
            String billNo = replace.getString("billno");
            String validatorMessage = null;
            long orgId = replace.getLong("org.id");
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                long invoiceId = oldInvRow.getLong("o_invid");
                long apBillId = oldInvRow.getLong("o_apbillid");
                Set tempInvIds = (Set)finApInvoiceMap.get(apBillId);
                if (apBillId == 0L || tempInvIds == null) continue;
                tempInvIds.remove(invoiceId);
                finApInvoiceMap.put(apBillId, tempInvIds);
            }
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            HashMap<Long, Map> finAp4NewInvUsedAmtMap = new HashMap<Long, Map>(8);
            HashSet<Long> newInvIds = new HashSet<Long>();
            HashSet<String> newInvSerialNos = new HashSet<String>();
            HashSet<String> validateFinNos = new HashSet<String>(8);
            for (DynamicObject newInvRow : newInvEntry) {
                long invoiceId = newInvRow.getLong("n_invid");
                long blueInvoiceId = newInvRow.getLong("n_blueinvid");
                String srcType = newInvRow.getString("n_srctype");
                String serialNo = newInvRow.getString("n_serialno");
                long apBillId = newInvRow.getLong("n_apbillid");
                BigDecimal usedAmt = newInvRow.getBigDecimal("n_usedamt");
                if (apBillId == 0L) continue;
                invoice = invoiceMap.get(invoiceId);
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType) && needAmtValidateOrgIds.contains(orgId) && (invoice == null || invoice.getBigDecimal("pricetaxtotal").compareTo(invoice.getBigDecimal("unrelatedamt")) != 0)) {
                    String finApBillNo = ((DynamicObject)oldInvEntry.get(0)).getString("o_apbillno");
                    validateFinNos.add(finApBillNo);
                    break;
                }
                Map inv4UsedAmtMap = finAp4NewInvUsedAmtMap.getOrDefault(apBillId, new HashMap(8));
                if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                    inv4UsedAmtMap.put(serialNo, usedAmt);
                    newInvSerialNos.add(serialNo);
                } else {
                    inv4UsedAmtMap.put(String.valueOf(invoiceId), usedAmt);
                    newInvIds.add(invoiceId);
                }
                finAp4NewInvUsedAmtMap.put(apBillId, inv4UsedAmtMap);
                Set invoiceIds = finApInvoiceMap.getOrDefault(apBillId, new HashSet(4));
                if (ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(srcType)) {
                    invoiceIds.add(serialNo);
                } else {
                    invoiceIds.add(invoiceId);
                }
                if (blueInvoiceId != 0L) {
                    invoiceIds.add(blueInvoiceId);
                }
                finApInvoiceMap.put(apBillId, invoiceIds);
            }
            for (Map.Entry entrySet : finApInvoiceMap.entrySet()) {
                Long apBillId = (Long)entrySet.getKey();
                Set invoiceIds = (Set)entrySet.getValue();
                DynamicObject finApBill = (DynamicObject)finApBillMap.get(apBillId);
                if (finApBill == null) continue;
                HashSet<String> messageList = new HashSet<String>(8);
                if (amtValidate4ApBillIds.contains(apBillId)) {
                    BigDecimal amount = BigDecimal.ZERO;
                    Object tax = BigDecimal.ZERO;
                    BigDecimal priceTaxTotal = BigDecimal.ZERO;
                    for (Object invoiceId : invoiceIds) {
                        if (invoiceId instanceof Long) {
                            invoice = invoiceMap.get(invoiceId);
                            if (invoice == null || "2".equals(invoice.getString("invoicestatus"))) continue;
                            amount = amount.add(invoice.getBigDecimal("amount"));
                            tax = ((BigDecimal)tax).add(invoice.getBigDecimal("tax"));
                            priceTaxTotal = priceTaxTotal.add(invoice.getBigDecimal("pricetaxtotal"));
                            continue;
                        }
                        InvoiceVO invoiceVO = invoiceVoMap.get(String.valueOf(invoiceId));
                        if (invoiceVO == null || "2".equals(invoiceVO.getInvoiceStatus())) continue;
                        BigDecimal tempAmount = invoiceVO.getInvoiceAmount() != null ? invoiceVO.getInvoiceAmount() : ((invoiceVO.getInvoiceMoney() != null ? invoiceVO.getInvoiceMoney() : invoiceVO.getAmount()) != null ? invoiceVO.getAmount() : invoiceVO.getTotalAmount());
                        amount = amount.add(tempAmount);
                        tax = ((BigDecimal)tax).add(invoiceVO.getTaxAmount() != null ? invoiceVO.getTaxAmount() : invoiceVO.getTotalTaxAmount());
                        priceTaxTotal = priceTaxTotal.add(invoiceVO.getTotalAmount());
                    }
                    if (finApBill.getBigDecimal("amount").compareTo(amount) != 0 || finApBill.getBigDecimal("tax").compareTo((BigDecimal)tax) != 0 || finApBill.getBigDecimal("pricetaxtotal").compareTo(priceTaxTotal) != 0) {
                        validateFinNos.add(finApBill.getString("billno"));
                        break;
                    }
                } else {
                    Object invoiceId;
                    HashSet<Long> tempInvoiceIds = new HashSet<Long>(8);
                    for (Object invoiceId2 : invoiceIds) {
                        if (!(invoiceId2 instanceof Long)) continue;
                        tempInvoiceIds.add((Long)invoiceId2);
                    }
                    BigDecimal finApTotalUsedAmt = BigDecimal.ZERO;
                    BigDecimal changeInvTotalUsedAmt = BigDecimal.ZERO;
                    DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                    invoiceId = invEntry.iterator();
                    while (invoiceId.hasNext()) {
                        DynamicObject invRow = (DynamicObject)invoiceId.next();
                        BigDecimal usedAmt = invRow.getBigDecimal("i_usedamt");
                        finApTotalUsedAmt = finApTotalUsedAmt.add(usedAmt);
                        if (!tempInvoiceIds.contains(invRow.getLong("invid"))) continue;
                        changeInvTotalUsedAmt = changeInvTotalUsedAmt.add(usedAmt);
                    }
                    Map invUsedAmtMap = finAp4NewInvUsedAmtMap.getOrDefault(apBillId, new HashMap(2));
                    for (Object invoiceId3 : invoiceIds) {
                        BigDecimal tempUsedAmt = invUsedAmtMap.getOrDefault(String.valueOf(invoiceId3), BigDecimal.ZERO);
                        changeInvTotalUsedAmt = changeInvTotalUsedAmt.add(tempUsedAmt);
                    }
                    if (finApTotalUsedAmt.abs().compareTo(changeInvTotalUsedAmt.abs()) != 0 || changeInvTotalUsedAmt.signum() != finApTotalUsedAmt.signum()) {
                        for (Object invoiceId3 : invoiceIds) {
                            if (invoiceId3 instanceof Long && newInvIds.contains((Long)invoiceId3)) {
                                DynamicObject invoice2 = invoiceMap.get((Long)invoiceId3);
                                String invoiceBillNo = "";
                                if (invoice2 != null) {
                                    invoiceBillNo = invoice2.getString("billno");
                                }
                                String str = ResManager.loadKDString((String)"\u6536\u7968\u5355", (String)"ReplaceInvoiceSubmitAndAuditValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                                messageList.add(String.format("%1$s\uff1a%2$s", str, invoiceBillNo));
                                continue;
                            }
                            if (!(invoiceId3 instanceof String) || !newInvSerialNos.contains((String)invoiceId3)) continue;
                            InvoiceVO invoiceVO = invoiceVoMap.get(String.valueOf(invoiceId3));
                            String invoiceCode = "";
                            String invoiceNo = "";
                            if (invoiceVO != null) {
                                invoiceCode = invoiceVO.getInvoiceCode();
                                invoiceNo = invoiceVO.getInvoiceNo();
                            }
                            messageList.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s", (String)"ReplaceInvoiceSubmitAndAuditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), invoiceNo, invoiceCode));
                        }
                    }
                }
                if (messageList.isEmpty()) continue;
                validatorMessage = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff1a\u65b0\u53d1\u7968\uff08%2$s\uff09\u7684\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u7b49\u4e8e\u539f\u53d1\u7968\u7684\u672c\u6b21\u5360\u7528\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), finApBill.getString("billno"), String.join((CharSequence)";", messageList));
            }
            if (!validateFinNos.isEmpty()) {
                validatorMessage = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\uff08%1$s\uff09\u4e0e\u53d1\u7968\u7684\u4ef7\u7a0e\u5408\u8ba1\u3001\u7a0e\u989d\u3001\u91d1\u989d\u5b58\u5728\u4e0d\u76f8\u7b49\u9879\u6216\u53d1\u7968\u5df2\u88ab\u5176\u4ed6\u7684\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ReplaceInvoiceSubmitAndAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", validateFinNos));
            }
            if (validatorMessage == null) continue;
            amtNotSameBillNosMap.put(billNo, validatorMessage);
        }
        return amtNotSameBillNosMap;
    }

    private Map<String, InvoiceVO> getCollectInvoiceVoMap() {
        ExtendedDataEntity[] dataEntities;
        HashMap<Long, Set> orgForSerialNosMap = new HashMap<Long, Set>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replace = dataEntity.getDataEntity();
            long orgId = replace.getLong("org.id");
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            Set serialNos = orgForSerialNosMap.getOrDefault(orgId, new HashSet(8));
            for (DynamicObject newInvRow : newInvEntry) {
                if (!ReplaceInvSrcTypeEnum.INVOICECOLLECT.getValue().equals(newInvRow.getString("n_srctype"))) continue;
                serialNos.add(newInvRow.getString("n_serialno"));
            }
            if (serialNos.isEmpty()) continue;
            orgForSerialNosMap.put(orgId, serialNos);
        }
        HashMap<String, InvoiceVO> invoiceVOMap = new HashMap<String, InvoiceVO>(8);
        if (orgForSerialNosMap.isEmpty()) {
            return invoiceVOMap;
        }
        HashMap tempOrgForSerialMap = new HashMap(8);
        for (Map.Entry entrySet : orgForSerialNosMap.entrySet()) {
            tempOrgForSerialMap.put(entrySet.getKey(), String.join((CharSequence)",", (Iterable)entrySet.getValue()));
        }
        List invoiceVOS = CallCloudHelper.queryCloudInvoice(tempOrgForSerialMap);
        for (InvoiceVO invoiceVO : invoiceVOS) {
            invoiceVOMap.put(invoiceVO.getSerialNo(), invoiceVO);
        }
        return invoiceVOMap;
    }

    private Map<Long, DynamicObject> getInvoiceMap() {
        ExtendedDataEntity[] dataEntities;
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replace = dataEntity.getDataEntity();
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                invoiceIds.add(oldInvRow.getLong("o_invid"));
            }
            DynamicObjectCollection newInvEntry = replace.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                invoiceIds.add(newInvRow.getLong("n_invid"));
            }
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)this.getInvoiceSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
    }

    private String getInvoiceSelectors() {
        return "id,billno,invoicecode,invoiceno,unrelatedamt,pricetaxtotal,invoicestatus,amount,tax,pricetaxtotal,billstatus";
    }

    private Set<String> getSelectFinAndApplyValidatorSeqMap() {
        ExtendedDataEntity[] dataEntities;
        HashSet<String> selectFinAndApplyValidateBillNos = new HashSet<String>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replaceBill = dataEntity.getDataEntity();
            DynamicObjectCollection oldInvEntry = replaceBill.getDynamicObjectCollection("oldinventry");
            DynamicObjectCollection newInvEntry = replaceBill.getDynamicObjectCollection("newinventry");
            HashSet<Long> oldFinApIds = new HashSet<Long>(8);
            HashSet<Long> oldApplyIds = new HashSet<Long>(8);
            for (DynamicObject oldInvRow : oldInvEntry) {
                long apBillId = oldInvRow.getLong("o_apbillid");
                long applyBillId = oldInvRow.getLong("o_applybillid");
                if (apBillId != 0L) {
                    oldFinApIds.add(apBillId);
                }
                if (applyBillId == 0L) continue;
                oldApplyIds.add(applyBillId);
            }
            HashSet<Long> pidList = new HashSet<Long>(8);
            for (DynamicObject newInvRow : newInvEntry) {
                long pid = newInvRow.getLong("pid");
                if (pid == 0L) continue;
                pidList.add(pid);
            }
            for (DynamicObject newInvRow : newInvEntry) {
                long apBillId = newInvRow.getLong("n_apbillid");
                long applyId = newInvRow.getLong("n_applybillid");
                if (apBillId != 0L) {
                    oldFinApIds.remove(apBillId);
                }
                if (applyId != 0L) {
                    oldApplyIds.remove(applyId);
                }
                if (pidList.contains(newInvRow.getLong("id")) || apBillId != 0L || applyId != 0L) continue;
                selectFinAndApplyValidateBillNos.add(replaceBill.getString("billno"));
                break;
            }
            if (oldFinApIds.isEmpty() && oldApplyIds.isEmpty()) continue;
            selectFinAndApplyValidateBillNos.add(replaceBill.getString("billno"));
        }
        return selectFinAndApplyValidateBillNos;
    }

    private Map<String, Long> getDataHasChangedNoMap() {
        ExtendedDataEntity[] dataEntities;
        HashMap<String, Long> changedReplaceNo4InvIdMap = new HashMap<String, Long>(8);
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject replace = dataEntity.getDataEntity();
            orgIds.add(replace.getLong("org.id"));
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                invoiceIds.add(oldInvRow.getLong("o_invid"));
            }
        }
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{new QFilter("inventry.invid", "in", invoiceIds), new QFilter("org", "in", orgIds), new QFilter("billstatus", "=", (Object)"C")}, (String)"");
        HashMap<Long, Map> invoice4FinApUsedAmtMap = new HashMap<Long, Map>(8);
        for (Row row : finApDataSet) {
            Long invoiceId = row.getLong("inventry.invid");
            Long apBillId = row.getLong("id");
            BigDecimal usedAmt = row.getBigDecimal("inventry.i_usedamt");
            Map finApUsedAmtMap = invoice4FinApUsedAmtMap.getOrDefault(invoiceId, new HashMap(8));
            finApUsedAmtMap.put(apBillId, usedAmt);
            invoice4FinApUsedAmtMap.put(invoiceId, finApUsedAmtMap);
        }
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("inventry.invid", "in", invoiceIds), new QFilter("settleorg", "in", orgIds), new QFilter("billstatus", "=", (Object)"C")}, (String)"");
        HashMap<Long, Long> invoice4ApplyIdMap = new HashMap<Long, Long>(8);
        for (Row row : applyDataSet) {
            invoice4ApplyIdMap.put(row.getLong("inventry.invid"), row.getLong("id"));
        }
        block4: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject replace = dataEntity.getDataEntity();
            String billNo = replace.getString("billno");
            DynamicObjectCollection oldInvEntry = replace.getDynamicObjectCollection("oldinventry");
            HashSet<Long> parentRowIds = new HashSet<Long>(8);
            for (DynamicObject oldInvRow : oldInvEntry) {
                long pid = oldInvRow.getLong("pid");
                if (pid == 0L) continue;
                parentRowIds.add(pid);
            }
            for (DynamicObject oldInvRow : oldInvEntry) {
                BigDecimal nowUsedAmt;
                long invoiceId = oldInvRow.getLong("o_invid");
                long apBillId = oldInvRow.getLong("o_apbillid");
                long pid = oldInvRow.getLong("pid");
                long rowId = oldInvRow.getLong("id");
                BigDecimal usedAmt = oldInvRow.getBigDecimal("o_usedamt");
                Map finApUsedAmtMap = invoice4FinApUsedAmtMap.getOrDefault(invoiceId, new HashMap(8));
                Long applyId = invoice4ApplyIdMap.getOrDefault(invoiceId, 0L);
                if (applyId.longValue() != oldInvRow.getLong("o_applybillid")) {
                    changedReplaceNo4InvIdMap.put(billNo, invoiceId);
                    continue block4;
                }
                if (pid == 0L && parentRowIds.contains(rowId) || apBillId == 0L || (nowUsedAmt = (BigDecimal)finApUsedAmtMap.get(apBillId)) != null && nowUsedAmt.compareTo(usedAmt) == 0) continue;
                changedReplaceNo4InvIdMap.put(billNo, invoiceId);
                continue block4;
            }
        }
        return changedReplaceNo4InvIdMap;
    }

    private Set<String> canMatchDim(List<Map<String, Object>> params) {
        HashSet<String> result = new HashSet<String>(16);
        if (params.size() == 0) {
            return result;
        }
        DynamicObject toleranceType = BusinessDataServiceHelper.loadSingle((String)"ap_tolerancetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)"ap_payapply"), new QFilter("contraster", "=", (Object)"ap_invoice"), new QFilter("controlitem", "=", (Object)"e_approvedseleamt"), new QFilter("contrastitem", "=", (Object)"pricetaxtotal"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceType == null) {
            return result;
        }
        Long toleranceTypeId = toleranceType.getLong("id");
        DynamicObject toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)"ap_payapply"), new QFilter("contraster", "=", (Object)"ap_invoice"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceScheme == null) {
            return result;
        }
        DynamicObjectCollection entry = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Long rowToleranceTypeId = row.getDynamicObject("e_tolerancetypeid").getLong("id");
            if (!toleranceTypeId.equals(rowToleranceTypeId)) continue;
            this.match(row, params, result);
            break;
        }
        return result;
    }

    private void match(DynamicObject row, List<Map<String, Object>> params, Set<String> result) {
        String toleranceDim = row.getString("e_tolerancedim");
        String dimensionMap = row.getString("e_dimensionmap");
        String[] toleranceDims = new String[]{};
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        if (toleranceDim != null && !"".equals(toleranceDim)) {
            toleranceDims = toleranceDim.substring(1).split(",");
            HashMap<String, ArrayList<Map<String, Object>>> paramGroupByDim = new HashMap<String, ArrayList<Map<String, Object>>>(16);
            for (Map<String, Object> param : params) {
                StringBuilder matchKey = null;
                for (String dim : toleranceDims) {
                    if (!param.containsKey(dim)) {
                        matchKey = null;
                        break;
                    }
                    Object object = param.get(dim);
                    if (object == null || "".equals(object)) {
                        if (matchKey == null) {
                            matchKey = new StringBuilder("null");
                            continue;
                        }
                        matchKey.append('_').append("null");
                        continue;
                    }
                    if (object instanceof List) {
                        List dimList = (List)object;
                        List dimStrList = dimList.stream().map(String::valueOf).collect(Collectors.toList());
                        if (matchKey == null) {
                            matchKey = new StringBuilder(String.join((CharSequence)"_", dimStrList));
                            continue;
                        }
                        matchKey.append('_').append(String.valueOf(object));
                        continue;
                    }
                    if (matchKey == null) {
                        matchKey = new StringBuilder(String.valueOf(param.get(dim)));
                        continue;
                    }
                    matchKey.append('_').append(String.valueOf(param.get(dim)));
                }
                if (matchKey == null) continue;
                ArrayList<Map<String, Object>> paramList = (ArrayList<Map<String, Object>>)paramGroupByDim.get(matchKey.toString());
                if (paramList == null) {
                    paramList = new ArrayList<Map<String, Object>>(16);
                    paramList.add(param);
                    paramGroupByDim.put(matchKey.toString(), paramList);
                    continue;
                }
                paramList.add(param);
            }
            ArrayList tolerances = new ArrayList(16);
            Map toleranceDimMap = (Map)SerializationUtils.fromJsonString((String)dimensionMap, Map.class);
            for (DynamicObject entry : subEntry) {
                HashMap rowTolerance = new HashMap(16);
                for (Map.Entry entrySet : toleranceDimMap.entrySet()) {
                    if (!((String)entrySet.getValue()).endsWith("_pk")) continue;
                    String string = ((String)entrySet.getValue()).substring(0, ((String)entrySet.getValue()).length() - 3);
                    String dimensionValues = entry.getString((String)entrySet.getKey());
                    List dimensionPkList = Stream.of(dimensionValues.split(",")).collect(Collectors.toList());
                    HashMap<Long, String> dimensionPkLongList = new HashMap<Long, String>(8);
                    for (String pk : dimensionPkList) {
                        if ("".equals(pk)) continue;
                        dimensionPkLongList.put(Long.valueOf(pk), pk);
                    }
                    rowTolerance.put(string, dimensionPkLongList);
                }
                tolerances.add(rowTolerance);
            }
            block5: for (Map.Entry entrySet : paramGroupByDim.entrySet()) {
                List value = (List)entrySet.getValue();
                Map firstParam = (Map)value.get(0);
                for (Map map : tolerances) {
                    boolean isMatch = true;
                    for (String dim : toleranceDims) {
                        Object dimValues = firstParam.get(dim);
                        Map dimPks = (Map)map.get(dim);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            List values = (List)dimValues;
                            boolean isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)firstParam.get(dim)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    for (Map param : value) {
                        result.add(String.valueOf(param.get("pk")));
                    }
                    continue block5;
                }
            }
        } else {
            for (Map<String, Object> param : params) {
                result.add(String.valueOf(param.get("pk")));
            }
        }
    }
}

