/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class SettleModelValidator
extends AbstractExecControlValidator {
    public void validate() {
        HashSet<Long> sourceApIdSet = new HashSet<Long>(64);
        HashSet<Long> sourceArIdSet = new HashSet<Long>(64);
        this.buildSrcIdSet(sourceApIdSet, sourceArIdSet);
        Map<Long, DynamicObject> srcBillMap = this.buildSrcBillMap(sourceApIdSet, sourceArIdSet);
        if (srcBillMap.size() > 0) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                this.validate(bill, srcBillMap, dataEntity);
            }
        }
    }

    private void buildSrcIdSet(Set<Long> sourceApIdSet, Set<Long> sourceArIdSet) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String sourceBillType = bill.getString("sourcebilltype");
            Long sourceBillId = bill.getLong("sourcebillid");
            if ("ap_finapbill".equals(sourceBillType)) {
                sourceApIdSet.add(sourceBillId);
                continue;
            }
            if (!"ar_finarbill".equals(sourceBillType)) continue;
            sourceArIdSet.add(sourceBillId);
        }
    }

    private Map<Long, DynamicObject> buildSrcBillMap(Set<Long> sourceApIdSet, Set<Long> sourceArIdSet) {
        DynamicObject[] bills;
        HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(64);
        if (sourceApIdSet.size() > 0) {
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"detailentry.id,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceApIdSet.toArray())})) {
                srcBillMap.put(bill.getLong("id"), bill);
            }
        }
        if (sourceArIdSet.size() > 0) {
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"entry.id,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceArIdSet.toArray())})) {
                srcBillMap.put(bill.getLong("id"), bill);
            }
        }
        return srcBillMap;
    }

    private void validate(DynamicObject bill, Map<Long, DynamicObject> srcBillMap, ExtendedDataEntity dataEntity) {
        String sourceBillType = bill.getString("sourcebilltype");
        Long sourceBillId = bill.getLong("sourcebillid");
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        DynamicObject sourceBill = srcBillMap.get(sourceBillId);
        if (StringUtils.isNotEmpty((String)sourceBillType) && sourceBillId != 0L && EmptyUtils.isNotEmpty((Object)sourceBill) && EmptyUtils.isNotEmpty((Object)settleOrg)) {
            boolean isAp = "ap_finapbill".equals(sourceBillType);
            Long orgPk = settleOrg.getLong("id");
            int settleParam = isAp ? ArApHelper.getApSettleParam((Object)orgPk) : ArApHelper.getArSettleParam((Object)orgPk);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            Long entryId = 0L;
            for (DynamicObject row : entry) {
                Long entryLkSrcId;
                DynamicObjectCollection entryLk = row.getDynamicObjectCollection("entry_lk");
                if (!EmptyUtils.isNotEmpty((Object)entryLk) || !sourceBillId.equals(entryLkSrcId = Long.valueOf(((DynamicObject)entryLk.get(0)).getLong("entry_lk_sbillid")))) continue;
                entryId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sid");
                break;
            }
            if (entryId != 0L) {
                if (1 == settleParam) {
                    String entryName = isAp ? "detailentry" : "entry";
                    DynamicObjectCollection sourceEntry = sourceBill.getDynamicObjectCollection(entryName);
                    for (DynamicObject row : sourceEntry) {
                        if (!entryId.equals(row.getLong("id"))) continue;
                        return;
                    }
                } else if (2 == settleParam) {
                    DynamicObjectCollection sourceEntry = sourceBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject row : sourceEntry) {
                        if (!entryId.equals(row.getLong("id"))) continue;
                        return;
                    }
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u6362\u5173\u7cfb\u4e2d\u201c\u5173\u8054\u5b9e\u4f53\u201d\u7684\u5339\u914d\u503c\u4e0d\u6ee1\u8db3\u7ed3\u7b97\u6a21\u578b\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u201c\u8f6c\u6362\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"SettleModelValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public Set<String> preparePropertys() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("id");
        set.add("sourcebilltype");
        set.add("sourcebillid");
        set.add("settleorg");
        set.add("entry_lk_sbillid");
        set.add("entry_lk_sid");
        set.add("entry_lk");
        return set;
    }
}

