/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SupplierPayHoldValidator
extends AbstractValidator {
    public void validate() {
        String entityKey = this.entityKey;
        if ("ap_finapbill".equals(entityKey)) {
            this.check4FinApBill();
        } else if ("ap_payapply".equals(entityKey)) {
            this.check4PayApplyBill();
        }
    }

    private void check4FinApBill() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operateKey = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"SupplierPayHoldValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        if ("submit".equals(this.getOperateKey())) {
            operateKey = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"SupplierPayHoldValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        ArrayList<Long> asstactList = new ArrayList<Long>(8);
        for (ExtendedDataEntity data : datas) {
            DynamicObject asstact;
            DynamicObject bill = data.getDataEntity();
            if (!"bd_supplier".equals(bill.getString("asstacttype")) || ObjectUtils.isEmpty((Object)(asstact = bill.getDynamicObject("asstact")))) continue;
            Long id = asstact.getLong("id");
            asstactList.add(id);
        }
        Map asstactRes = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactList).and("payhold", "=", (Object)Boolean.TRUE)});
        if (!ObjectUtils.isEmpty((Object)asstactRes)) {
            for (ExtendedDataEntity data : datas) {
                DynamicObject asstact;
                DynamicObject bill = data.getDataEntity();
                if (!"bd_supplier".equals(bill.getString("asstacttype")) || ObjectUtils.isEmpty((Object)(asstact = bill.getDynamicObject("asstact"))) || !asstactRes.containsKey(asstact.getLong("id"))) continue;
                String billno = bill.getString("billno");
                String asstactName = asstact.getString("name");
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7ed3\u7b97\u4f9b\u5e94\u5546\u201c%2$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"SupplierPayHoldValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billno, asstactName, operateKey);
                this.addMessage(data, message);
            }
        }
    }

    private void check4PayApplyBill() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operateKey = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"SupplierPayHoldValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        if ("submit".equals(this.getOperateKey())) {
            operateKey = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"SupplierPayHoldValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        ArrayList<Long> asstactIdList = new ArrayList<Long>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject asstact;
                if (!"bd_supplier".equals(entry.getString("e_asstacttype")) || ObjectUtils.isEmpty((Object)(asstact = entry.getDynamicObject("e_asstact")))) continue;
                asstactIdList.add(asstact.getLong("id"));
            }
        }
        Map asstactRes = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdList).and("payhold", "=", (Object)Boolean.TRUE)});
        if (!ObjectUtils.isEmpty((Object)asstactRes)) {
            for (ExtendedDataEntity data : datas) {
                StringBuilder totalMsg = new StringBuilder();
                DynamicObject bill = data.getDataEntity();
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                boolean isPayHold = false;
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    if ("bd_supplier".equals(entry.getString("e_asstacttype"))) {
                        DynamicObject asstact = entry.getDynamicObject("e_asstact");
                        if (ObjectUtils.isEmpty((Object)asstact)) continue;
                        if (asstactRes.containsKey(asstact.getLong("id"))) {
                            String asstactName = asstact.getString("name");
                            String errorMessageTemplate = ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$d\u884c\uff0c\u6536\u6b3e\u4f9b\u5e94\u5546\u201c%2$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"SupplierPayHoldValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                            totalMsg.append(String.format(errorMessageTemplate, i + 1, asstactName, operateKey));
                            isPayHold = true;
                        }
                    }
                    if (i >= entries.size() - 2) continue;
                    totalMsg.append('\n').append(data.getBillNo()).append("\uff1a ");
                }
                if (!isPayHold) continue;
                this.addMessage(data, totalMsg.toString());
            }
        }
    }
}

