/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.vo.AcctAgeGroup;

public class AcctAgeAnalysisPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.drawChart();
        }
    }

    private void drawChart() {
        PointLineChart customchart = this.getMainChart();
        customchart.clearData();
        List<GroupInfo> analysisGroups = this.getData();
        ArrayList<String> demensions = new ArrayList<String>(analysisGroups.size());
        ArrayList<Number> countList = new ArrayList<Number>(analysisGroups.size());
        ArrayList<Number> amountList = new ArrayList<Number>(analysisGroups.size());
        for (GroupInfo group : analysisGroups) {
            demensions.add(group.getName());
            countList.add(group.count);
            amountList.add(group.amount);
        }
        Axis categoryAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u5206\u7ec4", (String)"AcctAgeAnalysisPlugin_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), true);
        categoryAxis.setCategorys(demensions);
        this.createValueAxis(ResManager.loadKDString((String)"\u7b14", (String)"AcctAgeAnalysisPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), false);
        LineSeries countSeries = this.createLineSeries(ResManager.loadKDString((String)"\u5e94\u4ed8\u7b14\u6570", (String)"AcctAgeAnalysisPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), countList, "#CC00CC");
        countSeries.setYAxisIndex(0);
        this.createValueAxis(ResManager.loadKDString((String)"\u4e07", (String)"AcctAgeAnalysisPlugin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), false);
        LineSeries amountSeries = this.createLineSeries(ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d\uff08\u4e07\uff09", (String)"AcctAgeAnalysisPlugin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), amountList, "#39bdb9");
        amountSeries.setYAxisIndex(1);
        customchart.setMargin(Position.right, "50px");
        customchart.setMargin(Position.top, "60px");
        customchart.refresh();
    }

    private List<GroupInfo> getData() {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)RequestContext.get().getOrgId()), new QFilter("settlestatus", "!=", (Object)"settled"), new QFilter("billstatus", "=", (Object)"C")};
        List<GroupInfo> analysisGroups = this.getAnalysisGroups();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_finapbill", (String)"unsettleamount,duedate", (QFilter[])filters, (String)"duedate desc");){
            BigDecimal tenThousand = new BigDecimal(10000);
            dataSet.forEach(row -> {
                GroupInfo group = this.matchGroup(analysisGroups, row.getDate("duedate"));
                BigDecimal unsettleAmount = row.getBigDecimal("unsettleamount").divide(tenThousand, 2, RoundingMode.HALF_UP);
                group.addAmount(unsettleAmount);
                ++group.count;
            });
        }
        return analysisGroups;
    }

    private GroupInfo matchGroup(List<GroupInfo> groups, Date dueDate) {
        for (GroupInfo group : groups) {
            if (!group.match(dueDate)) continue;
            return group;
        }
        return null;
    }

    private List<GroupInfo> getAnalysisGroups() {
        return GroupInfo.getDefaultGroups();
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private LineSeries createLineSeries(String name, List<Number> values, String color) {
        LineSeries expireSeries = this.getMainChart().createSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
        return expireSeries;
    }

    private PointLineChart getMainChart() {
        return (PointLineChart)this.getControl("pointlinechartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private static class GroupInfo {
        protected AcctAgeGroup group;
        protected BigDecimal amount = BigDecimal.ZERO;
        protected int count = 0;

        public GroupInfo(AcctAgeGroup group) {
            this.group = group;
        }

        public void addAmount(BigDecimal amount) {
            this.amount = this.amount == null ? amount : this.amount.add(amount);
        }

        public boolean match(Date dueDate) {
            return this.group.match(dueDate);
        }

        public String getName() {
            return this.group.getName();
        }

        public static List<GroupInfo> getDefaultGroups() {
            ArrayList<GroupInfo> defaultGroups = new ArrayList<GroupInfo>();
            Date compareDate = new Date();
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"\u672a\u5230\u671f", (String)"AcctAgeAnalysisPlugin_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), null, Integer.valueOf(0), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"1\u523030\u5929", (String)"AcctAgeAnalysisPlugin_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(1), Integer.valueOf(30), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"31\u523090\u5929", (String)"AcctAgeAnalysisPlugin_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(31), Integer.valueOf(90), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"91\u5230180\u5929", (String)"AcctAgeAnalysisPlugin_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(91), Integer.valueOf(180), compareDate)));
            defaultGroups.add(new GroupInfo(new AcctAgeGroup(ResManager.loadKDString((String)"181\u4ee5\u4e0a", (String)"AcctAgeAnalysisPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(181), null, compareDate)));
            return defaultGroups;
        }
    }
}

