/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class ApBalanceRankingPlugin
extends AbstractFormPlugin {
    private static final int MAX_SHOW_COUNT = 5;

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.fillDefaultValue();
            this.drawChart();
        }
    }

    private void fillDefaultValue() {
        String dueDateStr = this.getFromParentPageCache("duedate");
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isBlank((CharSequence)dueDateStr)) {
            this.getModel().setValue("duedate", (Object)new Date(Long.parseLong(dueDateStr)));
        } else {
            this.getModel().setValue("duedate", (Object)new Date());
        }
        if (!StringUtils.isEmpty((CharSequence)startDateStr) && !StringUtils.isEmpty((CharSequence)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            this.getModel().setValue("startdate", (Object)DateUtils.getLastMonthDate((Date)new Date()));
            this.getModel().setValue("enddate", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)false));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        String key = e.getProperty().getName();
        if ("duedate".equals(key)) {
            date = (Date)this.getModel().getValue(key);
            if (date != null) {
                this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
            }
            this.drawChart();
        }
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            this.drawChart();
        }
    }

    private void drawChart() {
        BarChart customchart = this.getMainChart();
        customchart.clearData();
        Date dueDate = (Date)this.getModel().getValue("duedate");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        LinkedHashMap<String, BigDecimal> asstactBalanceInfos = this.getData(dueDate, startDate, endDate);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Number> values = new ArrayList<Number>();
        asstactBalanceInfos.forEach((asstactName, unsettleAmount) -> {
            keys.add((String)asstactName);
            values.add((Number)unsettleAmount);
        });
        if (ObjectUtils.isEmpty(asstactBalanceInfos)) {
            keys.add(0, "      ");
            values.add(0, null);
        }
        Collections.reverse(keys);
        Collections.reverse(values);
        this.createCategoryAxis(ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ApBalanceRankingPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), keys, false);
        this.createValueAxis(ResManager.loadKDString((String)"\u4e07", (String)"ApBalanceRankingPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), true);
        this.createBarSeries(ResManager.loadKDString((String)"\u5e94\u4ed8\u6b3e\u4f59\u989d", (String)"ApBalanceRankingPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), values, "#1E90FF");
        customchart.setMargin(Position.right, "100px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, BigDecimal> getData(Date dueDate, Date startDate, Date endDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
        filters.add(new QFilter("settlestatus", "!=", (Object)"settled"));
        filters.add(new QFilter("unsettleamount", ">", (Object)0));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (dueDate != null) {
            dueDate = DateUtils.getDataFormat((Date)dueDate, (boolean)false);
            filters.add(new QFilter("duedate", "<=", (Object)dueDate).or("duedate", "is null", null));
        }
        if (startDate != null && endDate != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        }
        LinkedHashMap<String, BigDecimal> results = new LinkedHashMap<String, BigDecimal>();
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)"ApBalanceRankingPlugin.QueryFinBill", (String)"ap_finapbill", (String)"asstacttype,asstact,asstactname,unsettleamount", (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = dataSet.groupBy(new String[]{"asstacttype", "asstact"}).sum("unsettleamount").finish();
            dataSet = dataSet.orderBy(new String[]{"unsettleamount desc"});
            BigDecimal tenThousand = new BigDecimal(10000);
            int count = 0;
            int maxShowLength = 4;
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext() && count < 5) {
                ILocaleString asstactLocalename;
                Row row = (Row)iterator.next();
                String asstactname = null;
                String asstactType = row.getString("asstacttype");
                DynamicObject asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getLong("asstact"), (String)asstactType, (String)"simplename, name");
                if (asstact == null) continue;
                if (("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) && !ObjectUtils.isEmpty((Object)(asstactLocalename = asstact.getLocaleString("simplename")))) {
                    asstactname = asstactLocalename.toString();
                }
                if (ObjectUtils.isEmpty(asstactname)) {
                    asstactname = asstact.getLocaleString("name").toString();
                    asstactname = ObjectUtils.isEmpty((Object)asstactname) ? "NULL" : asstactname.substring(0, asstactname.length() > maxShowLength ? maxShowLength : asstactname.length());
                }
                if (results.containsKey(asstactname)) {
                    asstactname = asstact.getLocaleString("name").toString();
                }
                BigDecimal unSettleAmount = row.getBigDecimal("unsettleamount").divide(tenThousand, 2, RoundingMode.HALF_UP);
                results.put(asstactname, unSettleAmount);
                ++count;
            }
        }
        return results;
    }

    private Axis createCategoryAxis(String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setBarWidth("8px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private BarChart getMainChart() {
        return (BarChart)this.getControl("barchartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }
}

