/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.formplugin.ApBaseEdit;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.intertax.InterTaxGTEHelper;

@Deprecated
public class ApBusBillEdit
extends ApBaseEdit {
    private static final String[] HEAD = new String[]{"amount", "tax", "pricetaxtotal", "taxlocamt", "uninvoicedamt", "localamt", "pricetaxtotalbase", "uninvoicedlocamt", "invoicedamt", "invoicedlocamt"};
    private static final String[] ENTRY = new String[]{"e_uninvoicedqty", "e_invoicedqty", "e_ispresent", "e_unitprice", "taxrateid", "e_taxrate", "e_taxunitprice", "e_tax", "e_taxlocalamt", "e_discountamount", "e_discountlocalamt", "e_actunitprice", "e_acttaxunitprice", "e_amount", "e_localamt", "e_pricetaxtotal", "e_pricetaxtotalbase", "e_invoicedamt", "e_invoicedlocamt", "e_uninvoicedamt", "e_uninvoicedlocamt"};
    private static final String[] PLANENTITY = new String[]{"planpricetax", "planpricetaxloc", "p_invoicedamt", "p_invoicedlocamt", "p_uninvoicedamt", "p_uninvoicedlocamt"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterMaterial();
        this.filterMaterialVersion();
        this.filterMeasureUnit();
        this.addClickListeners(new String[]{"e_corebillno"});
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_corebillno": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                String coreBillType = (String)this.getModel().getValue("e_corebilltype", row);
                ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
            }
        }
    }

    private void filterMaterial() {
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            String number = billtype.getString("number");
            QFilter filter = null;
            if ("ap_busbill_stadpur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"1");
            } else if ("ap_busbill_feepur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"7");
            } else if ("ap_busbill_serpur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"9");
            }
            ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            parameter.getQFilters().add(filter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        long settleTypeId;
        super.afterCreateNewData(e);
        this.cacheIsPeriod();
        this.verifyInit(true, false);
        if (this.isPeriod()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_track", "bar_generatevoucher"});
        }
        if ((settleTypeId = ArApSettleTypeHelper.getDefaultSettleType()) != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.cacheIsPeriod();
        Object billStatus = this.getModel().getValue("billstatus");
        if (!ObjectUtils.isEmpty((Object)billStatus) && BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.verifyInit(false, false);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.cacheIsPeriod();
        if (this.isBotpNew() && this.verifyInit(true, true)) {
            IDataModel m = this.getModel();
            this.calculateAmt(m, -1);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.cacheIsPeriod();
        this.verifyInit(true, false);
        int entryCount = this.getModel().getEntryRowCount("entry");
        for (int row = 0; row < entryCount; ++row) {
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("e_quantity", row);
            this.getModel().setValue("e_uninvoicedqty", (Object)quantity, row);
            BigDecimal payAmt = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", row);
            BigDecimal payLocalAmt = (BigDecimal)this.getModel().getValue("e_pricetaxtotalbase", row);
            this.getModel().setValue("e_uninvoicedamt", (Object)payAmt, row);
            this.getModel().setValue("e_uninvoicedlocamt", (Object)payLocalAmt, row);
        }
        this.calculateHeadAmt();
        int planCount = this.getModel().getEntryRowCount("planentity");
        for (int row = 0; row < planCount; ++row) {
            BigDecimal planpricetax = (BigDecimal)this.getModel().getValue("planpricetax", row);
            BigDecimal planpricetaxloc = (BigDecimal)this.getModel().getValue("planpricetaxloc", row);
            this.getModel().setValue("p_uninvoicedamt", (Object)planpricetax, row);
            this.getModel().setValue("p_uninvoicedlocamt", (Object)planpricetaxloc, row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int index = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        switch (key) {
            case "bizdate": {
                this.bizDateChanged();
                break;
            }
            case "exratedate": {
                if (Objects.isNull(newValue)) {
                    m.setValue("exratedate", (Object)new Date());
                    return;
                }
                this.setExchange(newValue, oldValue);
                break;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    this.setExchange(newValue, oldValue);
                    break;
                }
                m.setValue("exratetable", oldValue);
                break;
            }
            case "exchangerate": {
                this.calculateAmt(m, -1);
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    m.setValue("currency", oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o > (n = ((DynamicObject)newValue).getInt("priceprecision"))) {
                    for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                        this.initPrice(m, o, n, i);
                    }
                }
                this.setExchange(newValue, oldValue);
                break;
            }
            case "e_material": {
                DynamicObject material = (DynamicObject)newValue;
                if (ObjectUtils.isEmpty((Object)material)) break;
                if (material.getDynamicObject("baseunit") != null) {
                    this.getModel().setValue("e_spectype", (Object)material.getString("modelnum"), index);
                    this.getModel().setValue("e_measureunit", material.getDynamicObject("baseunit").getPkValue(), index);
                    this.getModel().setValue("e_baseunit", material.getDynamicObject("baseunit").getPkValue(), index);
                    this.getModel().setValue("e_baseunitqty", this.getModel().getValue("e_quantity", index), index);
                    this.getModel().setValue("e_unitcoefficient", (Object)BigDecimal.ONE, index);
                }
                if (material.getDynamicObject("taxrate") == null) break;
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                IDataModel model = this.getModel();
                model.setValue("taxrateid", taxrateId, index);
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty();
                break;
            }
            case "e_quantity": {
                this.calculateBaseQty();
            }
            case "e_unitprice": 
            case "e_taxrate": 
            case "e_taxunitprice": 
            case "e_discountmode": {
                if ("NULL".equals(m.getValue("e_discountmode", index))) {
                    this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                }
            }
            case "e_discountrate": {
                if ("e_discountrate".equals(key)) {
                    String discountmode = (String)m.getValue("e_discountmode", index);
                    BigDecimal discountrate = (BigDecimal)m.getValue("e_discountrate", index);
                    if (DiscountModeEnum.PERCENT.getValue().equals(discountmode) && discountrate.compareTo(new BigDecimal(100)) > 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u6570\u5b57\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"ApBusBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                        m.setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                        return;
                    }
                }
                this.calculateAmt(m, index);
                break;
            }
            case "e_tax": 
            case "e_amount": 
            case "e_pricetaxtotal": {
                this.calculateHeadAmt();
                break;
            }
            case "taxrateid": {
                this.calculateAmt(m, index);
                break;
            }
            case "asstact": {
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
            }
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), e);
        interTaxGTEHelper.propertyChanged_taxentry();
    }

    private void calculateAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            this.calculatorEntryAmt(m, index);
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i);
            }
        }
        this.calculateHeadAmt();
        m.endInit();
        IFormView v = this.getView();
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
        for (int i = 0; i < m.getEntryRowCount("planentity"); ++i) {
            for (String p : PLANENTITY) {
                v.updateView(p, i);
            }
        }
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        if (includeTax) {
            BigDecimal oldtaxunitprice = (BigDecimal)m.getValue("e_taxunitprice", currentRow);
            m.setValue("e_taxunitprice", (Object)oldtaxunitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        } else {
            BigDecimal oldUnitprice = (BigDecimal)m.getValue("e_unitprice", currentRow);
            m.setValue("e_unitprice", (Object)oldUnitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        }
    }

    private void calculatorEntryAmt(IDataModel m, int index) {
        PriceLocalCalculator localCalculator = null;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void setExchange(Object newValue, Object oldValue) {
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Date exrateDate = (Date)this.getModel().getValue("exratedate");
        if (destCurrency == null || srcCurrency == null || exratetable == null) {
            return;
        }
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exratetableId = exratetable.getLong("id");
        this.getView().setEnable(Boolean.valueOf(srcCurrencyId != destCurrencyId), new String[]{"exchangerate"});
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
        if (exchangeRate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"ApBusBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void calculateBaseQty() {
        int rowIndex;
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex = model.getEntryCurrentRowIndex("entry"));
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
            }
        }
    }

    private void bizDateChanged() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date dueDate = (Date)this.getModel().getValue("duedate");
        if (dueDate != null && bizDate != null && dueDate.compareTo(bizDate) < 0) {
            this.getModel().setValue("duedate", (Object)bizDate);
        }
    }

    private void calculateHeadAmt() {
        IDataModel m = this.getModel();
        int count = m.getEntryRowCount("entry");
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocal = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            payAmount = payAmount.add((BigDecimal)m.getValue("e_pricetaxtotal", i));
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocal = taxlocal.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)m.getValue("e_pricetaxtotalbase", i));
            uninvoicedlocamt = uninvoicedlocamt.add((BigDecimal)m.getValue("e_uninvoicedlocamt", i));
        }
        m.setValue("pricetaxtotal", (Object)payAmount);
        m.setValue("amount", (Object)amount);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocal);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("localamt", (Object)localamt);
        m.setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        m.setValue("uninvoicedlocamt", (Object)uninvoicedlocamt);
        int planentityRowCount = m.getEntryRowCount("planentity");
        if (planentityRowCount == 1) {
            m.setValue("planpricetax", (Object)payAmount, 0);
            m.setValue("planpricetaxloc", (Object)pricetaxtotalbase, 0);
            m.setValue("p_uninvoicedamt", (Object)uninvoicedamt, 0);
            m.setValue("p_uninvoicedlocamt", (Object)uninvoicedlocamt, 0);
        }
    }

    private boolean verifyInit(boolean updateBizDate, boolean isBotpNew) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApBusBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return false;
        }
        InitHelper init = new InitHelper(org.getLong("id"), "ap_init");
        if (ObjectUtils.isEmpty((Object)init.getStartDate())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ApBusBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_track", "bar_generatevoucher"});
            return false;
        }
        Object currency = this.getModel().getValue("currency");
        Object baseCurrency = this.getModel().getValue("basecurrency");
        Object exchangeTable = this.getModel().getValue("exratetable");
        if (ObjectUtils.isEmpty((Object)currency)) {
            this.getModel().setValue("currency", (Object)init.getStandardCurrency());
        }
        if (ObjectUtils.isEmpty((Object)baseCurrency)) {
            this.getModel().setValue("basecurrency", (Object)init.getStandardCurrency());
        }
        if (ObjectUtils.isEmpty((Object)exchangeTable)) {
            this.getModel().setValue("exratetable", init.getExrateTable().getPkValue());
        }
        boolean isPeriod = this.isPeriod();
        if (isBotpNew) {
            isPeriod = init.isFinishInit() ? false : (Boolean)this.getModel().getValue("isperiod");
        }
        this.getModel().setValue("isperiod", (Object)isPeriod);
        Date currentDate = init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = init.getStartDate();
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        if (isPeriod) {
            if (init.isFinishInit()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ApBusBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
                return false;
            }
            Date lastStartDate = DateUtils.getLastDay((Date)init.getStartDate(), (int)1);
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            int diffDays = 0;
            if (!ObjectUtils.isEmpty((Object)bizDate)) {
                diffDays = DateUtils.getDiffDays((Date)lastStartDate, (Date)bizDate);
            }
            if (updateBizDate && diffDays >= 0) {
                this.getModel().setValue("bizdate", (Object)lastStartDate);
            }
            bizdate.setMaxDate(lastStartDate);
        } else {
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                currentDate = init.getStartDate();
            }
            bizdate.setMinDate(currentDate);
        }
        return true;
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        BigDecimal pricetaxtotal = localCalculator.getPricetaxtotal();
        m.setValue("e_pricetaxtotal", (Object)pricetaxtotal, index);
        m.setValue("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal(), index);
        m.setValue("e_uninvoicedamt", (Object)pricetaxtotal, index);
        m.setValue("e_uninvoicedlocamt", (Object)localCalculator.getPricetaxtotallocal(), index);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "deleteentry": {
                this.calculateHeadAmt();
                break;
            }
            case "audit": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (ObjectUtils.isEmpty((Object)org)) break;
                int woffStatus = SystemParameterHelper.getParameterInteger((long)((Long)org.getPkValue()), (String)"ap_004");
                if (woffStatus == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_woff"});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_woff"});
            }
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), afterDoOperationEventArgs.getOperateKey());
        interTaxGTEHelper.afterDoOperation();
    }

    protected void cacheIsPeriod() {
        this.getPageCache().put("isPeriod", "false");
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            String value = Boolean.toString((Boolean)parameter.getCustomParam("isPeriod"));
            this.getPageCache().put("isPeriod", value);
        }
    }

    protected boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "bar_woff": {
                OperateOption option = OperateOption.create();
                option.setVariableValue("type", "edit");
                this.getView().invokeOperation("woff", option);
            }
        }
    }
}

