/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.formplugin.ApCoreBillList;
import kd.fi.ap.formplugin.formservice.bus.BusApBillRevaluationHelper;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;

public class ApBusBillList
extends ApCoreBillList {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        this.getPageCache().put("isPeriod", "false");
        if (param.getCustomParam("isPeriod") != null) {
            this.getPageCache().put("isPeriod", "true");
            this.getView().setVisible(Boolean.FALSE, new String[]{"push", "tbltrack", "tblgeneratevoucher", "tblwoff", "tblbatchwoff", "tbl_woff", "matchverify"});
        }
    }

    protected boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter;
        Object checkKey;
        super.setFilter(e);
        e.setOrderBy("bizdate desc,id desc");
        if (this.isPeriod()) {
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        if (!EmptyUtils.isEmpty((Object)(checkKey = (listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("checkKey")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            List qFilters = e.getQFilters();
            e.setMainOrgQFilter(null);
            qFilters.removeIf(filter -> !"billno".equals(filter.getProperty()));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        boolean isPeriod;
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
            isPeriod = this.isPeriod();
        } else {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)parameter.getPkId(), (String)"ap_busbill");
            isPeriod = bill.getBoolean("isperiod");
        }
        parameter.setCustomParam("isPeriod", (Object)isPeriod);
        if (isPeriod) {
            parameter.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355", (String)"ApBusBillList_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("matchverify".equals(key)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
            if (bills.length < 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e24\u6761\u8bb0\u5f55\u8fdb\u884c\u7ea2\u84dd\u51b2\u56de\u3002", (String)"ApBusBillList_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            Set orgIds = Arrays.stream(bills).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
            boolean isHasVerifyPerm = BaseDataHelper.checkCurrentUserPermission((String)"ap", (String)"ap_busbill", (String)"/O6=C3IJCQI8", orgIds);
            if (!isHasVerifyPerm) {
                if (orgIds.size() == 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6682\u4f30\u5e94\u4ed8\u5355\u201d\u7684\u201c\u6838\u9500\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApBusBillList_11", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u201c\u6682\u4f30\u5e94\u4ed8\u5355\u201d\u7684\u201c\u6838\u9500\u201d\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApBusBillList_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            HashSet<Boolean> isBaseSet = new HashSet<Boolean>(1);
            for (DynamicObject bill2 : bills) {
                DynamicObject payProperty = bill2.getDynamicObject("payproperty");
                isBaseSet.add(payProperty.getBoolean("isbasedonamt"));
            }
            if (isBaseSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u57fa\u51c6\u7684\u5355\u636e\u8fdb\u884c\u6682\u4f30\u7ea2\u84dd\u51b2\u56de\u3002", (String)"ApBusBillList_9", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            String message = ResManager.loadKDString((String)"\u6682\u4f30\u7ea2\u84dd\u51b2\u56de\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApBusBillList_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
        } else if ("tblbatchwoff".equals(key)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                String billStatus = listSelectedRow.getBillStatus();
                if (!"B".equals(billStatus) && !"A".equals(billStatus)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838", (String)"ApBusBillList_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            List<Object> busBillIds = Arrays.asList(primaryKeyValues);
            this.woffBusBIlls(busBillIds, "batchwoff");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        if ("batchwoff".equals(id) || "matchverify".equals(id)) {
            if (returnData == null) {
                return;
            }
            Map returnMap = (Map)returnData;
            List busIds = (List)returnMap.get("ids");
            String bizDate = (String)returnMap.get("bizdate");
            String operation = (String)returnMap.get("opreation");
            this.invokeWoff(busIds, bizDate, operation);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("matchverify".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            this.woffBusBIlls(Arrays.asList(primaryKeyValues), "matchverify");
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ap_busbill", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        Object[] pks;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("copy".equals(key)) {
            this.copy(args);
        } else if (Objects.equals("woff", key) && (pks = (selectedRows = (billList = (BillList)this.getControl("billlistap")).getSelectedRows()).getPrimaryKeyValues()).length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"ApBusBillList_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void copy(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows != null) {
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"ApBusBillList_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else if (pks.length <= 1) {
                DynamicObject org;
                InitHelper initHelper;
                DynamicObject busInfo = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"ap_busbill");
                if (busInfo.getBoolean("isperiod") && (initHelper = new InitHelper((org = busInfo.getDynamicObject("org")).getLong("id"), "ap_init")).isFinishInit()) {
                    String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ApBusBillList_3", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                }
                boolean isPriceTotal = busInfo.getBoolean("ispricetotal");
                DynamicObjectCollection detailEntries = busInfo.getDynamicObjectCollection("entry");
                for (DynamicObject entry : detailEntries) {
                    String discountType = entry.getString("e_discountmode");
                    BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                    boolean isPresent = entry.getBoolean("e_ispresent");
                    if (!isPriceTotal || !"PERCENT".equals(discountType) || new BigDecimal("100").compareTo(discountRate) != 0 || isPresent) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object initOrg = formShowParameter.getCustomParam("initOrg");
        if (!ObjectUtils.isEmpty((Object)initOrg)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().equals("org.name")) continue;
                commonFilter.setDefaultValue(initOrg.toString());
                break;
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("asstact.name".equals(fieldName) || "asstact.number".equals(fieldName)) {
            args.getQfilters().add(new QFilter("status", "=", (Object)"C"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object op = e.getSource();
        String key = ((AbstractOperate)op).getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ("reval".equals(key)) {
            if (!operationResult.isSuccess()) {
                return;
            }
            ListSelectedRowCollection rows = this.getSelectedRows();
            if (rows.getPrimaryKeyValues().length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"ApBusBillList_14", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else {
                Long id = (Long)rows.get(0).getPrimaryKeyValue();
                IFormView parentView = this.getView();
                BusApBillRevaluationHelper.validator(id, parentView);
            }
        }
        if ("woff".equals(key)) {
            if (operationResult.isSuccess()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isselfwoff", "true");
                option.setVariableValue("woffmode", "part");
                this.getView().invokeOperation("pushwoff", option);
            } else if (operationResult.getValidateResult().errorSize() > 1) {
                e.getOperationResult().setShowMessage(false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u51b2\u56de\u3002", (String)"ApBusBillList_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        } else if ("batchwoff".equals(key)) {
            if (operationResult.getSuccessPkIds().size() > 0) {
                this.getView().invokeOperation("refresh");
            }
        } else if ("matchverify".equals(key) && operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ea2\u84dd\u51b2\u56de\u6210\u529f\u3002", (String)"ApBusBillList_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("submit".equals(key) && operationResult.isSuccess()) {
            int i;
            List billIds = operationResult.getSuccessPkIds();
            List warnMessages = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0067", new ArrayList(2), (Object[])new Object[]{billIds});
            List revalMessages = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0124", new ArrayList(2), (Object[])new Object[]{billIds});
            StringBuilder builder = null;
            if (!ObjectUtils.isEmpty((Object)warnMessages)) {
                builder = new StringBuilder();
                i = 0;
                for (String warnMessage : warnMessages) {
                    builder.append(warnMessage);
                    if (++i == warnMessages.size()) continue;
                    builder.append('\n');
                }
            }
            if (!ObjectUtils.isEmpty((Object)revalMessages)) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                i = 0;
                for (String warnMessage : revalMessages) {
                    builder.append(warnMessage);
                    if (++i == revalMessages.size()) continue;
                    builder.append('\n');
                }
            }
            if (builder != null) {
                this.getView().showTipNotification(builder.toString(), Integer.valueOf(30000));
            }
        }
    }

    private void woffBusBIlls(List<Object> successPkIds, String operation) {
        ArrayList woffBillBookDates = new ArrayList(successPkIds.size());
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,org.id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)});
        HashMap<Long, Date> needSelect1 = new HashMap<Long, Date>(2);
        HashMap<Long, Date> needSelect2 = new HashMap<Long, Date>(2);
        HashMap<Long, Date> orgCurDateMap = new HashMap<Long, Date>(2);
        HashMap<Long, Date> billOrgDateMap = new HashMap<Long, Date>(2);
        Date currentDate = new Date();
        ArrayList<Long> orgidList = new ArrayList<Long>(8);
        for (DynamicObject bill : busBills) {
            Long orgId = bill.getLong("org.id");
            orgidList.add(orgId);
        }
        Map apInit = BusinessDataServiceHelper.loadFromCache((String)"ap_closeaccount", (String)"org.id,currentdate", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgidList)});
        for (Map.Entry entrySet : apInit.entrySet()) {
            Date date = ((DynamicObject)entrySet.getValue()).getDate("currentdate");
            if (date == null) continue;
            orgCurDateMap.put(((DynamicObject)entrySet.getValue()).getLong("org.id"), date);
        }
        for (DynamicObject bill : busBills) {
            HashMap<String, Comparable<Long>> dateMap = new HashMap<String, Comparable<Long>>(2);
            Long orgId = bill.getLong("org.id");
            Date bookDate = bill.getDate("bookdate");
            Long billId = bill.getLong("id");
            Date curDate = (Date)orgCurDateMap.get(orgId);
            if (curDate == null) {
                if (bookDate.before(currentDate)) {
                    dateMap.put("id", Long.valueOf(bill.getLong("id")));
                    dateMap.put("bizdate", currentDate);
                    dateMap.put("bookdate", currentDate);
                    woffBillBookDates.add(dateMap);
                    continue;
                }
                dateMap.put("id", Long.valueOf(bill.getLong("id")));
                dateMap.put("bizdate", bookDate);
                dateMap.put("bookdate", bookDate);
                woffBillBookDates.add(dateMap);
                continue;
            }
            if (!bookDate.before(currentDate) && !bookDate.before(curDate)) {
                dateMap.put("id", Long.valueOf(bill.getLong("id")));
                dateMap.put("bizdate", bookDate);
                dateMap.put("bookdate", bookDate);
                woffBillBookDates.add(dateMap);
                continue;
            }
            if (!curDate.before(bookDate) && !curDate.before(currentDate)) {
                dateMap.put("id", Long.valueOf(bill.getLong("id")));
                dateMap.put("bizdate", curDate);
                dateMap.put("bookdate", curDate);
                woffBillBookDates.add(dateMap);
                continue;
            }
            if (currentDate.before(curDate) || currentDate.before(bookDate)) continue;
            if (!curDate.before(bookDate)) {
                if (this.isSameMonth(currentDate, curDate)) {
                    dateMap.put("id", Long.valueOf(bill.getLong("id")));
                    dateMap.put("bizdate", currentDate);
                    dateMap.put("bookdate", currentDate);
                    woffBillBookDates.add(dateMap);
                    continue;
                }
                needSelect1.put(bill.getLong("id"), bookDate);
                billOrgDateMap.put(bill.getLong("id"), curDate);
                continue;
            }
            if (this.isSameMonth(currentDate, curDate)) {
                dateMap.put("id", Long.valueOf(bill.getLong("id")));
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBookDates.add(dateMap);
                continue;
            }
            if (this.isSameMonth(currentDate, bookDate)) {
                dateMap.put("id", Long.valueOf(bill.getLong("id")));
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBookDates.add(dateMap);
                continue;
            }
            needSelect2.put(bill.getLong("id"), bookDate);
            billOrgDateMap.put(bill.getLong("id"), curDate);
        }
        if (needSelect1.size() > 0 || needSelect2.size() > 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("woffBillBookDates", woffBillBookDates);
            parameter.setCustomParam("needSettle1", needSelect1);
            parameter.setCustomParam("needSettle2", needSelect2);
            parameter.setCustomParam("billorgdate", billOrgDateMap);
            parameter.setCustomParam("ids", successPkIds);
            parameter.setCustomParam("operation", (Object)operation);
            parameter.setCustomParam("orgcurdate", orgCurDateMap);
            parameter.setCustomParam("entityflag", (Object)"ap");
            parameter.setFormId("ap_offset_date");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operation));
            this.getView().showForm(parameter);
        } else {
            String bizDate = SerializationUtils.toJsonString(woffBillBookDates);
            this.invokeWoff(successPkIds, bizDate, operation);
        }
    }

    private void invokeWoff(List<Object> busIds, String bizDate, String operation) {
        String ids = SerializationUtils.toJsonString(busIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue("entity", "ap_busbill");
        option.setVariableValue("ids", ids);
        option.setVariableValue("bizdate", bizDate);
        this.getView().invokeOperation(operation, option);
    }

    public boolean isSameMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        return year1 == year2 && month1 == month2;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isPeriod()) {
            List listColumns = args.getListColumns();
            for (int i = listColumns.size() - 1; i >= 0; --i) {
                IListColumn column = (IListColumn)listColumns.get(i);
                if (!"isvoucher".equals(column.getListFieldKey())) continue;
                listColumns.remove(column);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean needTax = TaxHelper.isNeedTax((long)RequestContext.get().getOrgId(), (boolean)false);
        if (needTax) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"batchcalculatetaxcbtn"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchcalculatetaxcbtn"});
        }
        OperationUtils.setListButtonUnvisibleByAppId((String)"ap_busbill", (IFormView)this.getView());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected boolean isOnlyPK4SelectedAllRows() {
                ListShowParameter listShowParameter = (ListShowParameter)ApBusBillList.this.getView().getFormShowParameter();
                return !listShowParameter.isLookUp();
            }
        });
    }
}

